#include <stdio.h>
#include <stdlib.h>
#include "asm.h"

// This program read characters from keyboard and output them to console

int main(int argc, char*argv[]) {
  init(argc, argv);

  Label loop= getLabel("loop");
                      // Assembler syntax  # C syntax
  movi(TERM, R1);     //   mov TERM, R1    # char *term= (char*)TERM; 
                      //                   #             // terminal port
                      //                   # char c;
                      //                   # for (;;) {
  setLabel(loop);     // loop:             #   do { // read keyboard
  ldsb(R1, 0, R0);    //   ldsb R1, 0, R0  #     c= *term; // negative if
                      //                   #               // nothing read
  bli(R0, 0, loop);   //   bl R0, 0, loop  #   } while (c<0); // busy-wait
  stb(R0, R1, 0);     //   stb R0, R1[0]   #   *term= c; // write to console
  ba(loop);           //   ba loop         # }

  finish();
  return 0;
}
