#define _XOPEN_SOURCE 500
#include <stdio.h>
#include <stdlib.h>
#include "asm.h"

// Este programa detecta la memoria RAM instalada en M16

// Constantes

// Tamanno del espacio de memoria direccionable por M16: 64 KB
#define SIZMEMSPACE (1<<16)

// Numero de escrituras en memoria
#define SIZDATA 64

// Separacion entre direcciones de cada escritura
#define DIRINC (SIZMEMSPACE/SIZDATA)
// El programa escribira en 0, DIRINC, DIRINC*2, ..., etc.
// Si posteriormente lee el mismo contenido escrito, quiere decir que hay RAM.
// El minimo tamanno de RAM detectable es DIRINC.

// Funciones auxiliares
int valAleaUnico();

int main(int argc, char *argv[]) {
  init(argc, argv);

  // Funciones de biblioteca (estan implementadas en asm.c)
  Label printStr= getLabel("printStr");
  Label printHexa= getLabel("printHexa");

  // Etiquetas para datos en la ROM
  Label inimsg= getLabel("inimsg");
  Label rdata= getLabel("rdata");
  Label edata= getLabel("edata");
  Label memmsg= getLabel("memmsg");
  Label dash= getLabel("dash");
  Label newline= getLabel("newline");

  // Etiquetas del codigo en assembler M16
  Label start= getLabel("start");
  Label loopw= getLabel("loopw");
  Label loopr1= getLabel("loopr1");
  Label notequal= getLabel("notequal");
  Label loopr2= getLabel("loopr2");
  Label chkmem= getLabel("chkmem");
  Label prtmem= getLabel("prtmem");

                      // Assembler syntax  # C syntax

                      //                   # main() {
                      //   # R7 es el stack pointer y apunta al tope de la RAM
  subi(R7, 16, R7);   //   sub R7, 8, R7   # // Crea registro de activacion

                      //   # Todavia no hay instruccion de detencion, de modo
                      //   # que se repite la ejecucion del programa por siempre
  setLabel(start);    // start:            # start:
                      //   # Los parametros se pasan en R1, R2, R3, etc.
  mova(inimsg, R1);   //   mov inimsg, R1  # printStr(
  call(printStr);     //   call printStr   #      "Buscando RAM en 0-FFFF\n");
                      //   # Si hay valor de retorno, viene en R1
  movi(0, R1);        //   mov 0, R1       # int *p= (int*)0;
  mova(rdata, R2);    //   mov rdata, R2   # int *q= rdata
  mova(edata, R3);    //   mov edata, R3   # int *end= &rdata[SIZDATA]

  setLabel(loopw);    // loopw:            # do {
  ldw(R2, 0, R0);     //   ldw R2[0], R0   #   int data= *q;
  addi(R2, 2, R2);    //   add R2, 2, R2   #   q++;
  stw(R0, R1, 0);     //   stw R0, R1[0]   #   *p= data;
  addi(R1, DIRINC, R1); // add R1, ..., R1 #   p += DIRINC/2;
  bl(R2, R3, loopw);  //   bl R2,R3,loopw  # } while (q<end);
 
  movi(0, R1);        //   mov 0, R1       # p= (int*)0;
  mova(rdata, R2);    //   mov rdata, R2   # q= rdata;

  setLabel(loopr1);   // loopr1:           # do {
                      //                   #   do {
  ldw(R2, 0, R0);     //   ldw R2[0], R0   #     int data= *q;
  ldw(R1, 0, R4);     //   ldw R1[0], R4   #     int ref= *p;
  be(R0, R4, chkmem); //   be R0,R4,chkmem #     if (data==ref) goto chkmem;
  setLabel(notequal); // notequal:
  addi(R2, 2, R2);    //   add R2, 2, R2   #     q++;
  addi(R1, DIRINC, R1); // add R1, ..., R1 #     p += DIRINC/2;
  bl(R2, R3, loopr1); //   bl R2,R3,loopr1 #   } while (q<end);
  ba(start);          //   ba start        #   goto start:
  

  setLabel(chkmem);   // chkmem:           #   chkmem:
  mov(R1, R5);        //   mov R1, R5      #   int *mem= p;
  setLabel(loopr2);   // loopr2:           #   do {
  ldw(R2, 0, R0);     //   ldw R2[0], R0   #     int data= *q;
  ldw(R1, 0, R4);     //   ldw R1[0], R4   #     int ref= *p;
  bne(R0,R4,prtmem);  //   bne R0,R4,prtmem#     if (data!=ref) break;
  addi(R2, 2, R2);    //   add R2, 2, R2   #     q++;
  addi(R1, DIRINC, R1); // add R1, ..., R1 #     p += DIRINC/2;
  bl(R2, R3, loopr2); //   bl R2,R3,loopr2 #   } while (q<end);

  setLabel(prtmem);   // prtmem:
  stw(R1, R7, 0);     //   stw R1, R7[0]   #   sp[0]= p;   // resguardar p
  stw(R2, R7, 5);     //   stw R2, R7[5]   #   sp[5]= q;   // resguardar q
  stw(R3, R7, 6);     //   stw R3, R7[6]   #   sp[6]= end; // resguardar end
  stw(R5, R7, 7);     //   stw R5, R7[7]   #   sp[7]= mem; // resguardar mem
 
  mova(memmsg, R1);   //   mov memmsg, R1  #   printStr("RAM en rango ");
  call(printStr);     //   call printStr

  ldw(R7, 7, R1);     //   ldw R7[0], R1   #   printHexa(mem);
  call(printHexa);    //   call printHexa

  mova(dash, R1);     //   mov dash, R1    #   printStr("-");
  call(printStr);     //   call printStr

  ldw(R7, 0, R1);     //   ldw R7[0], R1   #
  subi(R1, 1, R1);    //   sub R1, 1, R1   #
  call(printHexa);    //   call printHexa  #   printHexa((char*)p-1);

  mova(newline, R1);  //   mov newline, R1 #   printStr("\n");
  call(printStr);     //   call printStr

  ldw(R7, 0, R1);     //  ldw R7[0], R1    #   p= sp[0]   // restaurar p
  ldw(R7, 5, R2);     //  ldw R7[1], R2    #   q= sp[0]   // restaurar q
  ldw(R7, 6, R3);     //  ldw R7[2], R3    #   end= sp[0] // restaurar end

  bl(R2, R3, loopr1); //   bl R2,R3,loopr1 # } while (q<end);

  ba(start);          //   ba start        # goto start;

                      //   .rodata
  setLabel(inimsg);   // inimsg:           # char *inisg="...\n");
  string("Buscando RAM en 0-FFFF\n");
                      //   .string "Buscando RAM en 0-FFFF\n"
  setLabel(memmsg);   // memmsg:           # char *memsg="RAM en rango\n");
  string("RAM en rango ");
                      //   .string "RAM en rango "
  setLabel(dash);     // dash:             # char *dash="-";
  string("-");        //   .string "-"
  setLabel(newline);  // newline:          # char *newline="\n");
  string("\n");       //   .string "\n"
  setLabel(rdata);    // rdata:            # int rdata[SIZDATA] = {
  for (int i=0; i<SIZDATA; i++)
    uword(valAleaUnico()); // .uword ...  #  <numero aleatorio>, ...
  setLabel(edata);    // edata:            # }
  uword(0);           //   .uword 0

  printStrGen();
  printHexaGen();

  finish();
  return 0;
}

char used[SIZMEMSPACE];

int valAleaUnico() {
  for (;;) {
    int val= random() & (SIZMEMSPACE-1); // & 0xffff
    if (used[val])
      continue;
    used[val]= 1;
    return val;
  }
}
