#include <stdio.h>
#include <stdlib.h>
#include "asm.h"

int main(int argc, char*argv[]) {
  init(argc, argv);

  Label start= getLabel("start");
  Label readx= getLabel("readx");
  Label reverse= getLabel("reverse");

                      // Assembler syntax  # C syntax
  movi(TERM, R1);     //   mov TERM, R1    # char *term= (char*)TERM;
                      //                   # int c; // R0
  setLabel(start);    // start:            # for (;;) {
  movi('?', R0);      //   mov '?', RO     #   c= '?';
  stb(R0, R1, 0);     //   stb R0, R1[0]   #   *term= c;
  movi(' ', R0);      //   mov ' ', R0     #   c= ' ';
  stb(R0, R1, 0);     //   stb R0, R1[0]   #   *term= c;
  movi(0, R2);        //   mov 0, R2       #   int x= 0;
                      //                   #   for (;;) {
  setLabel(readx);    // readx:            #     do {
  ldsb(R1, 0, R0);    //   ldsb R1, 0, R0  #       c= *term;
  bli(R0, 0, readx);  //   bl R0, 0        #     } while (c<0);
  stb(R0, R1, 0);     //   stb R0, R1[0]   #     *term= c;
  bei(R0,'\n',reverse); // bei R0,'\n',reverse # if (c=='\n') break;
  muli(R2, 10, R2);   //   mul R2, 10, R2  #     x *= 10;
  add(R2, R0, R2);    //   add R2, R0, R2  #     x += c;
  subi(R2, '0', R2);  //   sub R2, '0', R2 #     x -= '0';
  ba(readx);          //   ba readx        #   }
  setLabel(reverse);  // reverse:          #   do {
  remi(R2, 10, R0);   //   rem R2, 10, R0  #     c = x % 10;
  addi(R0, '0', R0);  //   add R0, '0', R0 #     c += '0';
  stb(R0, R1, 0);     //   stb R0, R1[0]   #     *term= c;
  divi(R2, 10, R2);   //   div R2, 10, R2  #     x /= 10;
  bnei(R2,0,reverse); //   bne R2,0,reverse #  } while(x!=0);
  movi('\n', R0);     //   mov '\n', R0    #   c= '\n';
  stb(R0, R1, 0);     //   stb R0, R1[0]   #   *term= c;
  ba(start);          //   ba start;       # }

  finish();
  return 0;
}
