#include <stdio.h>
#include <stdlib.h>
#include "asm.h"

int main(int argc, char *argv[]) {
  init(argc, argv);

  Label printStr= getLabel("printStr");
  Label hello= getLabel("hello");
  Label sleep= getLabel("sleep");
  Label loop= getLabel("loop");
  Label end= getLabel("end");

                      // Assembler syntax  # C syntax
  mova(hello, R1);    //   mov hello, R1   # extern char *hello; // R1
  call(printStr);     //                   # printStr(hello);
  setLabel(sleep);    // sleep:            # for (;;) { // do nothing
  ba(sleep);          //   ba sleep        # }

  setLabel(printStr); // printStr:         # void printStr(char *s) {
  movi(TERM, R2);     //   mov TERM, R2    #   char *term= (char*)TERM;
  setLabel(loop);     // loop:             #   for (;;) {
  ldsb(R1, 0, R3);    //   ldsb R1[0], R3  #     int c= *s;
  bei(R3, 0, end);    //   be R3, 0, end   #     if (c==0) break;
  stb(R3, R2, 0);     //   stb R3, R2[0]   #     *term= c;
  addi(R1, 1, R1);    //   addi R1, 1, R1  #     s++;
  ba(loop);           //   ba loop         #   }
  setLabel(end);      // end:              #
  ret();              //   ret             # }
  setLabel(hello);    // hello:            # char *hello= "hello world!\n";
  string("hello world!\n");
                      //   .string "hello world!\n"

  finish();
  return 0;
}
