#include <stdio.h>
#include <stdlib.h>
#include "asm.h"

int main(int argc, char *argv[]) {
  init(argc, argv);

  Label printStr= getLabel("printStr");
  Label readUint= getLabel("readUint");
  Label printUint= getLabel("printUint");
  Label prompt= getLabel("prompt");
  Label newline= getLabel("newline");
  Label fib= getLabel("fib");
  Label loop= getLabel("loop");
  Label reccase= getLabel("reccase");

                      // Assembler syntax  # C syntax
  setLabel(loop);     // loop:             # for (;;) {
  mova(prompt, R1);   //   mov prompt, R1  #   extern char *hello; // R1
  call(printStr);     //   call printStr   #   printStr(hello);
  call(readUint);     //   call readUint   #   int n= readUint();
  call(fib);          //   call fib        #   int x= fib(n);
  call(printUint);    //   call printUint  #   printUint(x);
  mova(newline, R1);  //   mov newline, R1 #   extern char *newline;
  call(printStr);     //   call printStr   #   printStr(newline);
  ba(loop);           //   ba loop         # }

  setLabel(prompt);   // prompt:           # char *prompt= "number? ";
  string("number? "); //   .string "number? "
  setLabel(newline);  // newline:          # char *newline= "\n";
  string("\n");       //   .string "\n"

  setLabel(fib);;     // fib:              # int fib(int n) {
  bgi(R1,1,reccase);  //   bg R1,0,reccase #   if (n<=1)
  ret();              //   ret             #     return n;
  setLabel(reccase);  // reccase:          #   else {
  subi(R7, 4, R7);    //   sub R7, 2, R7
  stw(R0, R7, 1);     //   stw R0, R7[1]
  stw(R1, R7, 0);     //   stw R1, R7[0]
  subi(R1, 1, R1);    //   sub R1, 1, R1
  call(fib);          //   call fib        #     int t= fib(n-1);
  ldw(R7, 0, R2);     //   ldw R7[0], R2
  stw(R1, R7, 0);     //   stw R1, R7[0]
  subi(R2, 2, R1);    //   sub R2, 2, R1
  call(fib);          //   call fib        #     int u= fib(n-2);
  ldw(R7, 0, R2);     //   ldw R7[0], R2
  ldw(R7, 1, R0);     //   ldw R7[0], R0
  add(R1, R2, R1);    //   add R1, R2, R1  #     return t+u;
  addi(R7, 4, R7);    //   add R7, 4, R7   #   }
  ret();              //   ret             # }

  printStrGen();
  readUintGen();
  printUintGen();

  finish();
  return 0;
}
