#include "inst.h"

#define R0 (&reg0)
#define R1 (&reg1)
#define R2 (&reg2)
#define R3 (&reg3)
#define R4 (&reg4)
#define R5 (&reg5)
#define R6 (&reg6)
#define R7 (&reg7)

#define SIZEROM (1<<12)
#define ROMINI  ((1<<16)-SIZEROM)
#define SIZERAM (1<<14)
#define TERM    0xeffe

typedef struct node {
  int idx, size;
  struct node *next;
} Node;

typedef struct label {
  int idx;
  char *name;
  Node *pend; 
  struct label *next;
} *Label;

typedef struct {
  char r;
} Reg;

void init(int argc, char *argv[]);
void finish();
Label getLabel(char *name);
void setLabel(Label label);

extern Reg reg0;
extern Reg reg1;
extern Reg reg2;
extern Reg reg3;
extern Reg reg4;
extern Reg reg5;
extern Reg reg6;
extern Reg reg7;

void mov(Reg *rs2, Reg *rd);
void movi(int val, Reg *rd);
void mova(Label label, Reg *rd);
void neg(Reg *rs2, Reg *rd);
void call(Label label);
void ret();
void callr(Label label, Reg *rd);
void jmpr(Reg *rs1);
void jmpl(Reg *rs1, Reg *rs2);
void add(Reg *rs1, Reg *rs2, Reg *rd);
void addi(Reg *rs1, int val, Reg *rd);
void sub(Reg *rs1, Reg *rs2, Reg *rd);
void subi(Reg *rs1, int val, Reg *rd);
void adc(Reg *rs1, Reg *rs2, Reg *rd);
void addci(Reg *rs1, int val, Reg *rd);
void sbb(Reg *rs1, Reg *rs2, Reg *rd);
void sbbi(Reg *rs1, int val, Reg *rd);
void shl(Reg *rs1, Reg *rs2, Reg *rd);
void shli(Reg *rs1, int val, Reg *rd);
void shr(Reg *rs1, Reg *rs2, Reg *rd);
void shri(Reg *rs1, int val, Reg *rd);
void sar(Reg *rs1, Reg *rs2, Reg *rd);
void sari(Reg *rs1, int val, Reg *rd);
void and(Reg *rs1, Reg *rs2, Reg *rd);
void andi(Reg *rs1, int val, Reg *rd);
void or(Reg *rs1, Reg *rs2, Reg *rd);
void xor(Reg *rs1, Reg *rs2, Reg *rd);
void xori(Reg *rs1, int val, Reg *rd);
void mul(Reg *rs1, Reg *rs2, Reg *rd);
void muli(Reg *rs1, int val, Reg *rd);
#define divr udiv
#define divi udivi
void divr(Reg *rs1, Reg *rs2, Reg *rd);
void divi(Reg *rs1, int val, Reg *rd);
void rem(Reg *rs1, Reg *rs2, Reg *rd);
void remi(Reg *rs1, int val, Reg *rd);
void ldsb(Reg *ra, int idx, Reg *rd);
void ldub(Reg *ra, int idx, Reg *rd);
void ldw(Reg *ra, int idx, Reg *rd);
void stb(Reg *rs, Reg *ra, int idx);
void stw(Reg *rs, Reg *ra, int idx);

void ba(Label label);

void be(Reg *rs1, Reg *rs2, Label label);
void bne(Reg *rs1, Reg *rs2, Label label);
void bg(Reg *rs1, Reg *rs2, Label label);
void bge(Reg *rs1, Reg *rs2, Label label);
void bl(Reg *rs1, Reg *rs2, Label label);
void ble(Reg *rs1, Reg *rs2, Label label);
void bgu(Reg *rs1, Reg *rs2, Label label);
void bgeu(Reg *rs1, Reg *rs2, Label label);
void blu(Reg *rs1, Reg *rs2, Label label);
void bleu(Reg *rs1, Reg *rs2, Label label);

void bei(Reg *rs1, int val, Label label);
void bnei(Reg *rs1, int val, Label label);
void bgi(Reg *rs1, int val, Label label);
void bgei(Reg *rs1, int val, Label label);
void bli(Reg *rs1, int val, Label label);
void blei(Reg *rs1, int val, Label label);
void bgui(Reg *rs1, int val, Label label);
void bgeui(Reg *rs1, int val, Label label);
void blui(Reg *rs1, int val, Label label);
void bleui(Reg *rs1, int val, Label label);

void string(char *str);
void word(short w);
void uword(unsigned short uw);

// Utility functions

Label printStrGen();
Label getcharGen();
Label readUintGen();
Label printIntGen();
Label printUintGen();
Label printHexaGen();

// Instrucciones experimentales: son solo para propositos docentes

void ldwpp(Reg *ra, int idx, Reg *rd);
void stwpp(Reg *ra, Reg *rd1, Reg *rd2);
#ifdef OPswap
void swap(Reg *rs, Reg *ra, int idx);
#endif
