/* Header for module plot, generated by p2c */
#ifndef PLOT_H
#define PLOT_H



#ifndef NEWASM_H
#include <p2c/newasm.h>
#endif



#ifdef PLOT_G
# define vextern
#else
# define vextern extern
#endif



#define plot_numscreenpens 8
/* p2c: Note: Character >= 128 encountered (from plot.imp, line 43) */



/*unused*/

typedef long plot_coordarray[100000L];

typedef struct plot_namerec {
    Char s[9];
    short num;
    struct plot_namerec *next;
} plot_namerec;

typedef struct plot_fontrec {
    uchar num, height, attr;
    short arr[256];
    struct plot_fontrec *next;
} plot_fontrec;

typedef enum {
    plot_act_init, plot_act_finish, plot_act_clip, plot_act_raise,
    plot_act_lower, plot_act_view, plot_act_quality, plot_act_fast,
    plot_act_move, plot_act_draw, plot_act_ellipse, plot_act_color,
    plot_act_style, plot_act_pattern, plot_act_text, plot_act_box,
    plot_act_polygon
} plot_devaction;

typedef struct plot_devrec {
    plot_devaction act;
    long x1, y1, x2, y2;
    na_quadword q1, q2, q3;
} plot_devrec;



vextern plot_fontrec *plot_fontbase;
vextern plot_namerec *plot_namebase;
vextern long plot_lastchar, plot_bx1, plot_bx2, plot_by1, plot_by2;
vextern long plot_screenpen[plot_numscreenpens];



extern Void plot_p1p2 PP((long x1, long y1, long x2, long y2));
extern Void plot_init PP((long addr, int sizecode));
extern Void plot_initscreen PP((long x1, long y1, long x2, long y2));
extern Void plot_warminitscreen PP((long x1, long y1, long x2, long y2));
extern Void plot_initgen PP((Char *fn));
extern Void plot_initfile PP((FILE **f, int sizecode, int hascircles));
extern Void plot_initps PP((FILE **f));
extern Void plot_initff PP((FILE **f));
extern Void plot_init_fast PV();
extern Void plot_initscreen_fast PV();
extern Void plot_initgen_fast PP((Char *fn));
extern Void plot_initfile_fast PP((Char *fn));
extern Void plot_initps_fast PP((Char *fn));
extern Void plot_inituser PP((_PROCEDURE devproc));
extern Void plot_window PP((long x1, long y1, long x2, long y2));
extern Void plot_nrwindow PP((long x1, long y1, long x2, long y2));
extern Void plot_pwindow PP((long x1, long y1, long x2, long y2));
extern Void plot_lwindow PP((long x1, long y1, long x2, long y2));
extern Void plot_getwindow PP((long *x1, long *y1, long *x2, long *y2));
extern Void plot_figtitle PP((Char *title));
extern Void plot_out PP((Char *s));

/*no longer supported*/
extern Void plot_in PP((Char *s));

/*no longer supported*/
extern Void plot_lift PV();
extern Void plot_view PV();
extern Void plot_finish PV();
extern Void plot_quality PV();
extern Void plot_fast PV();
extern Void plot_velocity PP((double vel));
extern Void plot_color PP((long c));
extern Void plot_prepare PV();
extern Void plot_clip PV();
extern Void plot_noclip PV();
extern long plot_cm PP((double cm));
extern Void plot_xform PP((long x, long y, long *xx, long *yy));
extern Void plot_rxform PP((double x, double y, long *xx, long *yy));
extern Void plot_unxform PP((long xx, long yy, long *x, long *y));
extern Void plot_relxform PP((long x, long y, long *xx, long *yy));
extern Void plot_rrelxform PP((double x, double y, long *xx, long *yy));
extern Void plot_relunxform PP((long xx, long yy, long *x, long *y));
extern Void plot_linestyle PP((long num));
extern Void plot_linewidth PP((double num));
extern Void plot_move PP((long x, long y));
extern Void plot_draw PP((long x, long y));
extern Void plot_rmove PP((double x, double y));
extern Void plot_rdraw PP((double x, double y));
extern Void plot_moverel PP((long dx, long dy));
extern Void plot_drawrel PP((long dx, long dy));
extern Void plot_line PP((long x1, long y1, long x2, long y2));
extern Void plot_box PP((long x1, long y1, long x2, long y2, long pat));
extern Void plot_circle PP((long x1, long y1, long r, long pat));
extern Void plot_rellipse PP((long x1, long y1, double rx, double ry,
			      long pat));
extern Void plot_rrellipse PP((double x1, double y1, double rx, double ry,
			       long pat));
extern Void plot_bezier PP((long x1, long y1, long x2, long y2, long x3,
			    long y3, long x4, long y4, long epsilon));
extern Void plot_rbezier PP((double x1, double y1, double x2, double y2,
			     double x3, double y3, double x4, double y4,
			     long epsilon));
extern Void plot_polygon PP((long n, long *x, long *y, long pat));
extern Void plot_roundbox PP((long x1, long y1, long x2, long y2, long rx,
			      long ry, long pat));
extern Void plot_rroundbox PP((double x1, double y1, double x2, double y2,
			       double rx, double ry, long pat));
extern Void plot_readfont PP((Char *fn));
extern Void plot_readfontset PP((Char *fn, long *which));
extern Void plot_morefontset PP((Char *fn, long *which));
extern Void plot_initfonts PV();
extern Void plot_fontfile PP((Char *fn));
extern Void plot_loadfonts PP((long *which));
extern Void plot_ctrlchars PP((Char *pref, Char *chrs));
extern Void plot_selfont PP((long num));
extern long plot_height PV();
extern Void plot_charsize PP((long num, long den, long scale));
extern Void plot_charscale PP((long scale));
extern Void plot_charorient PP((double theta, int mirrorx));
extern Void plot_charaspect PP((long horiz, long vert, long den));
extern long plot_charnum PP((int ch));
extern long plot_charname PP((Char *s));
extern Void plot_ssoffset PP((long sub, long sup, long den));
extern Void plot_char PP((long x, long y, long num));
extern Void plot_string PP((long x, long y, Char *s));
extern Void plot_rightstring PP((long x, long y, Char *s));
extern Void plot_centerstring PP((long x, long y, Char *s));
extern Void plot_genstring PP((long x, long y, Char *orient, Char *s));
extern Void plot_stringrel PP((Char *s));
extern long plot_stringwidth PP((Char *s));



#undef vextern

#endif /*PLOT_H*/

/* End. */

