#define _DEFAULT_SOURCE
#include <stdio.h>
#include <nSystem.h>
#include <fifoqueues.h>
#include <string.h>
#include <stdlib.h>

#define TICK 1000

// Test Simple

static int dama(char *nom, char **ppareja) {
  nPrintf("%s espera pareja\n", nom);
  *ppareja= nDama(nom);
  if (*ppareja==NULL)
    nFatalError("dama", "La pareja de %s es NULL\n", nom);
  nPrintf("La pareja de %s es %s\n", nom, *ppareja);
  return 0;
}

static int varon(char *nom, char **ppareja) {
  nPrintf("%s espera pareja\n", nom);
  *ppareja= nVaron(nom);
  if (*ppareja==NULL)
    nFatalError("varon", "La pareja de %s es NULL\n", nom);
  nPrintf("La pareja de %s es %s\n", nom, *ppareja);
  return 0;
}

static void verificar_pareja(char *nom_dama, char *nom_varon,
                      char *pareja_dama, char *pareja_varon) {
  if (strcmp(pareja_dama, nom_varon)!=0)
    nFatalError("verificar_pareja", "La pareja de %s debio ser %s, "
                "pero es %s\n", nom_dama, nom_varon, pareja_dama);
  if (strcmp(pareja_varon, nom_dama)!=0)
    nFatalError("verificar_pareja", "La pareja de %s debio ser %s, "
                "pero es %s\n", nom_varon, nom_dama, pareja_varon);
}

static void testSimple() {
  nPrintf("Test: una sola pareja, adan y eva\n");
  char *pareja_eva= NULL, *pareja_adan= NULL;
  nTask eva= nEmitTask(dama, "eva", &pareja_eva);
  nSleep(TICK);
  if (pareja_eva!=NULL)
    nFatalError("testSimple", "eva tenia que esperar a adan\n");
  nTask adan= nEmitTask(varon, "adan", &pareja_adan);
  nWaitTask(eva);
  nWaitTask(adan);
  verificar_pareja("eva", "adan", pareja_eva, pareja_adan);
  nPrintf("Aprobado\n");

  nPrintf("Test: el ejemplo del enunciado\n");
  char *pareja_ana= NULL, *pareja_sara= NULL, *pareja_alba= NULL;
  char *pareja_pedro= NULL, *pareja_juan= NULL, *pareja_diego= NULL;
  nTask ana= nEmitTask(dama, "ana", &pareja_ana);
  nSleep(TICK);
  nTask sara= nEmitTask(dama, "sara", &pareja_sara);
  nSleep(TICK);
  nTask pedro= nEmitTask(varon, "pedro", &pareja_pedro);
  nWaitTask(ana);
  nWaitTask(pedro);
  verificar_pareja("ana", "pedro", pareja_ana, pareja_pedro);
  nSleep(TICK);
  nTask juan= nEmitTask(varon, "juan", &pareja_juan);
  nWaitTask(sara);
  nWaitTask(juan);
  verificar_pareja("sara", "juan", pareja_sara, pareja_juan);
  nSleep(TICK);
  nTask diego= nEmitTask(varon, "diego", &pareja_diego);
  nSleep(TICK);
  nTask alba= nEmitTask(dama, "alba", &pareja_alba);
  nWaitTask(alba);
  nWaitTask(diego);
  verificar_pareja("alba", "diego", pareja_alba, pareja_diego);
  nPrintf("Aprobado\n");
}

// Test de orden de llegada

#define NESPERAN 10000

static nTask wtasks[NESPERAN];
static char *wnoms[NESPERAN];
static char *wparejas[NESPERAN];

int wait_dama(char *nom, char **ppareja) {
  *ppareja= nDama(nom);
  return 0;
}

int wait_varon(char *nom, char **ppareja) {
  *ppareja= nVaron(nom);
  return 0;
}

void testOrden() {
  nSetTimeSlice(1);
  nPrintf("Test: Orden de llegada de los varones\n");
  for (int i= 0; i<NESPERAN; i++) {
    wnoms[i]= nMalloc(16);
    sprintf(wnoms[i], "%d", i);
    wtasks[i]= nEmitTask(wait_varon, wnoms[i], &wparejas[i]);
    while (nGetQueueLength()!=0)  // Esto asegura que la tarea ya invoco nVaron
      nYield();
  }
  for (int i= 0; i<NESPERAN; i++) {
    char *pareja= nDama("eva"); // Todos bailan con eva
    if (i != atoi(pareja))
      nFatalError("testOrden", "Varon %s no respeta orden de llegada\n",
                  pareja);
    nWaitTask(wtasks[i]);
  }
  nPrintf("Aprobado\n");
  nPrintf("Test: Orden de llegada de las damas\n");
  for (int i= 0; i<NESPERAN; i++) {
    wtasks[i]= nEmitTask(wait_dama, wnoms[i], &wparejas[i]);
    while (nGetQueueLength()!=0)  // Esto asegura que la tarea ya invoco nDama
      nYield();
  }
  for (int i= 0; i<NESPERAN; i++) {
    char *pareja= nVaron("adan"); // Todas bailan con adan
    if (i != atoi(pareja))
      nFatalError("testOrden", "Dama %s no respeta orden de llegada\n",
                  pareja);
    nWaitTask(wtasks[i]);
  }
  for (int i= 0; i<NESPERAN; i++) {
    nFree(wnoms[i]);
  }
  nPrintf("Aprobado\n");
}

// Test de robustez

#define NPAREJAS 1000
#define NBAILES 5000

static nSem anotadas[NPAREJAS], verificadas[NPAREJAS];
static int pareja_damas[NPAREJAS];
static nTask tasks_damas[NPAREJAS], tasks_varones[NPAREJAS];
static char *noms[NPAREJAS];

int loop_dama(char *nom, int iter) {
  int id= atoi(nom);
  while (iter--) {
    char *pareja= nDama(nom);
    int id_pareja= atoi(pareja);
    pareja_damas[id]= id_pareja;
    nSignalSem(anotadas[id]);
    nWaitSem(verificadas[id]);
    pareja_damas[id]= -1;
  }
  return 0;
}

static int loop_varon(char *nom, int iter) {
  int id= atoi(nom);
  while (iter--) {
    char *pareja= nVaron(nom);
    int id_pareja= atoi(pareja);
    nWaitSem(anotadas[id_pareja]);
    if (pareja_damas[id_pareja]!=id)
      nFatalError("loop_varon", "Varon %s dice que su pareja es dama %s, "
                                "pero dama %s dice que su pareja es varon %d\n",
                  nom, pareja, pareja, pareja_damas[id_pareja]); 
    nSignalSem(verificadas[id_pareja]);
  }
  return 0;
}

static void testRobustez() {
  nPrintf("Test: robustez\n");
  nSetTimeSlice(1);
  for (int i= 0; i<NPAREJAS; i++) {
    anotadas[i]= nMakeSem(0);
    verificadas[i]= nMakeSem(0);
    pareja_damas[i]= -1;
    noms[i]=nMalloc(16);
    sprintf(noms[i], "%d", i);
    int check= atoi(noms[i]);
    if (check!=i)
      nFatalError("testRobustez", "check");
    tasks_damas[i]= nEmitTask(loop_dama, noms[i], NBAILES);
    tasks_varones[i]= nEmitTask(loop_varon, noms[i], NBAILES);
  }
  for (int i= 0; i<NPAREJAS; i++) {
    nWaitTask(tasks_damas[i]);
    nWaitTask(tasks_varones[i]);
  }
  for (int i= 0; i<NPAREJAS; i++) {
    nFree(noms[i]);
    nDestroySem(anotadas[i]);
    nDestroySem(verificadas[i]);
  }
  nPrintf("Aprobado\n");
}

int nMain() {
  testSimple();
  testOrden();
  testRobustez();
  nPrintf("Felicitaciones: aprobo todos los tests\n");
  return 0;
}
