#include "nSystem.h"

/*
 * Este programa muestra el problema de la inversion de prioridades.
 * Se ejecutan 3 tareas con distintas prioridades.
 * - La de baja prioridad posee un semaforo, lanza las otras
 *   dos tareas con mejor prioridad y luego libera el semaforo.
 * - La de prioridad media consume mucha CPU.
 * - La de alta prioridad solo pide el semaforo, lo devuelve y termina.
 *
 * En estas condiciones, la tarea de alta prioridad debera esperar
 * a que termine la de prioridad media para poder hacer su trabajo,
 * puesto que necesita el semaforo.  Pero el semaforo lo tiene la
 * tarea de baja prioridad que no puede devolver el semaforo mientras
 * la tarea de prioridad media este activa.
 *
 * La salida del programa es:
 *     HiPri lanzada
 *     MidPri lanzada
 *     MidPri terminada
 *     HiPri terminada
 */

int MidPri(int n, int m);
int HiPri(nMutex mutex);

int nMain(int argc, char **argv)
{
  int n= argc>=2 ? atoi(argv[1]) : 10000;
  int m= argc>=3 ? atoi(argv[2]) : 10000;
  nTask hipriTask, midpriTask;
  nMutex mutex= nMakeMutex();

  nSetTaskName("nMain");

  nRequest(mutex);   /* Me aseguro que tengo el semaforo */
  nSetPriority(0);
  hipriTask= nEmitTask(HiPri, mutex);
  midpriTask= nEmitTask(MidPri, n, m);
  nSetPriority(2); /* nMain corre con la menor prioridad */
  nRelease(mutex); /* devuelvo el semaforo */

  nWaitTask(hipriTask);
  nWaitTask(midpriTask);

  return 0;
}

int MidPri(int n, int m)
{
  int i, j;
  nSetTaskName("MidPri");
  nSetPriority(1);

  nPrintf("MidPri lanzada\n");

  for (i= 0; i<n; i++)
    for (j= 0; j<m; j++)
      ;

  nPrintf("MidPri terminada\n");
}

int HiPri(nMutex mutex)
{
  nSetTaskName("HiPri");
  nPrintf("HiPri lanzada\n");
  nRequest(mutex);
  nRelease(mutex);
  nPrintf("HiPri terminada\n");
}
