package PtyPrint;

import java_cup.runtime.Symbol;
%%
%cup
%%
"if"   { return new Symbol(sym.IF); }
"else" { return new Symbol(sym.ELSE); }
"(" { return new Symbol(sym.LPAR); }
")" { return new Symbol(sym.RPAR); }
"{" { return new Symbol(sym.LBRA); }
"}" { return new Symbol(sym.RBRA); }
";" { return new Symbol(sym.SEMI); }
[a-zA-Z_][a-zA-Z0-9_]* { return new Symbol(sym.ID, yytext()); }
[ \t\r\f\n] { /* ignore white space. */ }
. { System.err.println("Illegal character: "+yytext()); }
