package PtyPrint;

import java_cup.runtime.*;

abstract class Node {
  void apply(Visitor v) { }
}

class Exp extends Node {
  String id;
  Exp(String id) { this.id= id; }
  void apply(Visitor v) { v.exp(id); }
}

abstract class S extends Node {
}

class ExpS extends S {
  Exp e;
  ExpS(Exp e) { this.e= e; }
  void apply(Visitor v) { v.expS(e); }
}

class IfS extends S {
  Exp e;
  S   ts, es;
  IfS(Exp e, S ts, S es) { this.e= e; this.ts= ts; this.es= es; }
  void apply(Visitor v) { v.ifS(e, ts, es); }
}

class GroupS extends S {
  Sls ls;
  GroupS(Sls ls) { this.ls= ls; }
  void apply(Visitor v) { v.groupS(ls); }
}

class Sls extends Node {
  S s;
  Sls ls;
  Sls(S s, Sls ls) { this.s= s; this.ls= ls; }
  void apply(Visitor v) { v.sls(s, ls); }
}

abstract class Visitor {
  void exp(String id) { }
  void expS(Exp e) { }
  void ifS(Exp e, S ts, S es) { }
  void groupS(Sls ls) { }
  void sls(S s, Sls ls) { }
}

public class PtyPrint extends Visitor {
  int indent= 0;

  void newline() {
    System.out.println();
    for (int i= 0; i<indent; i++)
      System.out.print("  ");
  }

  void exp(String id) {
    System.out.print(id);
  }
  void expS(Exp e) {
    e.apply(this); System.out.print(";");
  }
  void ifS(Exp e, S ts, S es) {
    System.out.print("if ("); e.apply(this); System.out.print(")");
    if (ts instanceof GroupS)
      ts.apply(this);
    else {
      indent++; newline();
      ts.apply(this);
      indent--;
    }
    if (es!=null) {
      newline();
      System.out.print("else ");
      if (es instanceof GroupS)
        es.apply(this);
      else {
        indent++; newline();
        ts.apply(this);
        indent--;
      }
    }
  }
  void groupS(Sls ls) {
    System.out.print("{");
    indent++;
    if (ls!=null)
      ls.apply(this);
    indent--; newline();
    System.out.print("}");
  }
  void sls(S s, Sls ls) {
    newline();
    s.apply(this);
    if (ls!=null)
      ls.apply(this);
  }
}
