/*
 * Decompiled with CFR 0.152.
 */
package relator;

import edicurso.operations.Composite;
import edicurso.operations.Node;
import edicurso.operations.RootNode;
import java.util.HashMap;
import javax.swing.tree.DefaultTreeModel;
import relator.RGuiNode;

public class RelatorModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 1L;
    HashMap<Node, RGuiNode> map;

    public RelatorModel(HashMap<Node, RGuiNode> map, RootNode rootNode) {
        super(new RGuiNode(map, rootNode));
        this.map = map;
    }

    public RGuiNode getPeer(Node node) {
        return this.map.get(node);
    }

    public RootNode getRootNode() {
        return (RootNode)((RGuiNode)this.getRoot()).getNode();
    }

    public RGuiNode getVisiblePeer(Node node) {
        Composite parent;
        RGuiNode peer = this.map.get(node);
        if (peer != null) {
            return peer;
        }
        while (true) {
            if ((parent = node.getParent()) == null) {
                return null;
            }
            peer = this.map.get(parent);
            if (peer != null) break;
            node = parent;
        }
        RGuiNode visiblePeer = peer;
        int idx = 0;
        while (idx < parent.getChildCount()) {
            Node child = parent.getChildAt(idx);
            peer = this.map.get(child);
            if (peer != null) {
                visiblePeer = peer;
            }
            if (child == node) break;
            ++idx;
        }
        return visiblePeer;
    }

    public void newRoot(RootNode rootNode) {
        this.map.clear();
        this.setRoot(new RGuiNode(this.map, rootNode));
    }
}

