/*
 * Decompiled with CFR 0.152.
 */
package edicurso.operations;

import edicurso.AudioManager;
import edicurso.Drawer;
import edicurso.Player;
import edicurso.Scheduler;
import edicurso.Sequencer;
import edicurso.Task;
import edicurso.UI;
import edicurso.Visitor;
import edicurso.operations.Composite;
import edicurso.operations.GuiNode;
import edicurso.operations.Node;
import edicurso.operations.NodeFactory;
import edicurso.operations.PauseBreak;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import javax.swing.tree.TreeNode;

public class Slide
extends Composite {
    static final int FADEDELAY = 1000;
    public static final SlideVisitor slideVisitor = new SlideVisitor();
    static final String tag = "slide";
    int delay;
    transient AlphaComposite ac;

    public Slide() {
    }

    public Slide(int delay) {
        this(delay, tag);
    }

    public Slide(int delay, String name) {
        super(name);
        this.delay = delay;
    }

    public Slide(Composite composite, NodeFactory factory) {
        super(composite, factory);
    }

    @Override
    public String tag() {
        return tag;
    }

    @Override
    public boolean isLabel() {
        return !this.name.equals("") && !tag.equals(this.name);
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public int getDelay() {
        return this.delay;
    }

    @Override
    public int getPostDelay() {
        return (int)(1000.0 / Scheduler.DEFAULT_ZOOM);
    }

    @Override
    public final void setDelay(int delay) {
        this.delay = 0;
    }

    @Override
    public Node copyNode(NodeFactory factory) {
        return new Slide(this, factory);
    }

    @Override
    public void newCurrent(Node node, Sequencer sequencer) {
        if (!this.isNodeDescendant(node)) {
            sequencer.needsRepaint();
        }
    }

    @Override
    public boolean seek(Node node, Drawer drawer) {
        if (!this.isNodeDescendant(node)) {
            return false;
        }
        boolean succ = super.seek(node, drawer);
        assert (succ);
        return true;
    }

    @Override
    public void draw(Graphics2D g2d, Drawer drawer) {
        if (this.ac != null) {
            g2d.setComposite(this.ac);
        }
    }

    @Override
    public void play(Player player) {
        this.ac = null;
        super.play(player);
        AudioManager manager = player.getAudioManager();
        manager.waitClip(null, player);
        if (this.breakOnSlide(player)) {
            PauseBreak.doBreak(player);
        } else {
            this.fade(player);
        }
    }

    @Override
    public void play(TreeNode[] branch, int k, Player player) {
        this.ac = null;
        super.play(branch, k, player);
        AudioManager manager = player.getAudioManager();
        manager.waitClip(null, player);
        if (this.breakOnSlide(player)) {
            PauseBreak.doBreak(player);
        } else {
            this.fade(player);
        }
    }

    public boolean isOuterSlide() {
        GuiNode peer = this.getPeer();
        while ((peer = (GuiNode)peer.getParent()) != null && !(peer.getNode() instanceof Slide)) {
        }
        return peer == null;
    }

    public boolean breakOnSlide(Player player) {
        if (!this.isLabel()) {
            return false;
        }
        if (!this.isOuterSlide()) {
            return false;
        }
        UI ui = player.getSequencer().getUi();
        return ui.getSlideModeMni().isSelected();
    }

    public boolean predictBreak(Player player) {
        Node sibling = this.getNextSibling();
        return sibling != null && sibling instanceof Composite && sibling.isLabel() && player.getSequencer().getUi().getLeafModeMni().isSelected();
    }

    void fade(Player player) {
        float fadedelay = this.getPostDelay();
        int t = 0;
        while ((float)t < fadedelay) {
            this.ac = AlphaComposite.getInstance(3, (fadedelay - (float)t) / fadedelay);
            player.getDrawer().touchAll();
            Task.sleep(60);
            t += 60;
        }
        this.repaint(player);
        this.ac = null;
    }

    public static class SlideVisitor
    extends Visitor {
        Slide slide;
        Composite prevSlide;

        public Slide getNextSlide(Node node) {
            this.slide = null;
            this.traverseAfter(node);
            return this.slide;
        }

        @Override
        public void visit(Node node) throws Visitor.StopException {
            Slide slide;
            if (node instanceof Slide && (slide = (Slide)node).isOuterSlide()) {
                this.slide = slide;
                this.stop();
            }
        }

        public Slide getPreviousSlide(Node node) {
            this.slide = node.getOuterSlide();
            this.prevSlide = null;
            this.walkTree(node.getRoot());
            return (Slide)this.prevSlide;
        }

        @Override
        public void walkComposite(Composite comp) throws Exception {
            if (comp instanceof Slide) {
                if (comp == this.slide) {
                    this.stop();
                }
                this.prevSlide = comp;
            } else {
                super.walkComposite(comp);
            }
        }
    }
}

