/*
 * Decompiled with CFR 0.152.
 */
package edicurso.operations;

import edicurso.AudioManager;
import edicurso.Player;
import edicurso.Sequencer;
import edicurso.UI;
import edicurso.operations.AudioClip;
import edicurso.operations.Node;
import edicurso.operations.NodeFactory;
import edicurso.operations.RootNode;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.tree.TreeNode;

public class RootNode2
extends RootNode {
    public static final int LEAF = 0;
    public static final int NONE = 1;
    public static final int SLIDE = 2;
    public static final int EXPLICIT = 3;
    int pauseMode;

    public RootNode2() {
    }

    public RootNode2(RootNode rootNode, NodeFactory factory) {
        super(rootNode, factory);
    }

    public int getPauseMode() {
        return this.pauseMode;
    }

    public void setPauseMode(int pauseMode) {
        this.pauseMode = pauseMode;
    }

    @Override
    public Node copyNode(NodeFactory factory) {
        return new RootNode2(this, factory);
    }

    @Override
    public void play(Player player) {
        super.play(player);
        AudioManager manager = player.getAudioManager();
        manager.waitClip(null, player);
        System.out.println("Player) finished");
    }

    @Override
    public void play(TreeNode[] branch, int k, Player player) {
        super.play(branch, k, player);
        AudioManager manager = player.getAudioManager();
        manager.waitClip(null, player);
        System.out.println("play(TreeNode[], int, Player) finished");
    }

    @Override
    public void save(FileOutputStream fileOut, Sequencer seq) throws Exception {
        ZipOutputStream out = new ZipOutputStream(fileOut);
        ZipEntry entry = new ZipEntry("tree.xml");
        out.putNextEntry(entry);
        XMLEncoder xenc = new XMLEncoder(out);
        this.traverseTree(new RootNode.PreSave());
        UI ui = seq.getUi();
        if (ui.getNoneModeMni().isSelected()) {
            this.pauseMode = 1;
        } else if (ui.getLeafModeMni().isSelected()) {
            this.pauseMode = 0;
        } else if (ui.getSlideModeMni().isSelected()) {
            this.pauseMode = 2;
        } else if (ui.getExplicitModeMni().isSelected()) {
            this.pauseMode = 3;
        }
        System.out.print("Zipping tree.xml ... ");
        xenc.writeObject(this);
        xenc.flush();
        out.write("</java> \n".getBytes());
        out.closeEntry();
        System.out.println("ready");
        ZipEntry binEntry = new ZipEntry("data.bin");
        out.putNextEntry(binEntry);
        this.traverseTree(new PostSave2(this, out){

            @Override
            public void visit(Node node) throws Exception {
                node.postSave2(this);
            }
        });
        out.closeEntry();
        this.traverseTree(new PostSave2(out));
    }

    @Override
    public void open(File file, ZipInputStream zipStream, Sequencer seq) throws Exception {
        ZipInputStream in = zipStream;
        in.getNextEntry();
        in.getNextEntry();
        this.traverseTree(new PostOpen2(this, in){

            @Override
            public void visit(Node node) throws Exception {
                node.postOpen2(this);
            }
        });
        in.closeEntry();
        AudioClip.resetTotal();
        this.traverseTree(new PostOpen2(in));
        switch (this.pauseMode) {
            case 1: {
                seq.getUi().getNoneModeMni().setSelected(true);
                break;
            }
            case 0: {
                seq.getUi().getLeafModeMni().setSelected(true);
                break;
            }
            case 2: {
                seq.getUi().getSlideModeMni().setSelected(true);
                break;
            }
            case 3: {
                seq.getUi().getExplicitModeMni().setSelected(true);
            }
        }
        System.out.println("File size: " + file.length());
        System.out.println("Audio size: " + AudioClip.getTotal());
        System.out.println("Audio duration: " + AudioClip.getTotalTime() / 1000);
    }

    public class PostOpen2
    extends RootNode.PostOpen {
        public PostOpen2(ZipInputStream in) {
            super(in);
        }

        @Override
        public void checkMark(int v) throws IOException {
            int mark = this.readInt();
            if (mark != v) {
                throw new IOException("stream corrupted");
            }
        }
    }

    public class PostSave2
    extends RootNode.PostSave {
        public PostSave2(ZipOutputStream out) {
            super(out);
        }

        @Override
        public void writeMark(int v) throws IOException {
            this.writeInt(v);
        }
    }
}

