/*
 * Decompiled with CFR 0.152.
 */
package edicurso.operations;

import edicurso.Drawer;
import edicurso.Player;
import edicurso.Sequencer;
import edicurso.Task;
import edicurso.TimeManager;
import edicurso.Visitor;
import edicurso.operations.Node;
import edicurso.operations.RootNode;
import edicurso.operations.Segment;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;

public class PenSegment
extends Node {
    public static final int PIXSIZE = 16;
    public static final float PITCH = 0.0625f;
    short size;
    short x;
    short y;
    short pressure;
    short delay0;
    String dxStr;
    String dyStr;
    String delaysStr;
    String dpStr;
    static final int SEG_CHUNK = 8;
    transient short[] dx;
    transient short[] dy;
    transient short[] dp;
    transient short[] delays;
    transient Path2D.Float path;
    transient String name;
    transient Rectangle2D.Float box = new Rectangle2D.Float(0.0f, 0.0f, -1.0f, -1.0f);
    transient int drawLast;
    public static final char[] xmlEnc = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '+'};
    public static final byte[] xmlDec = new byte[128];

    static {
        int i = 0;
        while (i < xmlEnc.length) {
            PenSegment.xmlDec[(byte)PenSegment.xmlEnc[i]] = (byte)i;
            ++i;
        }
    }

    public PenSegment() {
    }

    public PenSegment(int delay, int lx, int ly, int lpressure, Sequencer seq) {
        this.delay0 = (short)delay;
        this.x = (short)lx;
        this.y = (short)ly;
        this.pressure = (short)lpressure;
        this.dx = new short[8];
        this.dy = new short[8];
        this.dp = new short[8];
        this.delays = new short[8];
        this.size = 0;
        seq.addNode(this);
        seq.select(this, false);
        this.exec(seq.getDrawer());
    }

    public PenSegment(PenSegment segment) {
        this.size = segment.size;
        this.x = segment.x;
        this.y = segment.y;
        this.pressure = segment.pressure;
        this.delay0 = segment.delay0;
        this.dx = segment.dx;
        this.dy = segment.dy;
        this.dp = segment.dp;
        this.delays = segment.delays;
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int lsize) {
        this.size = (short)lsize;
    }

    public final int getX() {
        return this.x;
    }

    public final void setX(int lx) {
        this.x = (short)lx;
    }

    public final int getY() {
        return this.y;
    }

    public final void setY(int ly) {
        this.y = (short)ly;
    }

    public final int getPressure() {
        return this.pressure;
    }

    public final void setPressure(int lpressure) {
        this.pressure = (short)lpressure;
    }

    public int getDelay0() {
        return this.delay0;
    }

    public void setDelay0(int ldelay0) {
        this.delay0 = (short)ldelay0;
    }

    public String getDxStr() {
        return this.dxStr;
    }

    public void setDxStr(String ldx) {
        this.dxStr = ldx;
    }

    public String getDyStr() {
        return this.dyStr;
    }

    public void setDyStr(String ldy) {
        this.dyStr = ldy;
    }

    public String getDpStr() {
        return this.dpStr;
    }

    public void setDpStr(String ldp) {
        this.dpStr = ldp;
    }

    public String getDelaysStr() {
        return this.delaysStr;
    }

    public void setDelaysStr(String ldelays) {
        this.delaysStr = ldelays;
    }

    public short[] getDx() {
        return this.dx;
    }

    public short[] getDy() {
        return this.dy;
    }

    public short[] getDelays() {
        return this.delays;
    }

    public String toString() {
        if (this.name == null) {
            this.name = "pen start at " + this.x + " " + this.y;
        }
        return this.name;
    }

    @Override
    public void showInfo(TimeManager timeManager) {
        super.showInfo(timeManager);
        System.out.println("pen start " + this.x + " " + this.y);
        int i = 0;
        while (i < this.size) {
            System.out.print(String.valueOf(i) + ":" + this.dx[i] / 16 + " " + this.dy[i] / 16 + " ");
            if (i != 0 && i % 6 == 0) {
                System.out.println();
            }
            ++i;
        }
        if ((i - 1) % 6 != 0) {
            System.out.println();
        }
    }

    @Override
    public int getDelay() {
        int segDelay = this.delay0;
        int i = 0;
        while (i < this.size) {
            segDelay += this.delays[i];
            ++i;
        }
        return segDelay;
    }

    public void add(int delay, int newX, int newY, int lpressure, Sequencer seq) {
        int newPressure = lpressure;
        short oldX = this.x;
        short oldY = this.y;
        if (this.size >= 2) {
            oldX = this.dx[this.size - 2];
            oldY = this.dy[this.size - 2];
        }
        if (this.size >= 2 && Segment.distance2(oldX, oldY, newX, newY) < 2304) {
            int n = this.size - 1;
            this.delays[n] = (short)(this.delays[n] + delay);
        } else {
            if (this.size >= this.delays.length) {
                short[] newDelays = new short[this.delays.length + 8];
                short[] newDx = new short[this.delays.length + 8];
                short[] newDy = new short[this.delays.length + 8];
                short[] newDp = new short[this.delays.length + 8];
                int i = 0;
                while (i < this.delays.length) {
                    newDelays[i] = this.delays[i];
                    newDx[i] = this.dx[i];
                    newDy[i] = this.dy[i];
                    newDp[i] = this.dp[i];
                    ++i;
                }
                this.delays = newDelays;
                this.dx = newDx;
                this.dy = newDy;
                this.dp = newDp;
            }
            this.delays[this.size] = (short)delay;
            this.size = (short)(this.size + 1);
        }
        this.dx[this.size - 1] = (short)newX;
        this.dy[this.size - 1] = (short)newY;
        this.dp[this.size - 1] = (short)newPressure;
        Drawer drawer = seq.getDrawer();
        this.buildPath(drawer, null);
        seq.needsRedraw();
        seq.getModel().clearClean();
    }

    @Override
    public void draw(Graphics2D g2d, Drawer drawer) {
        if (drawer.requires(this.box)) {
            ++drawer.cnt;
            g2d.draw(this.path);
        }
    }

    @Override
    public void exec(Drawer drawer) {
        drawer.setDrawNode(this);
        this.buildPath(drawer, null);
    }

    public void exec(Drawer drawer, Player player) {
        Task.sleep(this.delay0);
        drawer.setDrawNode(this);
        this.buildPath(drawer, player);
    }

    public void buildPath(Drawer drawer, Player player) {
        this.path = new Path2D.Float();
        float oldX = (float)this.x * 0.0625f;
        float oldY = (float)this.y * 0.0625f;
        this.path.moveTo(oldX, oldY);
        this.box.setRect(0.0f, 0.0f, -1.0f, -1.0f);
        this.strokedTouch(oldX, oldY, drawer);
        int i = 0;
        while (i < this.size) {
            if (player != null) {
                Task.sleep(this.delays[i]);
            }
            float newX = (float)this.dx[i] * 0.0625f;
            float newY = (float)this.dy[i] * 0.0625f;
            this.path.lineTo(newX, newY);
            this.strokedTouch(oldX, oldY, drawer);
            this.strokedTouch(newX, newY, drawer);
            oldX = newX;
            oldY = newY;
            ++i;
        }
        if (this.size == 0) {
            this.path.lineTo(oldX, oldY);
        }
    }

    @Override
    public void play(Player player) {
        this.select(player);
        this.exec(player.getDrawer(), player);
    }

    @Override
    public boolean hit(Graphics2D g2d, Rectangle rect) {
        if (this.path == null) {
            System.out.println("null path for " + this.toString());
        }
        return this.path != null && g2d.hit(rect, this.path, true);
    }

    @Override
    public void move(int dx, int dy, Sequencer seq) {
        Drawer drawer = seq.getDrawer();
        drawer.touch(this.box);
        this.x = (short)(this.x + dx * 16);
        this.y = (short)(this.y + dy * 16);
        this.dx = (short[])this.dx.clone();
        this.dy = (short[])this.dy.clone();
        int i = 0;
        while (i < this.size) {
            int n = i;
            this.dx[n] = (short)(this.dx[n] + dx * 16);
            int n2 = i++;
            this.dy[n2] = (short)(this.dy[n2] + dy * 16);
        }
        seq.needsRepaint();
    }

    public final void strokedTouch(float x, float y, Drawer drawer) {
        float width = drawer.getStroke().getLineWidth();
        float x1 = x - width - 1.0f;
        float y1 = y - width - 1.0f;
        float x2 = x + width + 1.0f;
        float y2 = y + width + 1.0f;
        if (this.box.isEmpty()) {
            this.box.setRect(x1, y1, 1.0f, 1.0f);
        } else {
            this.box.add(x1, y1);
        }
        this.box.add(x2, y2);
        drawer.touch(x1, y1);
        drawer.touch(x2, y2);
    }

    @Override
    public void postOpen2(Visitor visArg) throws Exception {
        RootNode.PostOpen vis = (RootNode.PostOpen)visArg;
        vis.checkMark(this.size);
        this.dx = vis.readShortArray(this.size);
        this.dy = vis.readShortArray(this.size);
        this.dp = vis.readShortArray(this.size);
        this.delays = vis.readShortArray(this.size);
    }

    @Override
    public void postSave2(Visitor visArg) throws Exception {
        RootNode.PostSave vis = (RootNode.PostSave)visArg;
        vis.writeMark(this.size);
        vis.writeShortArray(this.dx, this.size);
        vis.writeShortArray(this.dy, this.size);
        vis.writeShortArray(this.dp, this.size);
        vis.writeShortArray(this.delays, this.size);
    }

    @Override
    public void postOpen(Visitor vis) throws Exception {
        if (this.dxStr != null) {
            byte[] zdx = PenSegment.uudecode(this.dxStr);
            byte[] zdy = PenSegment.uudecode(this.dyStr);
            byte[] zdp = PenSegment.uudecode(this.dpStr);
            byte[] zdelays = PenSegment.uudecode(this.delaysStr);
            this.dx = PenSegment.decompress(zdx, this.size, this.x);
            this.dy = PenSegment.decompress(zdy, this.size, this.y);
            this.dp = PenSegment.decompress(zdp, this.size, this.pressure);
            this.delays = PenSegment.decompressPositive(zdelays, this.size);
        }
        this.delaysStr = null;
        this.dpStr = null;
        this.dyStr = null;
        this.dxStr = null;
    }

    static short[] decompressPositive(byte[] codes, int size) {
        short[] values = new short[size];
        int i = 0;
        int k = 0;
        while (i < codes.length) {
            byte val;
            values[k] = ((val = codes[i++]) & 0x80) != 0 ? (short)(((val & 0x7F) << 8) + (codes[i++] & 0xFF)) : (short)val;
            ++k;
        }
        assert (k == size);
        return values;
    }

    @Override
    public Node copyNode() {
        return new PenSegment(this);
    }

    static int compress(short[] values, byte[] codes, int size, int oldVal) {
        int len = 0;
        int i = 0;
        while (i < size) {
            int val = values[i] - oldVal;
            oldVal = values[i];
            if (-64 <= val && val < 64) {
                codes[len++] = (byte)(val << 1);
            } else {
                byte hi = (byte)(1 | val >> 8 << 1);
                byte lo = (byte)val;
                codes[len++] = hi;
                codes[len++] = lo;
            }
            ++i;
        }
        return len;
    }

    static short[] decompress(byte[] codes, int size, int oldVal) {
        short[] values = new short[size];
        int i = 0;
        int k = 0;
        while (i < codes.length) {
            byte val;
            if (((val = codes[i++]) & 1) != 0) {
                values[k] = (short)((val >> 1 << 8) + (codes[i++] & 0xFF) + oldVal);
                oldVal = values[k];
            } else {
                values[k] = (short)((val >> 1) + oldVal);
                oldVal = values[k];
            }
            ++k;
        }
        return values;
    }

    static int compressPositive(short[] values, byte[] codes, int size) {
        int len = 0;
        int i = 0;
        while (i < size) {
            short val = values[i];
            if (val < 128) {
                codes[len++] = (byte)val;
            } else {
                byte hi = (byte)(0x80 | val >> 8);
                byte lo = (byte)(val & 0xFF);
                codes[len++] = hi;
                codes[len++] = lo;
            }
            ++i;
        }
        return len;
    }

    static void uuencode3x4(byte b1, byte b2, byte b3, char[] buf, int k) {
        buf[k] = xmlEnc[(b1 & 0xFF) >> 2];
        buf[k + 1] = xmlEnc[(b1 & 3) << 4 | (b2 & 0xFF) >> 4];
        buf[k + 2] = xmlEnc[(b2 & 0xF) << 2 | (b3 & 0xFF) >> 6];
        buf[k + 3] = xmlEnc[b3 & 0x3F];
    }

    public static String uuencode(byte[] a, int size) {
        int bufLen = 4 * ((size + 2) / 3) + 1;
        char[] buf = new char[bufLen];
        int i = 0;
        int k = 1;
        buf[0] = xmlEnc[(byte)(size % 3)];
        while (i + 2 < size) {
            PenSegment.uuencode3x4(a[i], a[i + 1], a[i + 2], buf, k);
            i += 3;
            k += 4;
        }
        if (i != size) {
            byte b1 = a[i];
            byte b2 = i + 1 < size ? a[i + 1] : (byte)0;
            byte b3 = 0;
            PenSegment.uuencode3x4(b1, b2, b3, buf, k);
        }
        return new String(buf);
    }

    static void uudecode4x3(String s, int k, byte[] b) {
        byte c1 = xmlDec[s.charAt(k)];
        byte c2 = xmlDec[s.charAt(k + 1)];
        byte c3 = xmlDec[s.charAt(k + 2)];
        byte c4 = xmlDec[s.charAt(k + 3)];
        b[0] = (byte)((c1 & 0x3F) << 2 | (c2 & 0x3F) >> 4);
        b[1] = (byte)((c2 & 0xF) << 4 | (c3 & 0x3F) >> 2);
        b[2] = (byte)((c3 & 3) << 6 | c4 & 0x3F);
    }

    public static byte[] uudecode(String s) {
        byte rem = xmlDec[s.charAt(0)];
        int len = (s.length() - 1) / 4 * 3 - (rem == 0 ? 0 : 3 - rem);
        byte[] b = new byte[3];
        byte[] a = new byte[len];
        int i = 0;
        int k = 1;
        while (i + 2 < len) {
            PenSegment.uudecode4x3(s, k, b);
            a[i] = b[0];
            a[i + 1] = b[1];
            a[i + 2] = b[2];
            i += 3;
            k += 4;
        }
        if (i != len) {
            PenSegment.uudecode4x3(s, k, b);
            a[i] = b[0];
            if (i + 1 < len) {
                a[i + 1] = b[1];
            }
        }
        return a;
    }
}

