/*
 * Decompiled with CFR 0.152.
 */
package edicurso.operations;

import edicurso.AudioManager;
import edicurso.Drawer;
import edicurso.Player;
import edicurso.Sequencer;
import edicurso.UI;
import edicurso.Visitor;
import edicurso.operations.GuiNode;
import edicurso.operations.NamedNode;
import edicurso.operations.Node;
import edicurso.operations.NodeFactory;
import edicurso.operations.PauseBreak;
import edicurso.operations.RootNode;
import edicurso.operations.Slide;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public abstract class Composite
extends NamedNode {
    Node[] children;

    Composite() {
    }

    public Composite(String name) {
        super(name);
    }

    public Composite(Composite composite, NodeFactory factory) {
        super(composite.name);
        int size = composite.getChildCount();
        int i = 0;
        while (i < size) {
            this.add(factory.copyNode(composite.getChildAt(i), factory));
            ++i;
        }
    }

    public final boolean getEditable() {
        return true;
    }

    public void setEditable(boolean editable) {
    }

    public Node[] getChildren() {
        return this.children;
    }

    public void setChildren(Node[] children) {
        this.children = children;
    }

    @Override
    public boolean seek(Node node, Drawer drawer) {
        if (this.isLabel()) {
            AudioManager.getAudioManager().setAudioClip(null);
        }
        boolean res = super.seek(node, drawer);
        return res;
    }

    @Override
    public Node getLastVisibleLeaf() {
        int size = this.getChildCount();
        int i = size - 1;
        while (i >= 0) {
            Node child = this.getChildAt(i);
            if (!(child instanceof Slide)) {
                return child.getLastVisibleLeaf();
            }
            --i;
        }
        return this;
    }

    @Override
    public void play(Player player) {
        if (this.isLabel()) {
            AudioManager manager = player.getAudioManager();
            manager.waitClip(null, player);
            UI ui = player.getSequencer().getUi();
            if (ui.getLeafModeMni().isSelected()) {
                Sequencer seq = player.getSequencer();
                RootNode rootNode = seq.getRootNode();
                if (seq.getLastPlayNode() == rootNode) {
                    seq.setLastPlayNode(this);
                } else {
                    PauseBreak.doBreak(player);
                }
            }
        }
        super.play(player);
    }

    @Override
    public void preSave(Visitor vis) {
        int size = this.getChildCount();
        this.children = new Node[size];
        int i = 0;
        while (i < size) {
            this.children[i] = this.getChildAt(i);
            ++i;
        }
    }

    @Override
    public void postSave(Visitor vis) {
        this.children = null;
    }

    @Override
    public void postOpen2(Visitor vis) {
        this.postOpen(vis);
    }

    @Override
    public void postOpen(Visitor vis) {
        if (this.children != null) {
            int size = this.children.length;
            int i = 0;
            while (i < size) {
                this.add(this.children[i]);
                ++i;
            }
            this.children = null;
        }
    }

    @Override
    public boolean hit(Graphics2D g2d, Rectangle rect) {
        boolean success = false;
        int size = this.getChildCount();
        int i = 0;
        while (i < size) {
            success = success || this.getChildAt(i).hit(g2d, rect);
            ++i;
        }
        return success;
    }

    @Override
    public void move(int dx, int dy, Sequencer seq) {
        int size = this.getChildCount();
        int i = 0;
        while (i < size) {
            this.getChildAt(i).move(dx, dy, seq);
            ++i;
        }
    }

    @Override
    public Node copyNode() {
        assert (false);
        return null;
    }

    @Override
    public void traverseTree(Visitor visitor) throws Exception {
        visitor.visit(this);
        this.traverseChildrenAfter(visitor, null);
        visitor.postVisit(this);
    }

    @Override
    public void traverseAfter(Visitor visitor) throws Exception {
        this.traverseChildrenAfter(visitor, null);
        visitor.postVisit(this);
        super.traverseAfter(visitor);
    }

    public void traverseChildrenAfter(Visitor visitor, Node child) throws Exception {
        GuiNode parentPeer = this.getPeer();
        int count = parentPeer.getChildCount();
        int idx = child == null ? 0 : parentPeer.getIndex(child.getPeer()) + 1;
        while (idx < count) {
            GuiNode afterPeer = (GuiNode)parentPeer.getChildAt(idx);
            afterPeer.getNode().traverseTree(visitor);
            ++idx;
        }
    }

    @Override
    public void reverseTraversal(Visitor visitor) throws Exception {
        visitor.reversePostVisit(this);
        this.reverseTraversalChildrenBefore(visitor, null);
        visitor.reverseVisit(this);
    }

    public void reverseTraversalChildrenBefore(Visitor visitor, Node child) throws Exception {
        GuiNode parentPeer = this.getPeer();
        int count = parentPeer.getChildCount();
        int idx = child == null ? count - 1 : parentPeer.getIndex(child.getPeer()) - 1;
        while (idx >= 0) {
            GuiNode afterPeer = (GuiNode)parentPeer.getChildAt(idx);
            afterPeer.getNode().reverseTraversal(visitor);
            --idx;
        }
    }

    @Override
    public void walkTree(Visitor visitor) throws Exception {
        visitor.walkComposite(this);
    }
}

