/*
 * Decompiled with CFR 0.152.
 */
package edicurso.operations;

import edicurso.AudioManager;
import edicurso.Player;
import edicurso.operations.AudioNode;
import edicurso.operations.Node;

public class AudioSync
extends AudioNode {
    int syncDelay;
    transient String name;

    public AudioSync() {
    }

    public AudioSync(int syncDelay) {
        this.syncDelay = syncDelay;
    }

    public int getSyncDelay() {
        return this.syncDelay;
    }

    public void setSyncDelay(int syncDelay) {
        this.syncDelay = syncDelay;
    }

    @Override
    public String tag() {
        return "sync";
    }

    @Override
    public void play(Player player) {
        this.select(player);
        System.out.println("Audio sync at " + this.getSyncTime());
        AudioManager manager = player.getAudioManager();
        manager.waitClip(this, player);
        manager.playCoalesced(this);
    }

    @Override
    public String toString() {
        if (this.name == null) {
            this.name = "audio sync at " + (this.syncDelay + 500) / 1000 + " seconds";
        }
        return this.name;
    }

    @Override
    public Node copyNode() {
        return new AudioSync(this.syncDelay);
    }
}

