/*
 * Decompiled with CFR 0.152.
 */
package edicurso.operations;

import edicurso.AudioManager;
import edicurso.CaptureManager;
import edicurso.Drawer;
import edicurso.JOrbisDecoder;
import edicurso.Player;
import edicurso.Visitor;
import edicurso.operations.AudioNode;
import edicurso.operations.AudioSync;
import edicurso.operations.EndAudioClip;
import edicurso.operations.GuiNode;
import edicurso.operations.Node;
import edicurso.operations.RootNode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioClip
extends AudioNode {
    private static final String TAG = "audio";
    private static final String RECORD = "REC!";
    private static final int MAXLEN = 100;
    public static JOrbisDecoder decoder = new JOrbisDecoder();
    int size;
    int dataSize;
    int time;
    boolean compressed = false;
    transient boolean coalesced = false;
    transient byte[] audioData;
    static int total;
    static int totalTime;

    public AudioClip() {
    }

    public static AudioClip empty() {
        AudioClip clip = new AudioClip();
        clip.dataSize = 0;
        clip.size = 0;
        clip.time = 0;
        clip.compressed = false;
        clip.audioData = new byte[0];
        return clip;
    }

    public AudioClip(AudioFormat audioFormat, InputStream in, int size) {
        this.size = size;
        this.time = AudioClip.size2time(audioFormat, size);
        AudioInputStream audioIn = new AudioInputStream(in, audioFormat, size / (audioFormat.getSampleSizeInBits() / 8));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            AudioSystem.write(audioIn, AudioFileFormat.Type.WAVE, out);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.audioData = out.toByteArray();
        this.dataSize = this.audioData.length;
    }

    public AudioClip(AudioClip clip) {
        this.setName(clip.getName());
        this.compressed = clip.compressed;
        this.audioData = clip.audioData;
        this.size = clip.size;
        this.dataSize = clip.dataSize;
        this.time = clip.time;
    }

    public final byte[] getAudioData() {
        return this.audioData;
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int size) {
        this.size = size;
    }

    public final int getDataSize() {
        return this.dataSize;
    }

    public final void setDataSize(int dataSize) {
        this.dataSize = dataSize;
    }

    public final int getTime() {
        return this.time;
    }

    public final void setTime(int time) {
        this.time = time;
    }

    public final boolean getCompressed() {
        return this.compressed;
    }

    public final void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public final boolean getCoalesced() {
        return this.coalesced;
    }

    public final void transientCoalesced(boolean coalesced) {
        this.coalesced = coalesced;
    }

    @Override
    public String tag() {
        return TAG;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    public static int time2size(AudioFormat audioFormat, int dt) {
        int bytesXsample = audioFormat.getSampleSizeInBits() / 8;
        int size = (int)((double)((float)(dt * bytesXsample) * audioFormat.getSampleRate() / 1000.0f) + 0.5);
        size = size / bytesXsample * bytesXsample;
        return size;
    }

    public static int size2time(AudioFormat audioFormat, int size) {
        int bytesXsample = audioFormat.getSampleSizeInBits() / 8;
        int time = (int)((float)(1000L * (long)size) / audioFormat.getSampleRate() / (float)bytesXsample);
        return time;
    }

    public long computeHash(byte[] audioData, int from) {
        long res = 0L;
        int i = 0;
        while (i < 8) {
            res = (res << 8) + (long)audioData[from++];
            ++i;
        }
        return res;
    }

    @Override
    public void exec(Drawer drawer) {
        super.exec(drawer);
        AudioManager manager = drawer.getAudioManager();
        manager.setAudioClip(this);
    }

    @Override
    public void play(Player player) {
        this.select(player);
        AudioManager manager = player.getAudioManager();
        if (manager.wasCoalesced(this)) {
            System.out.println("coalesced " + this.toString());
            manager.waitClip(this, player);
            manager.playCoalesced(this);
        } else {
            System.out.println("starting " + this.toString());
            manager.waitPlaying(player);
            manager.setAudioClip(this);
            manager.startPlay(this);
        }
    }

    @Override
    public String toString() {
        if (this.treeName == null) {
            if (this.name == null || this.name.equals("") || this.name.equals(TAG)) {
                this.treeName = this.audioData == null || this.audioData.length == 0 ? RECORD : "audio clip of " + this.getTime() + " milliseconds";
            } else {
                StringBuffer buf = new StringBuffer();
                if (this.audioData == null || this.audioData.length == 0) {
                    buf.append(RECORD);
                    buf.append(' ');
                } else {
                    buf.append(TAG);
                    buf.append(": ");
                }
                int i = 0;
                block0: while (i < this.name.length() && i < 100) {
                    char c = this.name.charAt(i);
                    if (c != ' ' && c != '\t' && c != '\n') {
                        buf.append(c);
                        ++i;
                        continue;
                    }
                    buf.append(' ');
                    ++i;
                    while (i < 100 && i < this.name.length()) {
                        c = this.name.charAt(i);
                        if (c != ' ' && c != '\t' && c != '\n') continue block0;
                        ++i;
                    }
                }
                if (i < this.name.length()) {
                    buf.append(" ...");
                }
                this.treeName = buf.toString();
            }
        }
        return this.treeName;
    }

    @Override
    public Node copyNode() {
        return new AudioClip(this);
    }

    public static void resetTotal() {
        total = 0;
        totalTime = 0;
    }

    public static int getTotal() {
        return total;
    }

    public static int getTotalTime() {
        return totalTime;
    }

    public InputStream getAudioStream() throws IOException, UnsupportedAudioFileException {
        if (this.compressed) {
            System.out.println("decompressing " + this.audioData.length + " bytes");
            byte[] decompressed = decoder.decode(this.audioData);
            System.out.println("---> giving " + decompressed.length + " bytes");
            return new ByteArrayInputStream(decompressed);
        }
        return AudioSystem.getAudioInputStream(new ByteArrayInputStream(this.audioData));
    }

    @Override
    public void postSave(Visitor visArg) throws Exception {
        String ext;
        RootNode.PostSave vis = (RootNode.PostSave)visArg;
        ZipOutputStream zipStream = vis.getZipStream();
        String string = ext = this.compressed ? ".ogg" : ".wav";
        if (this.compressed) {
            zipStream.setLevel(0);
        }
        ZipEntry entry = new ZipEntry(String.valueOf(vis.getSerial()) + ext);
        if (this.compressed) {
            entry.setMethod(0);
            CRC32 crc = new CRC32();
            crc.update(this.audioData);
            entry.setSize(this.audioData.length);
            entry.setCrc(crc.getValue());
        }
        zipStream.putNextEntry(entry);
        if (!this.compressed) {
            vis.writeMark(this.audioData.length);
        }
        zipStream.write(this.audioData, 0, this.audioData.length);
        System.out.println("wrote " + this.audioData.length + " bytes in " + entry.getName());
        zipStream.closeEntry();
    }

    @Override
    public void postOpen(Visitor visArg) throws IOException {
        int rc;
        RootNode.PostOpen vis = (RootNode.PostOpen)visArg;
        ZipInputStream zipStream = vis.getZipStream();
        ZipEntry entry = zipStream.getNextEntry();
        assert (entry != null);
        if (!this.compressed) {
            vis.checkMark(this.dataSize);
        }
        this.audioData = new byte[this.dataSize];
        int cnt = 0;
        do {
            rc = zipStream.read(this.audioData, cnt, this.audioData.length - cnt);
            assert (rc > 0);
        } while ((cnt += rc) < this.audioData.length);
        System.out.println("read audio clip of " + cnt + " bytes ");
        total += cnt;
        totalTime += this.time;
        zipStream.closeEntry();
    }

    public void compress(Visitor.Compressor compressor) {
        if (this.compressed || this.size == 0) {
            return;
        }
        AudioFormat audioFormat = CaptureManager.getAudioFormat();
        File wavFile = null;
        File oggFile = null;
        try {
            wavFile = File.createTempFile("clip", ".wav");
            oggFile = File.createTempFile("clip", ".ogg");
            AudioInputStream audioIn = new AudioInputStream(new ByteArrayInputStream(this.audioData), audioFormat, this.audioData.length / (audioFormat.getSampleSizeInBits() / 8));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(wavFile));
            AudioSystem.write(audioIn, AudioFileFormat.Type.WAVE, out);
            out.close();
            String[] cmdArray = new String[]{"oggenc2", "-q", "1", "-o", oggFile.getAbsolutePath(), wavFile.getAbsolutePath()};
            System.out.print(cmdArray[0]);
            int i = 1;
            while (i < cmdArray.length) {
                System.out.print(" " + cmdArray[i]);
                ++i;
            }
            System.out.println();
            AudioClip.exec(cmdArray);
            if (!oggFile.exists()) {
                System.out.println("File " + oggFile.getAbsolutePath() + " was not written properly");
                compressor.success = false;
                return;
            }
            int dataSize = (int)oggFile.length();
            byte[] newAudioData = new byte[dataSize];
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(oggFile));
            int rc = AudioManager.audioRead(in, newAudioData, dataSize);
            assert (rc == dataSize);
            in.close();
            byte[] decodedAudioData = decoder.decode(newAudioData);
            if (decodedAudioData == null) {
                compressor.success = false;
                return;
            }
            try {
                int size = decodedAudioData.length;
                if (this.audioData.length != size) {
                    ++compressor.diffCnt;
                    compressor.diffSum = compressor.diffSum + (this.audioData.length > size ? this.audioData.length - size : size - this.audioData.length);
                } else {
                    System.out.println("uncompressed size matches original size: " + size);
                }
                this.dataSize = dataSize;
                this.audioData = newAudioData;
                this.size = size;
                this.time = AudioClip.size2time(audioFormat, size);
                this.compressed = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (wavFile != null) {
                wavFile.delete();
            }
            if (oggFile != null) {
                oggFile.delete();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void coalesceCompress(Visitor.Compressor compressor) {
        if (this.compressed) {
            return;
        }
        AudioFormat audioFormat = CaptureManager.getAudioFormat();
        AudioManager.Coalescer coalescer = compressor.getCoalescer();
        Set<AudioClip> coalesceClips = compressor.getCoalesceClips();
        coalesceClips.clear();
        coalescer.coalesce(this, this, coalesceClips, false);
        File wavFile = null;
        File oggFile = null;
        try {
            try {
                block20: {
                    wavFile = File.createTempFile("clip", ".wav");
                    oggFile = File.createTempFile("clip", ".ogg");
                    byte[] coalescedAudioData = coalescer.getAudioData();
                    AudioInputStream audioIn = new AudioInputStream(new ByteArrayInputStream(coalescedAudioData), audioFormat, coalescedAudioData.length / (audioFormat.getSampleSizeInBits() / 8));
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(wavFile));
                    AudioSystem.write(audioIn, AudioFileFormat.Type.WAVE, out);
                    out.close();
                    String[] cmdArray = new String[]{"oggenc2", "-q", "1", "-o", oggFile.getAbsolutePath(), wavFile.getAbsolutePath()};
                    System.out.print(cmdArray[0]);
                    int i = 1;
                    while (true) {
                        if (i >= cmdArray.length) {
                            System.out.println();
                            AudioClip.exec(cmdArray);
                            if (oggFile.exists()) break;
                            System.out.println("File " + oggFile.getAbsolutePath() + " was not written properly");
                            break block20;
                        }
                        System.out.print(" " + cmdArray[i]);
                        ++i;
                    }
                    int dataSize = (int)oggFile.length();
                    byte[] newAudioData = new byte[dataSize];
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(oggFile));
                    int rc = AudioManager.audioRead(in, newAudioData, dataSize);
                    assert (rc == dataSize);
                    in.close();
                    byte[] decodedAudioData = decoder.decode(newAudioData);
                    int size = 0;
                    if (decodedAudioData == null) {
                        System.out.println("WARNING: Couldn't read compressed audio stream properly");
                        compressor.success = false;
                    } else {
                        size = decodedAudioData.length;
                        if (coalescedAudioData.length != size) {
                            System.out.println("WARNING: uncompressed size doesn't match original size!");
                            compressor.success = false;
                        } else {
                            System.out.println("uncompressed size matches original size: " + size);
                        }
                    }
                    this.dataSize = dataSize;
                    this.audioData = newAudioData;
                    this.size = size;
                    this.time = AudioClip.size2time(audioFormat, coalescer.getAudioData().length);
                    this.compressed = true;
                }
                boolean success = AudioManager.finder.findAudioNode(this);
                Node curr = AudioManager.finder.getNextNode();
                while (curr != null) {
                    GuiNode clipPeer;
                    if (!success) {
                        return;
                    }
                    AudioNode currAudioNode = (AudioNode)curr;
                    if (currAudioNode instanceof AudioClip && !((AudioClip)currAudioNode).getCoalesced()) {
                        return;
                    }
                    if (currAudioNode instanceof EndAudioClip && this.syncTime == coalescer.getAudioTime()) {
                        return;
                    }
                    int syncTime = currAudioNode.getSyncTime();
                    AudioSync sync = new AudioSync(syncTime);
                    sync.peer = clipPeer = curr.getPeer();
                    clipPeer.setUserObject(sync);
                    success = AudioManager.finder.findAudioNode(curr);
                    curr = AudioManager.finder.getNextNode();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (wavFile != null) {
                    wavFile.delete();
                }
                if (oggFile == null) return;
                oggFile.delete();
                return;
            }
        }
        finally {
            if (wavFile != null) {
                wavFile.delete();
            }
            if (oggFile != null) {
                oggFile.delete();
            }
        }
    }

    public static int exec(String[] cmd) {
        int exitVal = -999;
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmd);
            InputStream stderr = proc.getErrorStream();
            InputStreamReader isr = new InputStreamReader(stderr);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            exitVal = proc.waitFor();
            System.out.println("Process exitValue: " + exitVal);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return exitVal;
    }
}

