/*
 * Decompiled with CFR 0.152.
 */
package edicurso;

import as.Jwintab;
import edicurso.Drawer;
import edicurso.Sequencer;
import java.awt.GraphicsConfiguration;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class TabletManager2 {
    static final int DELAY = 16;
    static final int PIXSIZE = 16;
    static int minPenX;
    static int maxPenX;
    static int minPenY;
    static int maxPenY;
    TabletThread tabletThread;
    int[] vals = new int[18];
    boolean enabled = false;
    boolean active = false;
    Sequencer seq;
    TabletManager2 mon = this;
    JScrollPane scrollPane;
    Drawer drawer;
    int scrWidth;
    int scrHeight;
    int scrX;
    int scrY;
    private static TabletManager2 tabletManager;
    final Command penStop = new Command(){

        @Override
        void exec(TabletEvent e) {
            e.seq.getDrawer().clearCursor();
        }
    };
    final Command penMoved = new Command(){

        @Override
        void exec(TabletEvent e) {
            e.seq.penMoved(e);
        }
    };
    final Command penPressed = new Command(){

        @Override
        void exec(TabletEvent e) {
            e.seq.penPressed(e);
        }
    };
    final Command penDragged = new Command(){

        @Override
        void exec(TabletEvent e) {
            e.seq.penDragged(e);
        }
    };
    final Command penReleased = new Command(){

        @Override
        void exec(TabletEvent e) {
            e.seq.penReleased(e);
        }
    };

    static {
        tabletManager = new TabletManager2();
    }

    private TabletManager2() {
    }

    public static TabletManager2 getTabletManager() {
        return tabletManager;
    }

    public final void enable(Sequencer seq, boolean state) {
        if (state == this.enabled) {
            return;
        }
        if (!Jwintab.hasTablet() && state) {
            System.err.println("No tablet driver found");
        }
        if (state) {
            this.enabled = this.initTablet(seq);
        } else {
            this.finishTablet();
        }
        System.out.println("Tablet " + (this.enabled ? "enabled" : "disabled"));
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    boolean initTablet(Sequencer seq) {
        if (!Jwintab.hasTablet()) {
            return false;
        }
        if (this.enabled) {
            return true;
        }
        JScrollPane scrollPane = seq.getUi().getScrollPane();
        GraphicsConfiguration conf = scrollPane.getGraphicsConfiguration();
        Rectangle scrBounds = conf.getBounds();
        int scrWidth = scrBounds.width;
        int scrHeight = scrBounds.height;
        int scrX = scrBounds.x;
        int scrY = scrBounds.y;
        System.out.println("screen= (" + scrX + "," + scrY + ") " + scrWidth + "x" + scrHeight);
        if (!Jwintab.tabletQuery(this.vals)) {
            System.err.println("tablet query failed");
            return false;
        }
        minPenX = this.vals[0];
        maxPenX = this.vals[1];
        minPenY = this.vals[2];
        maxPenY = this.vals[3];
        System.out.println("tablet opened " + minPenX + "->" + maxPenX + " x " + minPenY + "->" + maxPenY);
        System.out.println("input=" + this.vals[4] + "x" + this.vals[5] + "->" + this.vals[6] + "x" + this.vals[7]);
        System.out.println("output=" + this.vals[8] + "x" + this.vals[9] + "->" + this.vals[10] + "x" + this.vals[11]);
        System.out.println("sys=" + this.vals[12] + "x" + this.vals[13] + "->" + this.vals[14] + "x" + this.vals[15]);
        System.out.println("screen=" + this.vals[16] + "x" + this.vals[17]);
        this.vals[12] = 0;
        this.vals[13] = 0;
        this.vals[14] = scrWidth;
        this.vals[15] = scrHeight;
        this.vals[11] = maxPenY + 1;
        this.vals[17] = scrHeight;
        System.out.println("New values");
        System.out.println("input=" + this.vals[4] + "x" + this.vals[5] + "->" + this.vals[6] + "x" + this.vals[7]);
        System.out.println("output=" + this.vals[8] + "x" + this.vals[9] + "->" + this.vals[10] + "x" + this.vals[11]);
        System.out.println("sys=" + this.vals[12] + "x" + this.vals[13] + "->" + this.vals[14] + "x" + this.vals[15]);
        System.out.println("screen=" + this.vals[16] + "x" + this.vals[17]);
        if (!Jwintab.tabletOpen(this.vals, false, false)) {
            System.err.println("tablet open failed");
            return false;
        }
        this.tabletThread = new TabletThread();
        this.tabletThread.setDaemon(true);
        this.tabletThread.setName("Tablet manager thread");
        this.active = false;
        this.enabled = true;
        this.tabletThread.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishTablet() {
        if (!this.enabled) {
            return;
        }
        try {
            TabletManager2 tabletManager2 = this.mon;
            synchronized (tabletManager2) {
                this.enabled = false;
                this.mon.notifyAll();
            }
            this.tabletThread.join();
            this.tabletThread = null;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(Sequencer seq) {
        if (!this.enabled) {
            return false;
        }
        JScrollPane scrollPane = seq.getUi().getScrollPane();
        Drawer drawer = seq.getDrawer();
        GraphicsConfiguration conf = scrollPane.getGraphicsConfiguration();
        Rectangle scrBounds = conf.getBounds();
        int scrWidth = scrBounds.width;
        int scrHeight = scrBounds.height;
        int scrX = scrBounds.x;
        int scrY = scrBounds.y;
        TabletManager2 tabletManager2 = this.mon;
        synchronized (tabletManager2) {
            this.scrollPane = scrollPane;
            this.drawer = drawer;
            this.scrWidth = scrWidth;
            this.scrHeight = scrHeight;
            this.scrX = scrX;
            this.scrY = scrY;
            if (!this.active) {
                this.seq = seq;
                this.active = true;
                this.mon.notifyAll();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        TabletManager2 tabletManager2 = this.mon;
        synchronized (tabletManager2) {
            if (this.active) {
                System.out.println("stop pen");
                this.active = false;
                this.mon.notifyAll();
            }
        }
    }

    static abstract class Command {
        Command() {
        }

        abstract void exec(TabletEvent var1);
    }

    public static class TabletEvent
    implements Runnable {
        int x;
        int y;
        int button;
        int pressure;
        Command cmd;
        static int count = 0;
        int serial = count++;
        Sequencer seq;

        TabletEvent() {
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getPressure() {
            return this.pressure;
        }

        @Override
        public void run() {
            this.cmd.exec(this);
        }
    }

    class TabletThread
    extends Thread {
        final int PEN_IN = 1;
        final int PEN_OUT = 2;
        final int NO_PEN = 3;
        int state;
        TabletEvent ev;
        int winWidth;
        int winHeight;
        int winX;
        int winY;
        int offsetX;
        int offsetY;
        long checkTime;

        TabletThread() {
        }

        void checkStop() throws InterruptedException {
            if (!TabletManager2.this.enabled) {
                throw new InterruptedException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readPen() throws InterruptedException {
            while (true) {
                long currTime;
                if (this.state == 2) {
                    Jwintab.enable(false);
                    Jwintab.overlap(false);
                    TabletManager2 tabletManager2 = TabletManager2.this.mon;
                    synchronized (tabletManager2) {
                        TabletManager2.this.active = false;
                        while (!TabletManager2.this.active && TabletManager2.this.enabled) {
                            TabletManager2.this.mon.wait();
                        }
                        this.checkStop();
                    }
                    Jwintab.enable(true);
                    Jwintab.overlap(true);
                    this.configure();
                    currTime = System.currentTimeMillis();
                    this.state = this.processPacket();
                    if (this.state == 1) {
                        return;
                    }
                    this.checkTime = currTime + 16L;
                    continue;
                }
                currTime = System.currentTimeMillis();
                if (this.state == 3) {
                    TabletManager2 tabletManager2 = TabletManager2.this.mon;
                    synchronized (tabletManager2) {
                        while (currTime < this.checkTime && TabletManager2.this.enabled && TabletManager2.this.active) {
                            TabletManager2.this.mon.wait(this.checkTime - currTime);
                            currTime = System.currentTimeMillis();
                        }
                        this.checkStop();
                        if (!TabletManager2.this.active) {
                            this.state = 2;
                            continue;
                        }
                    }
                    this.configure();
                }
                this.state = this.processPacket();
                if (this.state == 1) {
                    return;
                }
                this.checkTime = currTime + 16L;
            }
        }

        int processPacket() throws InterruptedException {
            int rc = Jwintab.getPacket(TabletManager2.this.vals);
            if (rc < 0) {
                System.out.println("tablet operation failed");
                throw new InterruptedException();
            }
            if (rc == 0) {
                return 3;
            }
            int penX = TabletManager2.this.vals[0];
            int scrollX = (int)((long)penX * (long)TabletManager2.this.scrWidth * 16L / (long)maxPenX - ((long)this.winX - (long)TabletManager2.this.scrX) * 16L);
            int penY = TabletManager2.this.vals[1];
            int scrollY = (int)(((long)TabletManager2.this.scrHeight - (long)this.winY + (long)TabletManager2.this.scrY) * 16L - (long)penY * (long)TabletManager2.this.scrHeight * 16L / (long)maxPenY);
            this.ev.button = TabletManager2.this.vals[2];
            this.ev.pressure = TabletManager2.this.vals[5];
            if (scrollX < 0 || scrollY < 0 || scrollX >= this.winWidth * 16 || scrollY >= this.winHeight * 16) {
                this.invoke(TabletManager2.this.penStop);
                return 2;
            }
            if (penX == 0 || penY == 0) {
                return 3;
            }
            this.ev.x = scrollX + (this.offsetX + 1) * 16;
            this.ev.y = scrollY + (this.offsetY + 1) * 16;
            return 1;
        }

        void configure() throws InterruptedException {
            try {
                Rectangle rect = TabletManager2.this.scrollPane.getViewportBorderBounds();
                this.winWidth = rect.width;
                this.winHeight = rect.height;
                if (this.winWidth <= 0 || this.winHeight <= 0) {
                    throw new InterruptedException();
                }
                Point loc = TabletManager2.this.scrollPane.getLocationOnScreen();
                JPanel whiteboard = TabletManager2.this.seq.ui.getWhiteboard();
                Point loc2 = whiteboard.getLocationOnScreen();
                this.winX = loc.x;
                this.offsetX = loc.x - loc2.x;
                this.winY = loc.y;
                this.offsetY = loc.y - loc2.y;
            }
            catch (IllegalComponentStateException rect) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        void invoke(Command cmd) {
            this.ev.cmd = cmd;
            this.ev.seq = TabletManager2.this.seq;
            SwingUtilities.invokeLater(this.ev);
            this.ev = new TabletEvent();
        }

        @Override
        public void run() {
            this.state = 2;
            this.ev = new TabletEvent();
            this.checkTime = System.currentTimeMillis();
            try {
                while (true) {
                    this.readPen();
                    if (this.ev.button != 1) {
                        this.invoke(TabletManager2.this.penMoved);
                        continue;
                    }
                    this.invoke(TabletManager2.this.penPressed);
                    while (true) {
                        this.readPen();
                        if (this.ev.button != 1) break;
                        this.invoke(TabletManager2.this.penDragged);
                    }
                    this.invoke(TabletManager2.this.penReleased);
                }
            }
            catch (InterruptedException interruptedException) {
                Jwintab.tabletClose();
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Jwintab.tabletClose();
                }
            }
        }
    }
}

