/*
 * Decompiled with CFR 0.152.
 */
package edicurso;

import edicurso.Sequencer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.ListCellRenderer;

public class StrokeBoxRenderer
extends JLabel
implements ListCellRenderer,
ActionListener {
    public static final int IMGWIDTH = 24;
    public static final int IMGHEIGHT = 20;
    static int[] values = new int[]{1, 2, 4, 6, 9, 12};
    static int[] realValues = new int[]{1, 2, 4, 8, 16, 32};
    static int[] heights = new int[]{5, 6, 8, 10, 13, 16};
    public static final BasicStroke[] strokes = new BasicStroke[values.length];
    public static Icon[] icons = new Icon[values.length];
    public static Image[] images = new Image[values.length];
    JComboBox comboBox;
    Sequencer seq;
    private boolean userChange = true;

    static {
        int idx = 0;
        while (idx < values.length) {
            BufferedImage img = new BufferedImage(24, heights[idx], 1);
            StrokeBoxRenderer.images[idx] = img;
            Graphics2D g = (Graphics2D)img.getGraphics();
            StrokeBoxRenderer.strokes[idx] = new BasicStroke(realValues[idx]);
            g.setBackground(Color.white);
            g.clearRect(0, 0, 24, 20);
            g.setColor(Color.black);
            g.setStroke(new BasicStroke(values[idx]));
            g.drawLine(0, heights[idx] / 2, 24, heights[idx] / 2);
            StrokeBoxRenderer.icons[idx] = new ImageIcon(img);
            ++idx;
        }
    }

    public StrokeBoxRenderer(Sequencer seq) {
        this.seq = seq;
        this.comboBox = seq.getUi().getStrokeComboBox();
        int idx = 0;
        while (idx < values.length) {
            this.comboBox.addItem(new Integer(idx));
            ++idx;
        }
        this.setPreferredSize(new Dimension(24, 20));
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.comboBox.setSelectedIndex(1);
        this.comboBox.addActionListener(this);
        this.comboBox.setBackground(Color.white);
        this.comboBox.setForeground(Color.white);
        this.comboBox.setMaximumRowCount(values.length);
        JMenu strokeMn = seq.getUi().getStrokeMn();
        int idx2 = 0;
        while (idx2 < strokes.length) {
            final int mniId = idx2;
            JMenuItem mni = new JMenuItem(icons[idx2]);
            Icon icon = icons[idx2];
            mni.setPreferredSize(new Dimension(icon.getIconWidth() + 10, 16));
            mni.setIconTextGap(-3);
            strokeMn.add(mni);
            mni.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StrokeBoxRenderer.this.seq.setStroke("" + (mniId + 1), realValues[mniId]);
                }
            });
            ++idx2;
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        int idx = (Integer)value;
        this.setIcon(icons[idx]);
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (this.userChange) {
            JComboBox comboBox = (JComboBox)ev.getSource();
            int idx = comboBox.getSelectedIndex();
            this.seq.setStroke("" + (idx + 1), realValues[idx]);
        }
    }

    public void updateSelection(BasicStroke stroke) {
        int val = (int)stroke.getLineWidth();
        int idx = Arrays.binarySearch(realValues, val);
        if (val >= 0) {
            try {
                this.userChange = false;
                this.comboBox.setSelectedIndex(idx);
            }
            finally {
                this.userChange = true;
            }
        }
    }
}

