/*
 * Decompiled with CFR 0.152.
 */
package edicurso;

import edicurso.Log;
import edicurso.Sequencer;
import edicurso.Task;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Queue;

public class Scheduler {
    public static double DEFAULT_ZOOM = 0.25;
    private static Scheduler sched = new Scheduler();
    Sequencer seq;
    static Task awt;
    static Thread awtEventThread;
    Task current;
    final PriorityQueue<Task> pending = new PriorityQueue();
    HashSet<Task> allTasks = new HashSet();
    double currTime;
    double minZoom = 0.0;
    double maxZoom = DEFAULT_ZOOM;
    double defaultZoom = DEFAULT_ZOOM;
    boolean aborted = false;
    static long lasttime;

    static {
        lasttime = System.currentTimeMillis();
    }

    private Scheduler() {
    }

    public static final Scheduler getScheduler() {
        return sched;
    }

    public Sequencer getSequencer() {
        return this.seq;
    }

    public void setSequencer(Sequencer seq) {
        assert (seq == null);
        this.seq = seq;
        awtEventThread = Thread.currentThread();
        this.current = awt = new Task(awtEventThread){

            @Override
            public void run() {
            }
        };
        this.currTime = 0.0;
        this.minZoom = 0.0;
        this.maxZoom = DEFAULT_ZOOM;
        this.defaultZoom = DEFAULT_ZOOM;
        this.aborted = false;
        this.pending.clear();
        this.allTasks.clear();
    }

    public final void doubleSpeed() {
        this.setDefaultZoom(this.defaultZoom / 2.0);
    }

    public final double getMinZoom() {
        return this.minZoom;
    }

    public final double setMinZoom(double newMinZoom) {
        double old = this.minZoom;
        this.minZoom = newMinZoom;
        return old;
    }

    public final double getMaxZoom() {
        return this.maxZoom;
    }

    public final double setMaxZoom(double newMaxZoom) {
        double old = this.maxZoom;
        this.maxZoom = newMaxZoom;
        return old;
    }

    public final double getDefaultZoom() {
        return Math.min(this.defaultZoom, this.maxZoom);
    }

    public final double setDefaultZoom(double zoom) {
        this.defaultZoom = zoom;
        return this.defaultZoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sleep(double rdelay) {
        Task next;
        Task prev = Task.getCurrentTask();
        assert (prev == this.current);
        Object object = this.pending;
        synchronized (object) {
            this.current.nextTime = this.currTime + rdelay;
            this.pending.add(this.current);
            next = (Task)this.pending.remove();
        }
        object = prev;
        synchronized (object) {
            prev.running = false;
            this.resume(next);
            this.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void resume(Task next) {
        Task task = next;
        synchronized (task) {
            next.running = true;
            this.current = next;
            this.currTime = next.nextTime;
            next.notifyAll();
        }
    }

    final void suspend() {
        try {
            Task task = Task.getCurrentTask();
            this.checkAborted();
            while (!task.running) {
                task.wait();
                this.checkAborted();
            }
            assert (task == this.current);
        }
        catch (InterruptedException e) {
            Log.error("interrupted exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void start(Task next) {
        Task prev;
        assert (Task.getCurrentTask() == this.current);
        this.allTasks.add(next);
        TaskThread thread = new TaskThread(next);
        next.nextTime = this.current.nextTime;
        Task task = prev = this.current;
        synchronized (task) {
            prev.running = false;
            next.running = true;
            this.current = next;
            PriorityQueue<Task> priorityQueue = this.pending;
            synchronized (priorityQueue) {
                this.pending.add(prev);
            }
            thread.start();
            this.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void join(Task task) {
        try {
            Task thisTask = Task.getCurrentTask();
            boolean detached = thisTask.detached;
            if (!detached) {
                this.detach();
            }
            Task task2 = task;
            synchronized (task2) {
                this.checkAborted();
                while (!task.finished) {
                    task.wait();
                    this.checkAborted();
                }
            }
            if (!detached) {
                this.attach();
            }
        }
        catch (InterruptedException e) {
            Log.error("interrupted exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doBreak() {
        PriorityQueue<Task> priorityQueue = this.pending;
        synchronized (priorityQueue) {
            this.pending.remove(awt);
            Scheduler.awt.nextTime = this.currTime - 0.001;
            this.pending.add(awt);
        }
        this.sleep(0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void abort() {
        assert (this.current == awt);
        try {
            try {
                PriorityQueue<Task> priorityQueue = this.pending;
                synchronized (priorityQueue) {
                    this.aborted = true;
                }
                Iterator<Task> iterator = this.allTasks.iterator();
                while (iterator.hasNext()) {
                    Task task;
                    Task task2 = task = iterator.next();
                    synchronized (task2) {
                        this.current = task;
                        task.running = true;
                        task.aborted = true;
                        task.notifyAll();
                    }
                }
                for (Task task : this.allTasks) {
                    task.thread.join();
                }
                this.current = awt;
                this.pending.clear();
            }
            catch (InterruptedException e) {
                Log.error("abort interrupted?");
                this.seq = null;
            }
        }
        finally {
            this.seq = null;
        }
    }

    final void checkAborted() {
        Task thisTask = Task.getCurrentTask();
        if (thisTask.aborted && !thisTask.abortThrown && !thisTask.finished) {
            thisTask.abortThrown = true;
            throw new AbortException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void attach() {
        Task thisTask = Task.getCurrentTask();
        assert (thisTask.detached && thisTask.running);
        thisTask.detached = false;
        Task task = thisTask;
        synchronized (task) {
            boolean idle;
            PriorityQueue<Task> priorityQueue = this.pending;
            synchronized (priorityQueue) {
                this.checkAborted();
                thisTask.nextTime = this.currTime;
                boolean bl = idle = this.current == null;
                if (!idle) {
                    this.pending.add(thisTask);
                } else if (!this.aborted) {
                    this.current = thisTask;
                }
            }
            if (!idle) {
                thisTask.running = false;
                this.suspend();
            } else {
                Log.line(String.valueOf(this.currTime) + ": attaching " + thisTask.getName() + " as current");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void detach() {
        this.checkAborted();
        Task thisTask = Task.getCurrentTask();
        Task next = null;
        assert (!thisTask.detached && thisTask == this.current && thisTask.running);
        PriorityQueue<Task> priorityQueue = this.pending;
        synchronized (priorityQueue) {
            if (this.pending.isEmpty()) {
                this.current = null;
            } else {
                next = (Task)this.pending.remove();
            }
        }
        thisTask.detached = true;
        if (next != null) {
            this.resume(next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(Queue<Task> queue) {
        Task next;
        Task task = Task.getCurrentTask();
        assert (task != awt);
        queue.offer(task);
        Object object = this.pending;
        synchronized (object) {
            this.checkAborted();
            next = (Task)this.pending.remove();
        }
        object = task;
        synchronized (object) {
            task.running = false;
            this.resume(next);
            this.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeupAll(Queue<Task> queue) {
        PriorityQueue<Task> priorityQueue = this.pending;
        synchronized (priorityQueue) {
            while (!queue.isEmpty()) {
                Task task = queue.remove();
                task.nextTime = this.currTime;
                this.pending.offer(task);
            }
        }
    }

    static void show(String msg) {
        long now = System.currentTimeMillis();
        System.out.println(String.valueOf(now - lasttime) + " -> " + msg);
        lasttime = now;
    }

    static class AbortException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        AbortException() {
        }
    }

    static class TaskThread
    extends Thread {
        Task task;

        TaskThread(Task task) {
            this.task = task;
            task.thread = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block17: {
                Scheduler sched = Scheduler.getScheduler();
                try {
                    try {
                        this.task.run();
                    }
                    catch (AbortException e) {
                        Log.line(String.valueOf(sched.currTime) + ": TaskThread.run aborted: " + this.task.getName());
                        this.task.finished = true;
                        if (!this.task.detached) {
                            sched.detach();
                        }
                        Task task = this.task;
                        synchronized (task) {
                            this.task.notifyAll();
                            break block17;
                        }
                    }
                }
                catch (Throwable throwable) {
                    this.task.finished = true;
                    if (!this.task.detached) {
                        sched.detach();
                    }
                    Task task = this.task;
                    synchronized (task) {
                        this.task.notifyAll();
                    }
                    throw throwable;
                }
                this.task.finished = true;
                if (!this.task.detached) {
                    sched.detach();
                }
                Task task = this.task;
                synchronized (task) {
                    this.task.notifyAll();
                }
            }
        }
    }
}

