/*
 * Decompiled with CFR 0.152.
 */
package edicurso;

import edicurso.Sequencer;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;

public class PopupFactory {
    Sequencer seq;

    public PopupFactory(Sequencer seq) {
        this.seq = seq;
    }

    public JPopupMenu makePopupMenu() {
        JMenuBar menuBar = this.seq.getUi().getMenuBar();
        JPopupMenu popup = new JPopupMenu();
        this.duplicate(popup, menuBar.getSubElements());
        return popup;
    }

    private void duplicate(Container parent, MenuElement[] elements) {
        MenuElement[] menuElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            MenuElement elem = menuElementArray[n2];
            if (elem instanceof JSeparator) {
                JSeparator sep = (JSeparator)((Object)elem);
                JSeparator sepPeer = new JSeparator();
                sepPeer.setOrientation(sep.getOrientation());
                parent.add(sepPeer);
            } else if (elem instanceof JMenu) {
                JMenu menu = (JMenu)elem;
                JMenu menuPeer = new JMenu(menu.getText());
                this.duplicate(menuPeer, elem.getSubElements());
                parent.add(menuPeer);
            } else if (elem instanceof JPopupMenu) {
                this.duplicate(parent, elem.getSubElements());
            } else if (elem instanceof JMenuItem) {
                JMenuItem itemPeer;
                final JMenuItem item = (JMenuItem)elem;
                if (item instanceof JCheckBoxMenuItem) {
                    JCheckBoxMenuItem checkBoxPeer = new JCheckBoxMenuItem();
                    JCheckBoxMenuItem checkBox = (JCheckBoxMenuItem)item;
                    itemPeer = checkBoxPeer;
                    checkBoxPeer.setSelected(checkBox.isSelected());
                    checkBoxPeer.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    item.doClick();
                                }
                            });
                        }
                    });
                } else {
                    itemPeer = new JMenuItem();
                    ActionListener[] actionListenerArray = item.getActionListeners();
                    int n3 = actionListenerArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ActionListener l = actionListenerArray[n4];
                        itemPeer.addActionListener(l);
                        ++n4;
                    }
                }
                itemPeer.setText(item.getText());
                itemPeer.setPreferredSize(item.getPreferredSize());
                itemPeer.setIcon(item.getIcon());
                itemPeer.setIconTextGap(item.getIconTextGap());
                itemPeer.setAccelerator(item.getAccelerator());
                parent.add(itemPeer);
            } else if (elem instanceof JPopupMenu) {
                JPopupMenu popup = (JPopupMenu)elem;
                System.out.println("popup menu " + popup.getInvoker());
            }
            ++n2;
        }
    }

    static JMenuItem find(MenuElement elem, String text) {
        MenuElement[] subElements;
        JMenuItem item;
        if (elem instanceof JMenuItem && text.equals((item = (JMenuItem)elem).getText())) {
            return item;
        }
        MenuElement[] menuElementArray = subElements = elem.getSubElements();
        int n = subElements.length;
        int n2 = 0;
        while (n2 < n) {
            MenuElement subElem = menuElementArray[n2];
            JMenuItem target = PopupFactory.find(subElem, text);
            if (target != null) {
                return target;
            }
            ++n2;
        }
        return null;
    }
}

