/*
 * Decompiled with CFR 0.152.
 */
package edicurso;

import edicurso.AudioManager;
import edicurso.Drawer;
import edicurso.Scheduler;
import edicurso.Sequencer;
import edicurso.Task;
import edicurso.operations.Node;
import edicurso.operations.RootNode;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;

public class Player
extends Task {
    public static final int FRAMEPERIOD = 10;
    Node currNode;
    Runnable epilog;
    Sequencer sequencer;
    Drawer drawer;
    AudioManager manager;
    int width;
    int height;
    int frames = 0;
    long lastTime;
    int nodeStartTime;
    int elapsedTime = 0;
    long schedStartTime;
    public Queue<Task> waitFrameTasks = new ArrayDeque<Task>();

    public Player(Drawer drawer, Node paintedNode, AudioManager manager) {
        this.currNode = paintedNode;
        this.manager = manager;
        this.drawer = drawer;
        this.width = drawer.getWidth();
        this.height = drawer.getHeight();
    }

    public final AudioManager getAudioManager() {
        return this.manager;
    }

    public final Drawer getDrawer() {
        return this.drawer;
    }

    public final int getElapsedTime() {
        return this.elapsedTime;
    }

    public void setSequencer(Sequencer sequencer) {
        this.sequencer = sequencer;
    }

    public final Sequencer getSequencer() {
        return this.sequencer;
    }

    public void setEpilog(Runnable epilog) {
        this.epilog = epilog;
    }

    public void doBreak() {
        this.sequencer.select(this.currNode);
        Sequencer.getAudioManager().pause();
        this.sequencer.setState(this.sequencer.pauseState);
        this.sequencer.resetTimer(0);
        this.sequencer.needsRepaint();
    }

    public void play() {
        this.lastTime = this.schedStartTime = System.currentTimeMillis();
        this.nodeStartTime = this.elapsedTime;
        this.sequencer.resetTimer(10);
    }

    @Override
    public void run() {
        this.nodeStartTime = this.sequencer.getTimeManager().getRealTime(this.currNode);
        this.schedStartTime = System.currentTimeMillis();
        try {
            try {
                this.setName("player");
                this.drawer.setPlayer(this);
                RootNode rootNode = this.sequencer.getRootNode();
                this.width = rootNode.width;
                this.height = rootNode.height;
                System.out.println("Player.run: starting timer");
                this.lastTime = System.currentTimeMillis();
                this.sequencer.resetTimer(10);
                this.manager.waitPlaying(this);
                this.currNode.repaint(this);
                this.manager.startPlay(this.currNode);
                this.drawer.touchAll();
                TreeNode[] branch = this.currNode.getBranch();
                rootNode.play(branch, 0, this);
            }
            catch (Scheduler.AbortException abortException) {
                long elapsed = System.currentTimeMillis() - this.schedStartTime;
                if (this.frames != 0) {
                    System.out.println("Elapsed time: " + elapsed);
                    System.out.println("Mean time between frames: " + elapsed / (long)this.frames);
                }
                this.drawer.setPlayer(null);
                if (this.epilog != null) {
                    SwingUtilities.invokeLater(this.epilog);
                }
            }
        }
        finally {
            long elapsed = System.currentTimeMillis() - this.schedStartTime;
            if (this.frames != 0) {
                System.out.println("Elapsed time: " + elapsed);
                System.out.println("Mean time between frames: " + elapsed / (long)this.frames);
            }
            this.drawer.setPlayer(null);
            if (this.epilog != null) {
                SwingUtilities.invokeLater(this.epilog);
            }
        }
    }

    public Node getCurrentNode() {
        return this.currNode;
    }

    public void setCurrentNode(Node node) {
        this.currNode = node;
    }

    public void waitNextFrame() {
        Task.await(this.waitFrameTasks);
    }

    public final void tick() {
        long currTime = this.sequencer.getTickTime();
        int delta = (int)(currTime - this.lastTime);
        Scheduler sched = Scheduler.getScheduler();
        sched.wakeupAll(this.waitFrameTasks);
        sched.sleep(delta);
        this.lastTime = currTime;
        this.sequencer.needsRedraw();
        ++this.frames;
        this.sequencer.playerSelect(this.currNode);
        this.elapsedTime = (int)(currTime - this.schedStartTime) + this.nodeStartTime;
        this.sequencer.updateCurrentTime(this.elapsedTime);
        this.sequencer.setNextTick(10);
    }

    public static Player makePlayer(final Sequencer seq, Node node) {
        final Player constPlayer = new Player(seq.getDrawer(), node, Sequencer.getAudioManager());
        constPlayer.setEpilog(new Runnable(){

            @Override
            public void run() {
                seq.playEpilog(constPlayer.getCurrentNode());
            }
        });
        constPlayer.setSequencer(seq);
        return constPlayer;
    }
}

