/*
 * Decompiled with CFR 0.152.
 */
package edicurso;

import edicurso.Scheduler;
import edicurso.Sequencer;
import edicurso.Visitor;
import edicurso.operations.AudioClip;
import edicurso.operations.Composite;
import edicurso.operations.EndAudioClip;
import edicurso.operations.Node;
import edicurso.operations.RootNode;

public class OldTimeManager
extends Visitor {
    int totalTime;
    Sequencer seq;
    boolean playingAudio;
    Node target;

    public OldTimeManager(Sequencer seq) {
        this.seq = seq;
    }

    @Override
    public void visit(Node node) throws Exception {
        if (node == this.target) {
            this.stop();
        }
        if (node instanceof AudioClip) {
            this.totalTime += ((AudioClip)node).getTime();
            this.playingAudio = true;
        } else if (this.playingAudio) {
            if (node instanceof EndAudioClip) {
                this.playingAudio = false;
            }
        } else {
            this.totalTime = (int)((double)this.totalTime + (double)node.getDelay() * Scheduler.DEFAULT_ZOOM);
        }
    }

    @Override
    public void postVisit(Composite comp) throws Visitor.StopException {
        if (!this.playingAudio && !(comp instanceof RootNode)) {
            this.totalTime = (int)((double)this.totalTime + (double)comp.getPostDelay() * Scheduler.DEFAULT_ZOOM);
        }
    }

    public int getRealTime(Node node) {
        this.target = node;
        this.totalTime = 0;
        this.playingAudio = false;
        this.traverseFrom(this.seq.getRootNode());
        return this.totalTime;
    }

    public static String formatRealTime(int time) {
        int secs = time / 1000;
        int mins = secs / 60;
        return String.valueOf(OldTimeManager.twoDigits(mins)) + ":" + OldTimeManager.twoDigits(secs -= mins * 60);
    }

    public static String twoDigits(int t) {
        return t < 10 ? "0" + t : "" + t;
    }
}

