/*
 * Decompiled with CFR 0.152.
 */
package edicurso;

import edicurso.AudioManager;
import edicurso.ColorBoxRenderer;
import edicurso.Player;
import edicurso.Sequencer;
import edicurso.StrokeBoxRenderer;
import edicurso.Visitor;
import edicurso.operations.Composite;
import edicurso.operations.Eraser;
import edicurso.operations.Node;
import edicurso.operations.RootNode;
import edicurso.operations.SetColor;
import edicurso.operations.SetStroke;
import edicurso.operations.ShowImage;
import edicurso.operations.Slide;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class Drawer
extends JPanel {
    public static final int CAPSTYLE = 1;
    public static final int JOINSTYLE = 1;
    private static final long serialVersionUID = 1L;
    AudioManager playManager = null;
    Sequencer seq = null;
    Player player = null;
    int frames = 0;
    public int cnt;
    HitVisitor hitVisitor = new HitVisitor();
    Draw4Player draw4player = new Draw4Player();
    Draw4Seek draw4seek = new Draw4Seek();
    Draw4Ghosts draw4ghosts = new Draw4Ghosts();
    Node drawNode = null;
    private BasicStroke currStroke = wideStroke;
    private BasicStroke realStroke = wideStroke;
    private BasicStroke oldStroke;
    Color currColor;
    Color oldColor;
    static final AlphaComposite acMiddle = AlphaComposite.getInstance(3, 0.4f);
    static final AlphaComposite acOpaque = AlphaComposite.getInstance(3, 1.0f);
    public Rectangle2D.Float bounds = new Rectangle2D.Float();
    Dimension area = new Dimension();
    boolean hasCursor = false;
    int cursorX;
    int cursorY;
    Rectangle2D.Float cursorBox = new Rectangle2D.Float();
    boolean pauseMark = false;
    boolean recMark = false;
    Font recMarkFont = new Font(null, 0, 40);
    static final BasicStroke wideStroke = new BasicStroke(2.0f, 1, 1);
    static final int bgVal = 220;
    public static final Color bg = new Color(220, 220, 220);
    static final AlphaComposite acGhostImg = AlphaComposite.getInstance(3, 0.13671875f);
    static final Color fg = Color.black;
    static final Color red = Color.red;
    static final Color white = Color.white;

    public Drawer(Sequencer seq, AudioManager playManager) {
        this.seq = seq;
        this.playManager = playManager;
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.clear();
    }

    public final AudioManager getAudioManager() {
        return this.playManager;
    }

    public final Sequencer getSequencer() {
        return this.seq;
    }

    public final Player getPlayer() {
        return this.player;
    }

    public final void setPlayer(Player newPlayer) {
        this.player = newPlayer;
        this.frames = 0;
        this.computeArea();
    }

    public final void setDrawNode(Node node) {
        this.drawNode = node;
    }

    public final void setPauseMark(boolean flag) {
        this.touchAll();
        this.pauseMark = flag;
    }

    public final void setRecMark(boolean flag) {
        this.touchAll();
        this.recMark = flag;
    }

    public final void setStroke(BasicStroke stroke) {
        this.currStroke = stroke;
    }

    public final BasicStroke getStroke() {
        return this.currStroke;
    }

    public final void setRealStroke(BasicStroke stroke) {
        this.realStroke = stroke;
    }

    public final BasicStroke getRealStroke() {
        return this.realStroke;
    }

    public final Color getColor() {
        return this.currColor;
    }

    public final void setColor(Color color) {
        this.currColor = color;
    }

    public void computeArea() {
        RootNode rootNode = this.seq.getRootNode();
        JPanel whiteboard = this.seq.getUi().getWhiteboard();
        JScrollPane scrollPane = this.seq.getUi().getScrollPane();
        int width = rootNode.getWidth();
        int height = rootNode.getHeight();
        if (this.player != null) {
            if (scrollPane != null) {
                Rectangle rect = scrollPane.getViewportBorderBounds();
                this.area.width = rect.width;
                this.area.height = rect.height;
            }
        } else if (width != this.area.width || height != this.area.height) {
            this.area.width = width;
            this.area.height = height;
        }
        whiteboard.setPreferredSize(this.area);
        whiteboard.revalidate();
    }

    public double getZoom() {
        if (this.player == null && !this.seq.isRelator()) {
            return 1.0;
        }
        RootNode rootNode = this.seq.getRootNode();
        double zoomX = (double)this.getWidth() / (double)rootNode.getWidth();
        double zoomY = (double)this.getHeight() / (double)rootNode.getHeight();
        double zoom = Math.min(zoomX, zoomY);
        return zoom;
    }

    public final boolean requires(Rectangle2D.Float box) {
        boolean ret = this.bounds.intersects(box);
        return ret;
    }

    public void touch(Rectangle2D.Float box) {
        if (this.bounds.isEmpty()) {
            this.bounds.setRect(box);
        } else {
            this.bounds.add(box);
        }
    }

    public void touch(float x, float y) {
        if (this.bounds.isEmpty()) {
            this.bounds.setRect(x, y, 1.0f, 1.0f);
        } else {
            this.bounds.add(x, y);
        }
    }

    public final void touchAll() {
        this.bounds.add(-1.073741824E9, -1.073741824E9);
        this.bounds.add(1.073741823E9, 1.073741823E9);
    }

    final void boundsReset() {
        this.bounds = new Rectangle2D.Float(0.0f, 0.0f, -1.0f, -1.0f);
    }

    final void setGraphicsContext(Graphics2D g2d, Rectangle clip) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        this.setColor(Color.black);
        this.setStroke(wideStroke);
        this.setRealStroke(wideStroke);
        g2d.setPaint(bg);
        g2d.fillRect(clip.x, clip.y, clip.width, clip.height);
        g2d.setBackground(bg);
        g2d.setStroke(wideStroke);
        g2d.setPaint(Color.black);
    }

    @Override
    public final void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform saveAt = g2d.getTransform();
        Rectangle clip = g2d.getClipBounds();
        double zoom = this.getZoom();
        double tx = (double)clip.x / zoom;
        double ty = (double)clip.y / zoom;
        double tw = (double)clip.width / zoom;
        double th = (double)clip.height / zoom;
        this.bounds.add(tx, ty);
        this.bounds.add(tx + tw, ty + th);
        super.paintComponent(g);
        this.setGraphicsContext(g2d, clip);
        this.cnt = 0;
        try {
            if (this.player != null) {
                ++this.frames;
            }
            if (this.seq.isPlaying() || this.seq.isAdjusting()) {
                g2d.setComposite(acOpaque);
                this.draw4player.setGraphics(g2d);
                this.draw4player.walkTree(this.drawNode.getRoot());
            } else {
                Node root = this.drawNode.getRoot();
                root.draw(g2d, this);
                this.draw4ghosts.setGraphics(g2d);
                this.draw4ghosts.walkTree(root);
                Node leadNode = this.seq.getLeadNode();
                if (leadNode != null) {
                    g2d.setComposite(acMiddle);
                }
                this.setStroke(wideStroke);
                this.setRealStroke(wideStroke);
                g2d.setStroke(wideStroke);
                this.setColor(Color.black);
                g2d.setPaint(Color.black);
                this.draw4seek.setLeadNode(leadNode);
                this.draw4seek.setGraphics(g2d);
                this.draw4seek.walkTree(root);
                JComboBox colorComboBox = this.seq.getUi().getColorComboBox();
                if (colorComboBox != null) {
                    if (this.currColor != this.oldColor) {
                        ((ColorBoxRenderer)colorComboBox.getRenderer()).updateSelection(this.currColor);
                        this.oldColor = this.currColor;
                    }
                    if (this.currStroke != this.oldStroke) {
                        JComboBox strokeComboBox = this.seq.getUi().getStrokeComboBox();
                        ((StrokeBoxRenderer)strokeComboBox.getRenderer()).updateSelection(this.currStroke);
                        this.oldStroke = this.currStroke;
                    }
                }
            }
            g2d.setTransform(saveAt);
            this.drawCursor(g2d);
            if (this.pauseMark) {
                g2d.setComposite(acMiddle);
                g2d.setPaint(Color.black);
                this.drawPauseMark(g2d);
            } else if (this.recMark) {
                g2d.setComposite(acMiddle);
                g2d.setPaint(Color.red);
                this.drawRecMark(g2d);
            }
        }
        finally {
            g2d.setTransform(saveAt);
            this.boundsReset();
        }
    }

    public final void redraw() {
        if (this.player == null) {
            int x = (int)this.bounds.x;
            int y = (int)this.bounds.y;
            int width = (int)Math.ceil(this.bounds.width);
            int height = (int)Math.ceil(this.bounds.height);
            this.repaint(x, y, width, height);
        } else {
            double zoom = this.getZoom();
            int x = (int)((double)this.bounds.x * zoom);
            int y = (int)((double)this.bounds.y * zoom);
            int width = (int)Math.ceil((double)this.bounds.width * zoom);
            int height = (int)Math.ceil((double)this.bounds.height * zoom);
            this.repaint(0L, x, y, width, height);
        }
    }

    public final void clear() {
        this.currColor = Color.black;
        this.currStroke = wideStroke;
        this.touchAll();
    }

    public final void clearCursor() {
        if (this.hasCursor) {
            this.hasCursor = false;
            this.touch(this.cursorBox);
            this.redraw();
        }
    }

    public final void setPenCursor(int x, int y) {
        boolean changed = false;
        if (!this.hasCursor) {
            changed = true;
            this.hasCursor = true;
        }
        if (x != this.cursorX || y != this.cursorY) {
            changed = true;
            this.touch(this.cursorBox);
            this.cursorX = x;
            this.cursorY = y;
            this.cursorBox.setRect(this.cursorX - 11, this.cursorY - 11, 23.0f, 23.0f);
        }
        if (changed) {
            this.redraw();
        }
    }

    public final void drawCursor(Graphics2D g2d) {
        if (this.hasCursor) {
            g2d.setStroke(wideStroke);
            if (this.currColor.equals(bg)) {
                g2d.setPaint(white);
            }
            g2d.drawLine(this.cursorX - 10, this.cursorY, this.cursorX + 10, this.cursorY);
            g2d.drawLine(this.cursorX, this.cursorY - 10, this.cursorX, this.cursorY + 10);
        }
    }

    public final void drawPauseMark(Graphics2D g2d) {
        RootNode rootNode = this.seq.getRootNode();
        double zoom = this.getZoom();
        int x = (int)((double)rootNode.getWidth() * zoom);
        int y = (int)((double)rootNode.getHeight() * zoom);
        int size = 100;
        int border = 30;
        g2d.fillRect(x - 100 - 30, y - 100 - 30, 33, 100);
        g2d.fillRect(x - 33 - 30, y - 100 - 30, 33, 100);
    }

    public final void drawRecMark(Graphics2D g2d) {
        int xc = this.getWidth() / 2;
        int yc = this.getHeight() / 2;
        g2d.setFont(this.recMarkFont);
        g2d.drawString("REC", xc - 50, yc - 10);
    }

    void debugWindow() {
        System.out.println("Window: " + this.getBounds());
        GraphicsConfiguration conf = this.getGraphicsConfiguration();
        System.out.println("GraphicsConfiguration: " + conf.getBounds());
        GraphicsDevice dev = conf.getDevice();
        DisplayMode mode = dev.getDisplayMode();
        int w = mode.getWidth();
        int h = mode.getHeight();
        System.out.println("Device size= " + w + "x" + h);
        System.out.println("panel location: " + this.getLocationOnScreen());
    }

    public Node getHitNode(int x, int y) {
        return this.hitVisitor.getHitNode(x, y);
    }

    public boolean isHit(int x, int y, HashSet<Node> selectedSet) {
        return this.hitVisitor.isHit(x, y, selectedSet);
    }

    class Draw4Ghosts
    extends Draw4Player {
        Node lastNode;

        Draw4Ghosts() {
        }

        @Override
        public void walk(Node node) throws Exception {
            if (!this.ghostMode) {
                if (node instanceof SetStroke || node instanceof Eraser || node instanceof SetColor) {
                    node.draw(this.g2d, Drawer.this);
                }
                if (node == Drawer.this.drawNode) {
                    this.lastNode = Drawer.this.seq.getGhostNode(node);
                    if (this.lastNode == Drawer.this.drawNode) {
                        this.stop();
                    }
                    this.g2d.setComposite(acOpaque);
                    this.ghostMode = true;
                    if (Drawer.this.getColor() != bg) {
                        this.g2d.setPaint(Color.WHITE);
                    }
                }
            } else {
                if (node instanceof ShowImage) {
                    java.awt.Composite oldAc = this.g2d.getComposite();
                    this.g2d.setComposite(acGhostImg);
                    node.draw(this.g2d, Drawer.this);
                    this.g2d.setComposite(oldAc);
                } else {
                    node.draw(this.g2d, Drawer.this);
                    if (node instanceof SetColor) {
                        Drawer.this.setColor(Color.white);
                        this.g2d.setPaint(Color.white);
                    }
                }
                if (node == this.lastNode) {
                    this.stop();
                }
            }
        }
    }

    class Draw4Player
    extends Visitor {
        Graphics2D g2d;
        boolean ghostMode;

        Draw4Player() {
        }

        public void setGraphics(Graphics2D g2d) {
            this.g2d = g2d;
            this.ghostMode = false;
        }

        @Override
        public void walk(Node node) throws Exception {
            node.draw(this.g2d, Drawer.this);
            if (node == Drawer.this.drawNode) {
                this.stop();
            }
        }

        @Override
        public void walkComposite(Composite comp) throws Exception {
            if (!(comp instanceof Slide) || comp.isNodeDescendant(Drawer.this.drawNode)) {
                this.walk(comp);
                BasicStroke oldStroke = Drawer.this.getStroke();
                BasicStroke oldRealStroke = Drawer.this.getRealStroke();
                Color oldColor = Drawer.this.getColor();
                super.walkComposite(comp);
                this.postWalk(comp);
                Drawer.this.setStroke(oldStroke);
                Drawer.this.setRealStroke(oldRealStroke);
                this.g2d.setStroke(oldStroke);
                Drawer.this.setColor(oldColor);
                this.g2d.setPaint(this.ghostMode ? Color.white : oldColor);
            }
        }

        public void postWalk(Composite comp) throws Exception {
        }
    }

    class Draw4Seek
    extends Draw4Player {
        Node leadNode;
        boolean found;

        Draw4Seek() {
        }

        public void setLeadNode(Node node) {
            this.leadNode = node;
            this.found = false;
        }

        @Override
        public void walk(Node node) throws Exception {
            if (this.found) {
                this.stop();
            }
            if (node == this.leadNode) {
                this.g2d.setComposite(acOpaque);
            }
            if (!(node instanceof RootNode)) {
                node.draw(this.g2d, Drawer.this);
            }
            if (node == Drawer.this.drawNode) {
                this.found = true;
            }
        }

        @Override
        public void postWalk(Composite comp) throws Exception {
            if (this.found && Drawer.this.seq.isExpanded(comp)) {
                this.stop();
            }
        }
    }

    class HitVisitor
    extends Visitor {
        boolean hit;
        Node lastNode;
        Graphics2D g2d;
        Rectangle rect = new Rectangle();
        int x;
        int y;
        HashSet<Node> selectedSet;
        HashMap<Node, BasicStroke> strokeMap = new HashMap();
        ArrayList<Node> hitSet = new ArrayList();
        ArrayList<Node> refinedHitSet = new ArrayList();
        static final int DELTA = 20;

        HitVisitor() {
        }

        public Node getHitNode(int x, int y) {
            this.x = x;
            this.y = y;
            this.hit = false;
            this.lastNode = Drawer.this.seq.isPlaying() ? Drawer.this.seq.current() : Drawer.this.seq.getGhostNode(Drawer.this.drawNode);
            int delta = 20;
            this.rect = new Rectangle(x - delta / 2, y - delta / 2, delta, delta);
            this.g2d = (Graphics2D)Drawer.this.getGraphics();
            this.strokeMap.clear();
            this.walkTree(Drawer.this.drawNode.getRoot());
            if (this.hitSet.size() == 0) {
                return null;
            }
            this.refine(this.hitSet, this.refinedHitSet, delta, 1);
            Node found = this.refinedHitSet.size() == 0 ? this.hitSet.get(0) : this.refinedHitSet.get(0);
            this.hitSet.clear();
            this.refinedHitSet.clear();
            this.strokeMap.clear();
            return found;
        }

        public void refine(ArrayList<Node> src, ArrayList<Node> dest, int maxDelta, int minDelta) {
            int pivotDelta = (maxDelta + minDelta) / 2;
            dest.clear();
            if (pivotDelta == maxDelta) {
                return;
            }
            this.rect.setBounds(this.x - pivotDelta / 2, this.y - pivotDelta / 2, pivotDelta, pivotDelta);
            for (Node node : src) {
                this.g2d.setStroke(this.strokeMap.get(node));
                if (!node.hit(this.g2d, this.rect)) continue;
                dest.add(node);
            }
            if (dest.size() == 0) {
                this.refine(src, dest, maxDelta, pivotDelta + 1);
            } else if (dest.size() > 1) {
                src.clear();
                for (Node node : dest) {
                    src.add(node);
                }
                dest.clear();
                this.refine(src, dest, pivotDelta, minDelta);
            }
        }

        public boolean isHit(int x, int y, HashSet<Node> selectedSet) {
            this.x = x;
            this.y = y;
            this.selectedSet = selectedSet;
            this.hit = false;
            this.lastNode = Drawer.this.drawNode;
            int delta = 20;
            this.rect = new Rectangle(x - delta / 2, y - delta / 2, delta, delta);
            this.g2d = (Graphics2D)Drawer.this.getGraphics();
            this.walkTree(Drawer.this.drawNode.getRoot());
            this.selectedSet = null;
            return this.hit;
        }

        boolean isSelected(Node node) {
            do {
                if (!this.selectedSet.contains(node)) continue;
                return true;
            } while ((node = node.getParent()) != null);
            return false;
        }

        @Override
        public void walk(Node node) throws Exception {
            if (node instanceof SetStroke || node instanceof Eraser) {
                node.draw(this.g2d, Drawer.this);
            } else if (this.selectedSet != null) {
                if (this.isSelected(node) && node.hit(this.g2d, this.rect)) {
                    this.hit = true;
                    this.stop();
                }
            } else if (node.hit(this.g2d, this.rect)) {
                this.hitSet.add(node);
                this.strokeMap.put(node, Drawer.this.getStroke());
            }
            if (node == this.lastNode) {
                this.stop();
            }
        }

        @Override
        public void walkComposite(Composite comp) throws Exception {
            if (!(comp instanceof Slide) || comp.isNodeDescendant(Drawer.this.drawNode)) {
                BasicStroke oldStroke = Drawer.this.getStroke();
                BasicStroke oldRealStroke = Drawer.this.getRealStroke();
                super.walkComposite(comp);
                Drawer.this.setStroke(oldStroke);
                Drawer.this.setRealStroke(oldRealStroke);
            }
        }
    }
}

