/*
 * Decompiled with CFR 0.152.
 */
package edicurso;

import edicurso.AudioManager;
import edicurso.Log;
import edicurso.Sequencer;
import edicurso.operations.AudioClip;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;

public class CaptureManager {
    public static final AudioFormat audioFormat = CaptureManager.getAudioFormat();
    public static final int REC_CHOP = 100;
    static AudioManager.Finder finder = AudioManager.finder;
    boolean stop = false;
    ByteArrayOutputStream byteArrayOutputStream;
    TargetDataLine targetDataLine;
    Thread captureThread;
    Sequencer seq;
    int clipCount = 1;
    int elapsedTime;
    private static CaptureManager captureManager = new CaptureManager();

    private CaptureManager() {
    }

    public static CaptureManager getCaptureManager() {
        return captureManager;
    }

    public final Sequencer getSequencer() {
        return this.seq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioClip stopCapture() {
        try {
            if (this.captureThread == null) {
                return null;
            }
            try {
                CaptureManager captureManager = this;
                synchronized (captureManager) {
                    this.stop = true;
                    this.notifyAll();
                }
                this.captureThread.join();
            }
            catch (Exception e) {
                System.err.println(e);
            }
            this.captureThread = null;
            byte[] audioData = this.byteArrayOutputStream.toByteArray();
            int chopSize = AudioClip.time2size(audioFormat, 100);
            int size = audioData.length - 2 * chopSize;
            if (size < AudioClip.time2size(audioFormat, 70)) {
                return null;
            }
            ByteArrayInputStream in = new ByteArrayInputStream(audioData, chopSize, size);
            AudioClip audioClip = new AudioClip(audioFormat, in, size);
            return audioClip;
        }
        finally {
            this.seq = null;
        }
    }

    public final synchronized boolean running() {
        return !this.stop;
    }

    public void startCapture(Sequencer seq) {
        try {
            this.seq = seq;
            this.stop = false;
            if (this.targetDataLine == null) {
                DataLine.Info dataLineInfo = new DataLine.Info(TargetDataLine.class, audioFormat);
                this.targetDataLine = (TargetDataLine)AudioSystem.getLine(dataLineInfo);
            }
            this.targetDataLine.open(audioFormat);
            this.targetDataLine.start();
            this.captureThread = new Thread(new CaptureThread());
            this.captureThread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.error(e.toString());
        }
    }

    public static AudioFormat getAudioFormat() {
        float sampleRate = 16000.0f;
        int sampleSizeInBits = 16;
        int channels = 1;
        boolean signed = true;
        boolean bigEndian = false;
        return new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
    }

    class CaptureThread
    extends Thread {
        byte[] tempBuffer = new byte[10000];

        CaptureThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            CaptureManager.this.byteArrayOutputStream = new ByteArrayOutputStream();
            CaptureManager.this.stop = false;
            try {
                int avail;
                block5: while (true) {
                    avail = CaptureManager.this.targetDataLine.available();
                    while (avail < 1000) {
                        CaptureManager captureManager = CaptureManager.this;
                        synchronized (captureManager) {
                            CaptureManager.this.wait(16L);
                            if (CaptureManager.this.stop) {
                                break block5;
                            }
                        }
                        avail = CaptureManager.this.targetDataLine.available();
                    }
                    int cnt = CaptureManager.this.targetDataLine.read(this.tempBuffer, 0, Math.min(avail, this.tempBuffer.length));
                    assert (cnt > 0);
                    CaptureManager.this.byteArrayOutputStream.write(this.tempBuffer, 0, cnt);
                }
                CaptureManager.this.elapsedTime = (int)(System.currentTimeMillis() - startTime);
                avail = CaptureManager.this.targetDataLine.available();
                int cnt = 0;
                while (cnt < avail) {
                    cnt += CaptureManager.this.targetDataLine.read(this.tempBuffer, 0, Math.min(avail, this.tempBuffer.length));
                }
                CaptureManager.this.byteArrayOutputStream.close();
                CaptureManager.this.targetDataLine.close();
                CaptureManager.this.targetDataLine.drain();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }
}

