/*
 * Decompiled with CFR 0.152.
 */
package relator;

import edicurso.Drawer;
import edicurso.UI;
import edicurso.operations.Node;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;
import relator.RGuiNode;
import relator.RelatorAboutBox;
import relator.RelatorApp;
import relator.RelatorModel;
import relator.RelatorSequencer;

public class RelatorView
extends FrameView
implements UI {
    private RelatorSequencer sequencer;
    private JFileChooser fileChooser;
    RelatorModel model;
    HashMap<Node, RGuiNode> map = new HashMap();
    private JTree actionTree;
    private JTextField tfLocator;
    private JToggleButton btnPause;
    private JToggleButton btnPlay;
    private JToggleButton btnStop;
    private ButtonGroup buttonGroup1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JPopupMenu.Separator jSeparator1;
    private JSplitPane jSplitPane1;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JMenuItem mniOpen;
    private JProgressBar progressBar;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private JPanel whiteboard;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;
    private JLabel lblSep;
    private JLabel lblTime;
    private JLabel lblTotal;
    private JMenu playMenu;
    private JMenu pauseModeMn;
    private JRadioButtonMenuItem noneModeMni;
    private JRadioButtonMenuItem leafModeMni;
    private JRadioButtonMenuItem slideModeMni;
    private JRadioButtonMenuItem explicitModeMni;
    private JSlider slider;
    private JMenuItem replayMni;
    private JMenuItem stopMni;
    private JMenuItem playMni;
    private final ButtonGroup pauseModeGroup = new ButtonGroup();
    private JMenu mnBrowse;
    private JMenuItem mntmLeft;
    private JMenuItem mntmRight;
    private JMenuItem mntmDown;
    private JMenuItem mntmUp;
    private JMenuItem mntmPageDown;
    private JMenuItem mntmPageUp;

    void initApp() {
        this.sequencer = new RelatorSequencer(this);
        this.fileChooser = new JFileChooser();
    }

    public RelatorView(SingleFrameApplication app) {
        super((Application)app);
        this.initComponents();
        if (this.actionTree.getCellRenderer() instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.actionTree.getCellRenderer();
            renderer.setBackgroundNonSelectionColor(Drawer.bg);
            this.actionTree.setBackground(Drawer.bg);
        }
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelatorView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        int i = 0;
        while (i < this.busyIcons.length) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
            ++i;
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelatorView.this.busyIconIndex = (RelatorView.this.busyIconIndex + 1) % RelatorView.this.busyIcons.length;
                RelatorView.this.statusAnimationLabel.setIcon(RelatorView.this.busyIcons[RelatorView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!RelatorView.this.busyIconTimer.isRunning()) {
                        RelatorView.this.statusAnimationLabel.setIcon(RelatorView.this.busyIcons[0]);
                        RelatorView.this.busyIconIndex = 0;
                        RelatorView.this.busyIconTimer.start();
                    }
                    RelatorView.this.progressBar.setVisible(true);
                    RelatorView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    RelatorView.this.busyIconTimer.stop();
                    RelatorView.this.statusAnimationLabel.setIcon(RelatorView.this.idleIcon);
                    RelatorView.this.progressBar.setVisible(false);
                    RelatorView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    RelatorView.this.statusMessageLabel.setText(text == null ? "" : text);
                    RelatorView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    RelatorView.this.progressBar.setVisible(true);
                    RelatorView.this.progressBar.setIndeterminate(false);
                    RelatorView.this.progressBar.setValue(value);
                }
            }
        });
        this.initApp();
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = RelatorApp.getApplication().getMainFrame();
            this.aboutBox = new RelatorAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        RelatorApp.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.actionTree = new JTree();
        this.actionTree.setShowsRootHandles(true);
        this.actionTree.setRootVisible(false);
        this.whiteboard = new JPanel();
        this.jPanel1 = new JPanel();
        this.btnStop = new JToggleButton();
        this.btnStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelatorView.this.sequencer.stop();
            }
        });
        this.btnPlay = new JToggleButton();
        this.btnPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RelatorView.this.sequencer.play(false);
            }
        });
        this.btnPause = new JToggleButton();
        this.btnPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelatorView.this.sequencer.pause();
            }
        });
        this.tfLocator = new JTextField();
        this.tfLocator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RelatorView.this.sequencer.findLabel(RelatorView.this.tfLocator.getText());
            }
        });
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.mniOpen = new JMenuItem();
        this.mniOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int status = RelatorView.this.fileChooser.showOpenDialog(RelatorView.this.mainPanel);
                if (status == 0) {
                    File file = RelatorView.this.fileChooser.getSelectedFile();
                    RelatorView.this.sequencer.open(file);
                } else {
                    System.out.println("Open command cancelled by user");
                }
            }
        });
        this.jSeparator1 = new JPopupMenu.Separator();
        JMenuItem mniExit = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.buttonGroup1 = new ButtonGroup();
        this.mainPanel.setName("mainPanel");
        this.mainPanel.setPreferredSize(new Dimension(640, 480));
        this.mainPanel.setLayout(new BorderLayout());
        this.jSplitPane1.setName("jSplitPane1");
        this.jSplitPane1.setMinimumSize(new Dimension(100, 100));
        this.jScrollPane1.setName("actionTree");
        this.jScrollPane1.setPreferredSize(new Dimension(200, Short.MAX_VALUE));
        this.actionTree.setName("actionTree");
        this.jScrollPane1.setViewportView(this.actionTree);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.whiteboard.setName("whiteboard");
        this.jSplitPane1.setRightComponent(this.whiteboard);
        this.whiteboard.setLayout(new BorderLayout(0, 0));
        this.slider = new JSlider();
        this.whiteboard.add((Component)this.slider, "South");
        this.mainPanel.add((Component)this.jSplitPane1, "Center");
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 2));
        this.buttonGroup1.add(this.btnStop);
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(RelatorView.class);
        this.btnStop.setText("Stop");
        this.btnStop.setName("btnStop");
        this.jPanel1.add(this.btnStop);
        this.buttonGroup1.add(this.btnPlay);
        this.btnPlay.setText("Play");
        this.btnPlay.setName("btnPlay");
        this.jPanel1.add(this.btnPlay);
        this.buttonGroup1.add(this.btnPause);
        this.btnPause.setText("Pause");
        this.btnPause.setName("btnPause");
        this.jPanel1.add(this.btnPause);
        this.lblTime = new JLabel("00:00");
        this.jPanel1.add(this.lblTime);
        this.lblSep = new JLabel("/");
        this.jPanel1.add(this.lblSep);
        this.lblTotal = new JLabel("00:00");
        this.jPanel1.add(this.lblTotal);
        this.tfLocator.setText(resourceMap.getString("btnLocator.text", new Object[0]));
        this.tfLocator.setName("tfLocator");
        this.jPanel1.add(this.tfLocator);
        this.mainPanel.add((Component)this.jPanel1, "South");
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        this.mniOpen.setText("Open");
        this.mniOpen.setName("mniOpen");
        fileMenu.add(this.mniOpen);
        this.jSeparator1.setName("jSeparator1");
        fileMenu.add(this.jSeparator1);
        ApplicationActionMap actionMap = Application.getInstance().getContext().getActionMap(RelatorView.class, (Object)this);
        mniExit.setAction(actionMap.get("quit"));
        mniExit.setText("Exit");
        mniExit.setName("mniExit");
        fileMenu.add(mniExit);
        this.menuBar.add(fileMenu);
        this.playMenu = new JMenu("Play");
        this.menuBar.add(this.playMenu);
        this.replayMni = new JMenuItem("Replay");
        this.replayMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelatorView.this.sequencer.replay();
            }
        });
        this.playMni = new JMenuItem("Play");
        this.playMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelatorView.this.sequencer.play(true);
            }
        });
        this.playMni.setAccelerator(KeyStroke.getKeyStroke(10, 0));
        this.playMenu.add(this.playMni);
        this.replayMni.setAccelerator(KeyStroke.getKeyStroke(8, 0));
        this.playMenu.add(this.replayMni);
        this.stopMni = new JMenuItem("Stop");
        this.stopMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelatorView.this.sequencer.stop();
            }
        });
        this.stopMni.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        this.playMenu.add(this.stopMni);
        this.pauseModeMn = new JMenu("Pause Mode");
        this.playMenu.add(this.pauseModeMn);
        this.noneModeMni = new JRadioButtonMenuItem("none");
        this.pauseModeGroup.add(this.noneModeMni);
        this.pauseModeMn.add(this.noneModeMni);
        this.explicitModeMni = new JRadioButtonMenuItem("explicit");
        this.pauseModeGroup.add(this.explicitModeMni);
        this.pauseModeMn.add(this.explicitModeMni);
        this.slideModeMni = new JRadioButtonMenuItem("slide");
        this.pauseModeGroup.add(this.slideModeMni);
        this.pauseModeMn.add(this.slideModeMni);
        this.leafModeMni = new JRadioButtonMenuItem("leaf");
        this.pauseModeGroup.add(this.leafModeMni);
        this.leafModeMni.setSelected(true);
        this.pauseModeMn.add(this.leafModeMni);
        this.mnBrowse = new JMenu("Browse");
        this.playMenu.add(this.mnBrowse);
        this.mntmLeft = new JMenuItem("left");
        this.mntmLeft.setAccelerator(KeyStroke.getKeyStroke(37, 0));
        this.mntmLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelatorView.this.sequencer.left();
            }
        });
        this.mnBrowse.add(this.mntmLeft);
        this.mntmRight = new JMenuItem("right");
        this.mntmRight.setAccelerator(KeyStroke.getKeyStroke(39, 0));
        this.mntmRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelatorView.this.sequencer.right();
            }
        });
        this.mnBrowse.add(this.mntmRight);
        this.mntmDown = new JMenuItem("down");
        this.mntmDown.setAccelerator(KeyStroke.getKeyStroke(40, 0));
        this.mntmDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelatorView.this.sequencer.move(1);
            }
        });
        this.mnBrowse.add(this.mntmDown);
        this.mntmUp = new JMenuItem("up");
        this.mntmUp.setAccelerator(KeyStroke.getKeyStroke(38, 0));
        this.mntmUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelatorView.this.sequencer.move(-1);
            }
        });
        this.mnBrowse.add(this.mntmUp);
        this.mntmPageDown = new JMenuItem("page down");
        this.mntmPageDown.setAccelerator(KeyStroke.getKeyStroke(34, 0));
        this.mntmPageDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelatorView.this.sequencer.pageDown();
            }
        });
        this.mnBrowse.add(this.mntmPageDown);
        this.mntmPageUp = new JMenuItem("page up");
        this.mntmPageUp.setAccelerator(KeyStroke.getKeyStroke(33, 0));
        this.mntmPageUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelatorView.this.sequencer.pageUp();
            }
        });
        this.mnBrowse.add(this.mntmPageUp);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("mniAbout");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout gl_statusPanel = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(gl_statusPanel);
        gl_statusPanel.setHorizontalGroup(gl_statusPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 454, Short.MAX_VALUE).addGroup(gl_statusPanel.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 284, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        gl_statusPanel.setVerticalGroup(gl_statusPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_statusPanel.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(gl_statusPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    @Override
    public JToggleButton getBtnStop() {
        return this.btnStop;
    }

    @Override
    public JToggleButton getBtnPlay() {
        return this.btnPlay;
    }

    @Override
    public JToggleButton getBtnPause() {
        return this.btnPause;
    }

    @Override
    public JLabel getStatusMessageLabel() {
        return this.statusMessageLabel;
    }

    @Override
    public JScrollPane getScrollPane() {
        return null;
    }

    @Override
    public JPanel getWhiteboard() {
        return this.whiteboard;
    }

    @Override
    public JTree getActionTree() {
        return this.actionTree;
    }

    @Override
    public JToggleButton getBtnAudioRec() {
        return null;
    }

    @Override
    public JToggleButton getBtnPenAudioRec() {
        return null;
    }

    @Override
    public JToggleButton getBtnPen() {
        return null;
    }

    @Override
    public JTextComponent getTextArea() {
        return this.tfLocator;
    }

    @Override
    public JLabel getLblTime() {
        return this.lblTime;
    }

    @Override
    public JLabel getLblTotal() {
        return this.lblTotal;
    }

    @Override
    public JSlider getSlider() {
        return this.slider;
    }

    @Override
    public void alert(String msg) {
        JOptionPane.showMessageDialog(null, msg, "Alert!", 0);
    }

    @Override
    public JCheckBoxMenuItem getDigitizer() {
        return null;
    }

    @Override
    public JMenu getEditMenu() {
        return null;
    }

    @Override
    public JComboBox getColorComboBox() {
        return null;
    }

    @Override
    public JComboBox getStrokeComboBox() {
        return null;
    }

    @Override
    public JButton getEraserBtn() {
        return null;
    }

    @Override
    public JCheckBoxMenuItem getMenuBarMni() {
        return null;
    }

    @Override
    public JMenu getColorMn() {
        return null;
    }

    @Override
    public JMenu getStrokeMn() {
        return null;
    }

    @Override
    public JCheckBoxMenuItem getHierarchyMni() {
        return null;
    }

    @Override
    public JCheckBoxMenuItem getStatusBarMni() {
        return null;
    }

    @Override
    public JRadioButtonMenuItem getNoneModeMni() {
        return this.noneModeMni;
    }

    @Override
    public JRadioButtonMenuItem getExplicitModeMni() {
        return this.explicitModeMni;
    }

    @Override
    public JRadioButtonMenuItem getSlideModeMni() {
        return this.slideModeMni;
    }

    @Override
    public JRadioButtonMenuItem getLeafModeMni() {
        return this.leafModeMni;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return null;
    }

    @Override
    public void drivePenFullArea(boolean flag) {
    }
}

