/*
 * Decompiled with CFR 0.152.
 */
package relator;

import edicurso.Log;
import edicurso.Player;
import edicurso.Sequencer;
import edicurso.Visitor;
import edicurso.operations.Composite;
import edicurso.operations.Node;
import edicurso.operations.Slide;
import java.util.HashMap;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import relator.RGuiNode;
import relator.RelatorModel;
import relator.RelatorView;

public class RelatorSequencer
extends Sequencer
implements ChangeListener {
    static final LabelVisitor labelVisitor = new LabelVisitor();
    final LabelFinder labelFinder = new LabelFinder();
    RelatorModel rmodel;
    boolean updateLocator = true;

    public RelatorSequencer(RelatorView ui) {
        try {
            this.init(ui);
            this.actionTree.getSelectionModel().setSelectionMode(1);
            this.rmodel = new RelatorModel(new HashMap<Node, RGuiNode>(), this.rootNode);
            this.actionTree.setModel(this.rmodel);
        }
        finally {
            this.epilog();
        }
    }

    @Override
    public boolean isRelator() {
        return true;
    }

    @Override
    public void prolog(boolean flag) {
        super.prolog(flag);
        this.updateLocator = true;
    }

    @Override
    protected void epilog() {
        if (this.rootNode != this.rmodel.getRootNode()) {
            this.rmodel.newRoot(this.rootNode);
        }
        if (this.current() == this.rootNode && this.rootNode.getChildCount() != 0) {
            this.setCurrent(this.rootNode.getChildAt(0));
        }
        Node node = this.current();
        RGuiNode peer = this.getVisiblePeer(node);
        if (this.prevNode != null && this.getVisiblePeer(this.prevNode) != peer || this.updateSelection) {
            if (this.updateLocator && this.state == this.stopState) {
                JTextComponent textArea = this.ui.getTextArea();
                textArea.setText(peer.getLocator());
            }
            TreePath path = new TreePath(peer.getPath());
            if (this.updateSelection) {
                this.actionTree.setSelectionPath(path);
            }
            this.actionTree.scrollPathToVisible(path);
        }
        if (this.oldState != this.state) {
            if (this.state != this.pauseState) {
                this.drawer.setPauseMark(false);
            }
            if (this.state == this.stopState) {
                this.ui.getBtnStop().setSelected(true);
            } else if (this.state == this.pauseState) {
                this.ui.getBtnPause().setSelected(true);
            } else if (this.state == this.playState) {
                this.ui.getBtnPlay().setSelected(true);
            }
        }
        if (this.needsRepaintFlag) {
            this.repaint();
            this.updateCurrentTime(this.timeManager.getRealTime(this.current()));
        }
        if (this.needsRedrawFlag) {
            this.drawer.redraw();
        }
        this.insideTransaction = false;
    }

    @Override
    public void playEpilog(Node finalNode) {
        try {
            this.prolog();
            this.stopImpl();
            Node visibleNode = this.getVisiblePeer(finalNode).getNode();
            this.setCurrent(visibleNode);
            this.playerSelect(visibleNode);
            this.needsRepaint();
        }
        finally {
            this.epilog();
        }
    }

    @Override
    public void setFrameTitle() {
        this.ui.getFrame().setTitle(this.rootNode.getName().equals("root") ? "Relator" : this.rootNode.getName());
    }

    @Override
    public boolean isExpanded(Node node) {
        RGuiNode peer = this.getVisiblePeer(node);
        TreePath path = new TreePath(peer.getPath());
        return this.actionTree.isExpanded(path);
    }

    public RGuiNode getVisiblePeer(Node node) {
        labelVisitor.reverseTraversalFrom(node);
        return this.rmodel.getPeer(RelatorSequencer.labelVisitor.found);
    }

    @Override
    public Node getLeadNode() {
        RGuiNode peer = this.getVisiblePeer(this.current());
        return peer.getNode();
    }

    @Override
    public void repaint(Node node) {
        RGuiNode peer = this.rmodel.getPeer(node);
        if (!this.isPlaying() && peer != null) {
            TreePath path = new TreePath(peer.getPath());
            node = this.actionTree.isExpanded(path) ? labelVisitor.getLastNodeOfLabel(node) : labelVisitor.getLastNodeAfterLabel(node);
        }
        this.clear();
        Node ghostNode = node;
        if (!this.isPlaying()) {
            ghostNode = this.getGhostNode(node);
        }
        this.rootNode.seek(ghostNode, this.drawer);
        this.drawer.setDrawNode(node);
    }

    @Override
    public void playerSelect(Node node) {
        this.setCurrent(node);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.tryProlog()) {
            try {
                if (!this.isPlaying()) {
                    this.updateImpl();
                } else {
                    boolean wasPlaying = this.state == this.playState;
                    Player player = this.drawer.getPlayer();
                    if (player != null) {
                        this.stopImpl();
                        this.setState(this.pauseState);
                    }
                    this.select(((RGuiNode)e.getPath().getLastPathComponent()).getNode());
                    if (!wasPlaying) {
                        this.resetTimer(500);
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                RelatorSequencer.this.play(false);
                            }
                        });
                    }
                }
            }
            finally {
                this.epilog();
            }
        }
    }

    @Override
    public Node getLastPathComponent(TreePath path) {
        return path == null ? null : ((RGuiNode)path.getLastPathComponent()).getNode();
    }

    @Override
    public TreePath getPath(Node node) {
        return new TreePath(this.getVisiblePeer(node).getPath());
    }

    @Override
    public int getChildCount(TreePath path) {
        return ((RGuiNode)path.getLastPathComponent()).getChildCount();
    }

    @Override
    public void updateImpl() {
        TreePath path;
        if (this.actionTree.getSelectionPath() != null && (path = this.actionTree.getPathForRow(this.actionTree.getMaxSelectionRow())) != null) {
            Node node = ((RGuiNode)path.getLastPathComponent()).getNode();
            this.select(node);
            this.updateSelection = false;
        }
        this.needsRepaint();
    }

    @Override
    public void makeLabelVisible(Node node) {
        RGuiNode peer = this.getVisiblePeer(node);
        TreePath peerPath = new TreePath(peer.getPath());
        this.actionTree.scrollPathToVisible(peerPath);
        this.actionTree.expandPath(peerPath);
    }

    @Override
    public void sliderSelect(JSlider source, Node target) {
        RGuiNode peer = this.getVisiblePeer(target);
        Node node = peer.getNode();
        super.sliderSelect(source, node);
    }

    public void findLabel(String text) {
        try {
            this.prolog();
            this.labelFinder.text = text.toLowerCase();
            this.labelFinder.found = null;
            this.labelFinder.target = null;
            this.labelFinder.traverseAfter(this.current());
            if (this.labelFinder.found != null) {
                this.select(this.labelFinder.found);
            } else {
                this.labelFinder.target = this.current();
                this.labelFinder.traverseFrom(this.rootNode);
                if (this.labelFinder.found != null) {
                    this.select(this.labelFinder.found);
                } else {
                    RelatorSequencer.beep();
                }
            }
            this.updateLocator = false;
        }
        finally {
            this.epilog();
        }
    }

    class LabelFinder
    extends Visitor {
        Node found;
        String text;
        Node target;

        LabelFinder() {
        }

        @Override
        public void visit(Node node) throws Visitor.StopException {
            RGuiNode rnode = RelatorSequencer.this.rmodel.getPeer(node);
            if (rnode != null) {
                String locator = rnode.getLocator().toLowerCase();
                Composite comp = (Composite)node;
                if (locator.equals(this.text) || comp.getName().toLowerCase().contains(this.text)) {
                    this.found = comp;
                    this.stop();
                }
            }
            if (node == this.target) {
                this.stop();
            }
        }
    }

    static class LabelVisitor
    extends Visitor {
        Node found;

        LabelVisitor() {
        }

        public Node getLastNodeOfLabel(Node node) {
            this.found = node;
            this.traverseAfter(node);
            return this.found;
        }

        public Node getLastNodeAfterLabel(Node node) {
            try {
                Composite parent;
                this.found = node.getLastVisibleLeaf();
                if (!(node instanceof Slide) && (parent = node.getParent()) != null) {
                    parent.traverseChildrenAfter(this, node);
                }
            }
            catch (Visitor.StopException parent) {
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.error(e.getMessage());
            }
            return this.found;
        }

        @Override
        public void reverseVisit(Node node) throws Exception {
            if (node.isLabel()) {
                this.found = node;
                this.stop();
            }
        }

        @Override
        public void visit(Node node) throws Visitor.StopException {
            if (node.isLabel()) {
                this.stop();
            }
            this.found = node;
        }

        @Override
        public void walkComposite(Composite comp) throws Exception {
            if (!(comp instanceof Slide) || comp.isLabel()) {
                super.walkComposite(comp);
            }
        }

        @Override
        public void postVisit(Composite comp) throws Visitor.StopException {
            if (comp instanceof Slide) {
                this.stop();
            }
        }
    }
}

