/*
 * Decompiled with CFR 0.152.
 */
package relator;

import edicurso.Visitor;
import edicurso.operations.Composite;
import edicurso.operations.Node;
import edicurso.operations.Slide;
import java.util.HashMap;
import javax.swing.tree.DefaultMutableTreeNode;

public class RGuiNode
extends DefaultMutableTreeNode {
    static RelatorTreeBuilder relatorTreeBuilder = new RelatorTreeBuilder();
    String locator;
    private static final long serialVersionUID = 1L;

    RGuiNode(HashMap<Node, RGuiNode> map, Composite rootNode) {
        relatorTreeBuilder.build(rootNode, this, map);
    }

    RGuiNode(Composite comp, String locator) {
        this.userObject = comp;
        this.locator = locator;
    }

    public String getLocator() {
        return this.locator;
    }

    public Node getNode() {
        return (Node)this.userObject;
    }

    @Override
    public String toString() {
        Composite comp = (Composite)this.getUserObject();
        if (!(comp instanceof Slide)) {
            return comp.getName();
        }
        Composite parent = comp.getParent();
        if (parent == null) {
            return "";
        }
        if (parent.getParent() == null) {
            return comp.getName();
        }
        return "(" + comp.getName() + ")";
    }

    static class RelatorTreeBuilder
    extends Visitor {
        RGuiNode currRNode;
        HashMap<Node, RGuiNode> map;

        RelatorTreeBuilder() {
        }

        void build(Composite rootNode, RGuiNode peerRootNode, HashMap<Node, RGuiNode> map) {
            this.map = map;
            peerRootNode.setUserObject(rootNode);
            peerRootNode.locator = "";
            map.put(rootNode, peerRootNode);
            this.currRNode = peerRootNode;
            int size = rootNode.getChildCount();
            int i = 0;
            while (i < size) {
                Node child = rootNode.getChildAt(i);
                this.walkTree(child);
                ++i;
            }
        }

        @Override
        public void walkComposite(Composite comp) throws Exception {
            if (!comp.isLabel()) {
                super.walkComposite(comp);
            } else {
                RGuiNode saveRNode = this.currRNode;
                String parentLocator = this.currRNode.getLocator();
                String locatorPrefix = parentLocator.length() == 0 ? "" : String.valueOf(parentLocator) + "/";
                this.currRNode = new RGuiNode(comp, String.valueOf(locatorPrefix) + comp.getName());
                saveRNode.add(this.currRNode);
                this.map.put(comp, this.currRNode);
                super.walkComposite(comp);
                this.currRNode = saveRNode;
            }
        }
    }
}

