/*
 * Decompiled with CFR 0.152.
 */
package edicurso.operations;

import edicurso.Drawer;
import edicurso.Log;
import edicurso.Player;
import edicurso.Sequencer;
import edicurso.Task;
import edicurso.Visitor;
import edicurso.operations.Node;
import edicurso.operations.RootNode;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;

public class ShowImage
extends Node {
    static final int SHOWDELAY = 960;
    int delay0;
    int x;
    int y;
    int size;
    String fileName;
    transient BufferedImage img;
    transient byte[] buf;
    transient String name = null;
    transient Rectangle2D.Float box = new Rectangle2D.Float();
    transient AlphaComposite ac;

    public ShowImage() {
    }

    public ShowImage(int delay0, String fileName, byte[] buf, BufferedImage img) {
        this.x = 0;
        this.y = 0;
        this.size = buf.length;
        this.img = img;
        this.fileName = fileName;
        this.buf = buf;
        this.delay0 = delay0;
        this.box.setRect(this.x, this.y, img.getWidth() - 1, img.getHeight() - 1);
    }

    public ShowImage(ShowImage node) {
        this.x = node.x;
        this.y = node.y;
        this.size = node.size;
        this.img = node.img;
        this.fileName = node.fileName;
        this.box = new Rectangle2D.Float();
        this.box.setRect(node.box);
        this.buf = node.buf;
        this.delay0 = node.delay0;
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int lsize) {
        this.size = lsize;
    }

    public final int getX() {
        return this.x;
    }

    public final void setX(int lx) {
        this.x = (short)lx;
    }

    public final int getY() {
        return this.y;
    }

    public final void setY(int ly) {
        this.y = (short)ly;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String lfileName) {
        this.fileName = lfileName;
    }

    public int getDelay0() {
        return this.delay0 + 960;
    }

    public void setDelay0(int ldelay) {
        this.delay0 = (short)ldelay;
    }

    public Rectangle2D.Float getBox() {
        return this.box;
    }

    @Override
    public int getDelay() {
        return this.delay0 + 960;
    }

    public String toString() {
        if (this.name == null) {
            this.name = "image " + this.fileName;
        }
        return this.name;
    }

    @Override
    public Node copyNode() {
        return new ShowImage(this);
    }

    @Override
    public void draw(Graphics2D g2d, Drawer drawer) {
        if (drawer.requires(this.box)) {
            ++drawer.cnt;
            if (this.ac != null) {
                g2d.setComposite(this.ac);
            }
            g2d.drawImage((Image)this.img, this.x, this.y, null);
        }
    }

    @Override
    public void exec(Drawer drawer) {
        drawer.touch(this.box);
        drawer.setDrawNode(this);
    }

    @Override
    public void play(Player player) {
        Drawer drawer = player.getDrawer();
        System.out.println("playing image at " + this.x + " " + this.y + " node time: " + drawer.getSequencer().getTimeManager().getRealTime(this) + " play time: " + player.getElapsedTime());
        this.exec(drawer);
        int t = 0;
        while (t < 960) {
            this.ac = AlphaComposite.getInstance(3, (float)t / 1000.0f);
            drawer.touch(this.box);
            Task.sleep(60);
            t += 60;
        }
        this.ac = null;
        super.play(player);
    }

    @Override
    public boolean hit(Graphics2D g2d, Rectangle rect) {
        return this.box.intersects(rect);
    }

    @Override
    public void move(int dx, int dy, Sequencer seq) {
        Drawer drawer = seq.getDrawer();
        drawer.touch(this.box);
        this.x += dx;
        this.y += dy;
        this.box.setRect(this.x, this.y, this.img.getWidth(), this.img.getHeight());
        drawer.touch(this.box);
        seq.needsRedraw();
    }

    @Override
    public void postSave(Visitor visArg) throws Exception {
        RootNode.PostSave vis = (RootNode.PostSave)visArg;
        ZipOutputStream zipStream = vis.getZipStream();
        ZipEntry entry = new ZipEntry(String.valueOf(vis.getSerial()) + ".img");
        entry.setMethod(0);
        CRC32 crc = new CRC32();
        crc.update(this.buf);
        entry.setSize(this.buf.length);
        entry.setCrc(crc.getValue());
        zipStream.putNextEntry(entry);
        zipStream.write(this.buf, 0, this.buf.length);
        System.out.println("wrote " + this.buf.length + " bytes in " + entry.getName());
        zipStream.closeEntry();
    }

    @Override
    public void postOpen(Visitor visArg) throws IOException {
        int rc;
        RootNode.PostOpen vis = (RootNode.PostOpen)visArg;
        ZipInputStream zipStream = vis.getZipStream();
        ZipEntry entry = zipStream.getNextEntry();
        assert (entry != null);
        this.buf = new byte[this.size];
        int cnt = 0;
        do {
            rc = zipStream.read(this.buf, cnt, this.buf.length - cnt);
            assert (rc > 0);
        } while ((cnt += rc) < this.buf.length);
        System.out.println("read image of " + cnt + " bytes");
        ByteArrayInputStream bufStream = new ByteArrayInputStream(this.buf);
        this.img = ImageIO.read(bufStream);
        this.box.setRect(this.x, this.y, this.img.getWidth(), this.img.getHeight());
        zipStream.closeEntry();
    }

    public static void image(int delay, File file, Sequencer seq) {
        int size = (int)file.length();
        byte[] buf = new byte[size];
        try {
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
            int cnt = 0;
            while ((cnt = stream.read(buf, cnt, size - cnt)) > 0) {
            }
            stream.close();
            assert (size == cnt);
            ByteArrayInputStream bufStream = new ByteArrayInputStream(buf);
            BufferedImage img = ImageIO.read(bufStream);
            if (img == null) {
                Log.error("Could not decode image format of " + file.getName());
            } else {
                ShowImage node = new ShowImage(delay, file.getName(), buf, img);
                seq.addNode(node);
                ((Node)node).exec(seq.getDrawer());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

