/*
 * Decompiled with CFR 0.152.
 */
package edicurso.operations;

import edicurso.ColorBoxRenderer;
import edicurso.Drawer;
import edicurso.operations.NamedNode;
import edicurso.operations.Node;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;

public class SetColor
extends NamedNode {
    static final String tag = "color";
    Color color = null;

    public SetColor() {
    }

    public SetColor(String name, Color color) {
        this.color = color;
        this.setName(name);
    }

    @Override
    public String tag() {
        return tag;
    }

    public final Color getColor() {
        return this.color;
    }

    public final void setColor(Color color) {
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        Color uiColor = ColorBoxRenderer.getColor(this.name);
        this.color = uiColor == null ? this.color : uiColor;
    }

    @Override
    public void exec(Drawer drawer) {
        drawer.setColor(this.color);
        drawer.setStroke(drawer.getRealStroke());
        drawer.setDrawNode(this);
    }

    @Override
    public void draw(Graphics2D g2d, Drawer drawer) {
        drawer.setColor(this.color);
        g2d.setPaint(this.color);
        BasicStroke stroke = drawer.getRealStroke();
        drawer.setStroke(stroke);
        g2d.setStroke(stroke);
    }

    @Override
    public Node copyNode() {
        return new SetColor(this.name, this.color);
    }
}

