/*
 * Decompiled with CFR 0.152.
 */
package edicurso.operations;

import edicurso.Drawer;
import edicurso.Sequencer;
import edicurso.Visitor;
import edicurso.operations.AudioClip;
import edicurso.operations.Composite;
import edicurso.operations.GuiNode;
import edicurso.operations.Node;
import edicurso.operations.NodeFactory;
import edicurso.operations.RootNode2;
import edicurso.operations.SetColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JScrollPane;

public class RootNode
extends Composite {
    static final String tag = "root";
    public int width;
    public int height;
    public int grid;
    static final int gridVal = 192;
    static final Color gridColor;
    static final Color borderColor;
    static final BasicStroke STROKE1;

    static {
        borderColor = gridColor = new Color(192, 192, 192);
        STROKE1 = new BasicStroke(1.0f);
    }

    public RootNode() {
        super(tag);
        this.width = -1;
        this.height = -1;
        this.grid = 0;
    }

    public RootNode(RootNode rootNode, NodeFactory factory) {
        super(rootNode, factory);
        this.width = rootNode.width;
        this.height = rootNode.height;
        this.grid = rootNode.grid;
    }

    @Override
    public String tag() {
        return tag;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int heigth) {
        this.height = heigth;
    }

    public int getGrid() {
        return this.grid;
    }

    public void setGrid(int grid) {
        this.grid = grid;
    }

    @Override
    public boolean isLabel() {
        return true;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public Node copyNode(NodeFactory factory) {
        return new RootNode(this, factory);
    }

    @Override
    public void draw(Graphics2D g2d, Drawer drawer) {
        if (this.width <= 0 || this.height <= 0) {
            JScrollPane scrollPane = drawer.getSequencer().getUi().getScrollPane();
            if (scrollPane == null) {
                this.width = drawer.getWidth();
                this.height = drawer.getHeight();
            } else {
                Rectangle rect = scrollPane.getViewportBorderBounds();
                this.width = rect.width;
                this.height = rect.height;
                drawer.computeArea();
            }
        }
        if (drawer.getPlayer() != null && this.width != 0 && this.height != 0) {
            Rectangle clipRect = new Rectangle(0, 0, this.width - 1, this.height - 1);
            g2d.clip(clipRect);
        }
        double zoom = drawer.getZoom();
        g2d.scale(zoom, zoom);
        Color currColor = g2d.getColor();
        Stroke currStroke = g2d.getStroke();
        g2d.setPaint(gridColor);
        g2d.setStroke(STROKE1);
        if (this.grid > 0) {
            int x = this.grid;
            while (x < this.width) {
                g2d.drawLine(x, 0, x, this.height - 1);
                x += this.grid;
            }
            int y = this.grid;
            while (y < this.height) {
                g2d.drawLine(0, y, this.width - 1, y);
                y += this.grid;
            }
        }
        g2d.drawLine(0, 0, this.width - 1, 0);
        g2d.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
        g2d.drawLine(this.width - 1, this.height - 1, 0, this.height - 1);
        g2d.drawLine(0, this.height - 1, 0, 0);
        g2d.setPaint(currColor);
        g2d.setStroke(currStroke);
    }

    public void save(FileOutputStream out, Sequencer seq) throws Exception {
        GuiNode rootPeer = this.getPeer();
        RootNode2 rootNode2 = new RootNode2();
        rootNode2.setPeerTransient(rootPeer);
        rootNode2.setGrid(this.getGrid());
        rootNode2.setWidth(this.getWidth());
        rootNode2.setHeight(this.getHeight());
        rootNode2.setName(this.getName());
        rootPeer.setNode(rootNode2);
        rootNode2.save(out, seq);
    }

    public void open(File file, ZipInputStream zipStream, Sequencer seq) throws Exception {
        ZipInputStream postZipStream = zipStream;
        postZipStream.getNextEntry();
        AudioClip.resetTotal();
        this.traverseTree(new PostOpen(postZipStream));
        System.out.println("File size: " + file.length());
        System.out.println("Audio size: " + AudioClip.getTotal());
        System.out.println("Audio duration: " + AudioClip.getTotalTime() / 1000);
    }

    public static class PostOpen
    extends Visitor {
        protected ZipInputStream in;

        public PostOpen(ZipInputStream zipStream) {
            this.in = zipStream;
        }

        public ZipInputStream getZipStream() {
            return this.in;
        }

        public void checkMark(int v) throws IOException {
        }

        public int readInt() throws IOException {
            int b1 = this.in.read();
            int b2 = this.in.read();
            int b3 = this.in.read();
            int b4 = this.in.read();
            int v = b1 + (b2 << 8) + (b3 << 16) + (b4 << 24);
            return v;
        }

        public short readShort() throws IOException {
            int b1 = this.in.read();
            int b2 = this.in.read();
            short v = (short)(b1 + (b2 << 8));
            return v;
        }

        public short[] readShortArray(int size) throws IOException {
            short[] vals = new short[size];
            int idx = 0;
            while (idx < size) {
                vals[idx] = this.readShort();
                ++idx;
            }
            return vals;
        }

        @Override
        public void visit(Node node) throws Exception {
            SetColor color;
            node.postOpen(this);
            if (node instanceof SetColor && (color = (SetColor)node).getName().equals("white")) {
                color.setName("background");
            }
        }
    }

    public static class PostSave
    extends Visitor {
        ZipOutputStream out;
        int serial = 0;

        public PostSave(ZipOutputStream zipStream) {
            this.out = zipStream;
        }

        public int version() {
            return 1;
        }

        public ZipOutputStream getZipStream() {
            return this.out;
        }

        public int getSerial() {
            return this.serial++;
        }

        public void writeMark(int v) throws IOException {
        }

        public void writeInt(int v) throws IOException {
            this.out.write((byte)v);
            this.out.write((byte)(v >> 8));
            this.out.write((byte)(v >> 16));
            this.out.write((byte)(v >> 24));
        }

        public void writeShort(int v) throws IOException {
            this.out.write((byte)v);
            this.out.write((byte)(v >> 8));
        }

        public void writeShortArray(short[] vals, int size) throws IOException {
            int idx = 0;
            while (idx < size) {
                this.writeShort(vals[idx]);
                ++idx;
            }
        }

        @Override
        public void visit(Node node) throws Exception {
            node.postSave(this);
        }
    }

    public static class PreSave
    extends Visitor {
        @Override
        public void visit(Node node) throws Exception {
            node.preSave(this);
        }
    }
}

