/*
 * Decompiled with CFR 0.152.
 */
package edicurso.operations;

import edicurso.Player;
import edicurso.Scheduler;
import edicurso.operations.Composite;
import edicurso.operations.Node;
import edicurso.operations.NodeFactory;
import javax.swing.tree.TreeNode;

public class PenPlusAudio
extends Composite {
    static final String tag = "pen+audio";

    public PenPlusAudio() {
    }

    public PenPlusAudio(String name) {
        super(tag);
    }

    public PenPlusAudio(Composite composite, NodeFactory factory) {
        super(composite, factory);
    }

    @Override
    public String tag() {
        return "pen+a";
    }

    @Override
    public boolean isLabel() {
        return !tag.equals(this.name);
    }

    @Override
    public void play(Player player) {
        Scheduler sched = Scheduler.getScheduler();
        double oldMin = sched.setMinZoom(1.0);
        double oldMax = sched.setMaxZoom(1.0);
        try {
            super.play(player);
        }
        finally {
            sched.setMinZoom(oldMin);
            sched.setMaxZoom(oldMax);
        }
    }

    @Override
    public void play(TreeNode[] branch, int k, Player player) {
        Scheduler sched = Scheduler.getScheduler();
        double oldMin = sched.setMinZoom(1.0);
        double oldMax = sched.setMaxZoom(1.0);
        try {
            super.play(branch, k, player);
        }
        finally {
            sched.setMinZoom(oldMin);
            sched.setMaxZoom(oldMax);
        }
    }

    @Override
    public Node copyNode(NodeFactory factory) {
        return new PenPlusAudio(this, factory);
    }
}

