/*
 * Decompiled with CFR 0.152.
 */
package edicurso.operations;

import edicurso.Player;
import edicurso.Scheduler;
import edicurso.Task;
import edicurso.operations.Node;

public class Pause
extends Node {
    transient String name;
    public int delay;

    public Pause() {
    }

    public Pause(int delay) {
        this.delay = (int)((double)delay / Scheduler.DEFAULT_ZOOM + 0.5);
    }

    public Pause(Pause pause) {
        this.delay = pause.delay;
    }

    public String toString() {
        int realDelay = (int)((double)this.delay * Scheduler.DEFAULT_ZOOM + 0.5);
        if (this.name == null) {
            this.name = realDelay % 1000 == 0 ? "pause " + realDelay / 1000 + " seconds" : "pause " + realDelay + " milliseconds";
        }
        return this.name;
    }

    @Override
    public int getDelay() {
        return this.delay;
    }

    @Override
    public void setDelay(int delay) {
        this.delay = delay;
    }

    @Override
    public void play(Player player) {
        player.setCurrentNode(this);
        this.select(player);
        Task.sleep(this.delay);
    }

    @Override
    public Node copyNode() {
        return new Pause(this);
    }
}

