/*
 * Decompiled with CFR 0.152.
 */
package edicurso.operations;

import edicurso.Drawer;
import edicurso.Player;
import edicurso.Sequencer;
import edicurso.TimeManager;
import edicurso.Visitor;
import edicurso.operations.Composite;
import edicurso.operations.GuiNode;
import edicurso.operations.NodeFactory;
import edicurso.operations.RootNode;
import edicurso.operations.Slide;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class Node {
    transient GuiNode peer;

    public GuiNode getPeer() {
        if (this.peer == null) {
            this.peer = new GuiNode(this);
        }
        return this.peer;
    }

    public void setPeerTransient(GuiNode peer) {
        this.peer = peer;
    }

    public int getDelay() {
        return 0;
    }

    public int getPostDelay() {
        return 0;
    }

    public void setDelay(int delay) {
    }

    public void setName(String name) {
    }

    public boolean isEditable() {
        return false;
    }

    public boolean isLabel() {
        return false;
    }

    public void showInfo(TimeManager timeManager) {
    }

    public void exec(Drawer drawer) {
        drawer.setDrawNode(this);
    }

    public void draw(Graphics2D g2d, Drawer drawer) {
    }

    public int getDelayTo(Node node) {
        Node curr = this;
        int delay = 0;
        while (curr != node) {
            if ((curr = curr.getNextNode()) == null) break;
            delay += curr.getDelay();
        }
        return delay;
    }

    public int getTotalDelay() {
        int total = this.getDelay();
        int count = this.getChildCount();
        int i = 0;
        while (i < count) {
            total += this.getChildAt(i).getTotalDelay();
            ++i;
        }
        return total;
    }

    public Node copyNode() {
        assert (false);
        return null;
    }

    public Node copyNode(NodeFactory factory) {
        return this.copyNode();
    }

    public void newCurrent(Node node, Sequencer sequencer) {
    }

    public final void repaint(Player player) {
        Drawer drawer = player.getDrawer();
        drawer.clear();
        RootNode rootNode = player.getSequencer().getRootNode();
        ((Node)rootNode).seek(this, drawer);
    }

    public boolean seek(Node node, Drawer drawer) {
        this.exec(drawer);
        if (node == this) {
            return true;
        }
        int count = this.getChildCount();
        int i = 0;
        while (i < count) {
            if (this.getChildAt(i).seek(node, drawer)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void play(Player player) {
        Drawer drawer = player.getDrawer();
        this.select(player);
        this.exec(drawer);
        int count = this.getChildCount();
        int idx = 0;
        while (idx < count) {
            Node child = this.getChildAt(idx);
            child.play(player);
            ++idx;
        }
    }

    public void select(Player player) {
        player.setCurrentNode(this);
        player.getSequencer().playerSelect(this);
    }

    public void play(TreeNode[] branch, int k, Player player) {
        int firstIdx;
        Node node = Node.getNode(branch, k);
        assert (node == this);
        if (k + 1 >= branch.length) {
            firstIdx = 0;
            this.select(player);
        } else {
            Node child = Node.getNode(branch, k + 1);
            child.play(branch, k + 1, player);
            firstIdx = this.getIndex(child) + 1;
        }
        int count = this.getChildCount();
        int i = firstIdx;
        while (i < count) {
            Node child = this.getChildAt(i);
            child.play(player);
            ++i;
        }
    }

    public Composite getParent() {
        if (this.peer == null) {
            return null;
        }
        GuiNode guiParent = (GuiNode)this.peer.getParent();
        return guiParent == null ? null : (Composite)guiParent.getNode();
    }

    public int getChildCount() {
        return this.getPeer().getChildCount();
    }

    public Node getChildAt(int i) {
        return ((GuiNode)this.peer.getChildAt(i)).getNode();
    }

    public int getIndex(Node child) {
        return this.peer.getIndex(child.peer);
    }

    public void add(Node child) {
        this.getPeer().add(child.getPeer());
    }

    public boolean isNodeDescendant(Node node) {
        return this.peer.isNodeDescendant(node.peer);
    }

    public boolean hasLeavesOnly() {
        int count = this.getChildCount();
        int i = 0;
        while (i < count) {
            if (this.getChildAt(i) instanceof Composite) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Node getRoot() {
        return ((GuiNode)this.peer.getRoot()).getNode();
    }

    public Node getNextNode() {
        GuiNode next = (GuiNode)this.peer.getNextNode();
        return next == null ? null : next.getNode();
    }

    public Node getPrevNode() {
        GuiNode prev = (GuiNode)this.peer.getPreviousNode();
        return prev == null ? null : prev.getNode();
    }

    public Slide getOuterSlide() {
        Node slide = null;
        GuiNode peer = this.getPeer();
        do {
            Node node;
            if (!((node = peer.getNode()) instanceof Slide)) continue;
            slide = node;
        } while ((peer = (GuiNode)peer.getParent()) != null);
        return (Slide)slide;
    }

    public Node getNextSibling() {
        DefaultMutableTreeNode peerSibling = this.getPeer().getNextSibling();
        return peerSibling == null ? null : ((GuiNode)peerSibling).getNode();
    }

    public TreeNode[] getBranch() {
        return this.peer.getPath();
    }

    public TreePath getPath() {
        return new TreePath(this.peer.getPath());
    }

    public Node getLastLeaf() {
        return ((GuiNode)this.peer.getLastLeaf()).getNode();
    }

    public Node getLastVisibleLeaf() {
        return this;
    }

    public static Node getNode(TreeNode[] branch, int k) {
        return ((GuiNode)branch[k]).getNode();
    }

    public static Node getLastPathComponent(TreePath path) {
        return ((GuiNode)path.getLastPathComponent()).getNode();
    }

    public Node getNextVisibleNode(JTree jtree) {
        GuiNode child;
        TreePath path;
        GuiNode peer = this.peer;
        if (!peer.isLeaf() && jtree.isExpanded(path = new TreePath(child = (GuiNode)peer.getFirstChild()))) {
            return child.getNode();
        }
        GuiNode parentPeer = (GuiNode)peer.getParent();
        while (parentPeer != null) {
            GuiNode nextPeer = (GuiNode)parentPeer.getChildAfter(peer);
            if (nextPeer != null) {
                return nextPeer.getNode();
            }
            peer = parentPeer;
            parentPeer = (GuiNode)peer.getParent();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Node getPreviousVisibleNode(JTree jtree) {
        parentPeer = (GuiNode)this.peer.getParent();
        prevPeer = (GuiNode)parentPeer.getChildBefore(this.peer);
        if (prevPeer != null) ** GOTO lbl9
        return parentPeer.getNode();
lbl-1000:
        // 1 sources

        {
            lastChild = (GuiNode)prevPeer.getLastChild();
            if (!jtree.isExpanded(new TreePath(lastChild))) {
                return prevPeer.getNode();
            }
            prevPeer = lastChild;
lbl9:
            // 2 sources

            ** while (!prevPeer.isLeaf())
        }
lbl10:
        // 1 sources

        return prevPeer.getNode();
    }

    public boolean hit(Graphics2D g2d, Rectangle rect) {
        return false;
    }

    public void move(int dx, int dy, Sequencer seq) {
    }

    public void preSave(Visitor vis) throws Exception {
    }

    public void postSave(Visitor vis) throws Exception {
    }

    public void postOpen(Visitor vis) throws Exception {
    }

    public void postSave2(Visitor vis) throws Exception {
    }

    public void postOpen2(Visitor vis) throws Exception {
    }

    public void traverseTree(Visitor visitor) throws Exception {
        visitor.visit(this);
    }

    public void traverseFrom(Visitor visitor) throws Exception {
        visitor.visit(this);
        this.traverseAfter(visitor);
    }

    public void traverseAfter(Visitor visitor) throws Exception {
        Composite parent = this.getParent();
        Node child = this;
        while (parent != null) {
            parent.traverseChildrenAfter(visitor, child);
            visitor.postVisit(parent);
            child = parent;
            parent = parent.getParent();
        }
    }

    public void reverseTraversal(Visitor visitor) throws Exception {
        visitor.reverseVisit(this);
    }

    public void reverseTraversalFrom(Visitor visitor) throws Exception {
        visitor.reverseVisit(this);
        this.reverseTraversalBefore(visitor);
    }

    public void reverseTraversalBefore(Visitor visitor) throws Exception {
        Node child = this;
        Composite parent = child.getParent();
        while (parent != null) {
            parent.reverseTraversalChildrenBefore(visitor, child);
            visitor.reverseVisit(parent);
            child = parent;
            parent = parent.getParent();
        }
    }

    public void walkTree(Visitor visitor) throws Exception {
        visitor.walk(this);
    }

    public static class VirtualDelayVisitor
    extends Visitor {
        int delay;
        Node endNode;

        @Override
        public void visit(Node node) throws Exception {
            if (node == this.endNode) {
                this.stop();
            }
            this.delay += node.getDelay();
        }

        @Override
        public void postVisit(Composite comp) {
            this.delay += comp.getPostDelay();
        }

        public int getVirtualDelay(Node from, Node to) {
            this.delay = 0;
            this.endNode = to;
            this.traverseFrom(from);
            return this.delay;
        }
    }
}

