/*
 * Decompiled with CFR 0.152.
 */
package edicurso;

import edicurso.AudioManager;
import edicurso.Log;
import edicurso.Sequencer;
import edicurso.operations.AudioClip;
import edicurso.operations.Composite;
import edicurso.operations.GuiNode;
import edicurso.operations.Node;
import java.util.HashSet;
import java.util.Set;

public abstract class Visitor {
    public void visit(Node node) throws Exception {
    }

    public void postVisit(Composite comp) throws StopException {
    }

    public void traverseTree(Node node) {
        try {
            node.traverseTree(this);
        }
        catch (StopException stopException) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.error(e.getMessage());
        }
    }

    public void traverseFrom(Node node) {
        try {
            node.traverseFrom(this);
        }
        catch (StopException stopException) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.error(e.getMessage());
        }
    }

    public void traverseAfter(Node node) {
        try {
            node.traverseAfter(this);
        }
        catch (StopException stopException) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.error(e.getMessage());
        }
    }

    public void reverseVisit(Node node) throws Exception {
    }

    public void reversePostVisit(Composite comp) throws StopException {
    }

    public void reverseTraversal(Node node) {
        try {
            node.reverseTraversal(this);
        }
        catch (StopException stopException) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.error(e.getMessage());
        }
    }

    public void reverseTraversalFrom(Node node) {
        try {
            node.reverseTraversalFrom(this);
        }
        catch (StopException stopException) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.error(e.getMessage());
        }
    }

    public void reverseTraversalBefore(Node node) {
        try {
            node.reverseTraversalBefore(this);
        }
        catch (StopException stopException) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.error(e.getMessage());
        }
    }

    public void walkTree(Node node) {
        try {
            node.walkTree(this);
        }
        catch (StopException stopException) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.error(e.getMessage());
        }
    }

    public void walk(Node node) throws Exception {
    }

    public void walkComposite(Composite comp) throws Exception {
        GuiNode parentPeer = comp.getPeer();
        int count = parentPeer.getChildCount();
        int idx = 0;
        while (idx < count) {
            GuiNode afterPeer = (GuiNode)parentPeer.getChildAt(idx);
            afterPeer.getNode().walkTree(this);
            ++idx;
        }
    }

    public void stop() throws StopException {
        throw new StopException();
    }

    public static class Compressor
    extends Visitor {
        Sequencer seq;
        Set<AudioClip> coalesceClips = new HashSet<AudioClip>();
        AudioManager.Coalescer coalescer = new AudioManager.Coalescer();
        public boolean success = true;
        public int diffCnt = 0;
        public int diffSum = 0;

        public Compressor(Sequencer seq) {
            this.seq = seq;
        }

        public final Sequencer getSequencer() {
            return this.seq;
        }

        public final Set<AudioClip> getCoalesceClips() {
            return this.coalesceClips;
        }

        public final AudioManager.Coalescer getCoalescer() {
            return this.coalescer;
        }

        @Override
        public void visit(Node node) throws Exception {
            if (node instanceof AudioClip) {
                ((AudioClip)node).compress(this);
            }
        }
    }

    public static class StopException
    extends Exception {
    }
}

