/*
 * Decompiled with CFR 0.152.
 */
package edicurso;

import edicurso.Scheduler;
import edicurso.Sequencer;
import edicurso.Visitor;
import edicurso.operations.AudioNode;
import edicurso.operations.Composite;
import edicurso.operations.EndAudioClip;
import edicurso.operations.Node;
import edicurso.operations.PenPlusAudio;

public class TimeManager
extends Visitor {
    double currTime;
    double targetTime;
    double nextDelay;
    Sequencer seq;
    Node res;
    Node targetNode;
    double zoom;
    boolean insidePenAudioGroup;

    public TimeManager(Sequencer seq) {
        this.seq = seq;
    }

    final void init() {
        this.currTime = 0.0;
        this.nextDelay = 0.0;
        this.targetTime = 2.147483647E9;
        this.res = this.seq.getRootNode();
        this.targetNode = null;
        this.zoom = Scheduler.DEFAULT_ZOOM;
        this.insidePenAudioGroup = false;
    }

    @Override
    public void visit(Node node) throws Exception {
        double delta = 0.0;
        if (node instanceof AudioNode) {
            AudioNode audioNode = (AudioNode)node;
            if (this.nextDelay > 0.0) {
                if (this.currTime + this.nextDelay - this.targetTime > 1.1) {
                    this.stop();
                }
                this.currTime += this.nextDelay;
            }
            this.nextDelay = audioNode.getNextDelay();
            if (!this.insidePenAudioGroup) {
                this.zoom = node instanceof EndAudioClip ? Scheduler.DEFAULT_ZOOM : Math.min(audioNode.getZoom(), Scheduler.DEFAULT_ZOOM);
            }
        } else if (node instanceof PenPlusAudio) {
            this.insidePenAudioGroup = true;
            this.zoom = 1.0;
        } else if (this.zoom != 0.0) {
            delta = (double)node.getDelay() * this.zoom;
            this.nextDelay -= delta;
        }
        if (node == this.targetNode) {
            this.stop();
        }
        this.res = node;
        if (this.currTime + delta - this.targetTime > 1.1) {
            this.stop();
        }
        this.currTime += delta;
    }

    @Override
    public void postVisit(Composite comp) throws Visitor.StopException {
        double delta;
        if (comp instanceof PenPlusAudio) {
            this.zoom = Scheduler.DEFAULT_ZOOM;
        }
        if (comp.isLabel()) {
            if (this.nextDelay > 0.0) {
                if (this.currTime + this.nextDelay - this.targetTime > 1.1) {
                    this.stop();
                }
                this.currTime += this.nextDelay;
                this.nextDelay = 0.0;
            }
            this.zoom = Scheduler.DEFAULT_ZOOM;
        }
        if (this.currTime + (delta = (double)comp.getPostDelay() * this.zoom) - this.targetTime > 1.1) {
            this.stop();
        }
        this.currTime += delta;
        this.nextDelay -= delta;
    }

    public Node seek(int time) {
        this.init();
        this.targetTime = time;
        this.traverseFrom(this.seq.getRootNode());
        return this.res;
    }

    public int getRealTime(Node node) {
        this.init();
        this.targetNode = node;
        this.traverseFrom(this.seq.getRootNode());
        return (int)this.currTime;
    }

    public static String formatRealTime(int time) {
        int secs = time / 1000;
        int mins = secs / 60;
        return String.valueOf(TimeManager.twoDigits(mins)) + ":" + TimeManager.twoDigits(secs -= mins * 60);
    }

    public static String twoDigits(int t) {
        return t < 10 ? "0" + t : "" + t;
    }
}

