/*
 * Decompiled with CFR 0.152.
 */
package edicurso;

import edicurso.Scheduler;
import java.util.Queue;

public abstract class Task
implements Comparable<Task> {
    Thread thread;
    double zoom;
    double nextTime;
    boolean running = false;
    boolean detached = false;
    boolean finished = false;
    boolean aborted = false;
    boolean abortThrown = false;

    Task() {
    }

    Task(Thread thread) {
        this.thread = thread;
        this.nextTime = 0.0;
    }

    @Override
    public int compareTo(Task task) {
        return this.nextTime == task.nextTime ? 0 : (this.nextTime > task.nextTime ? 1 : -1);
    }

    public abstract void run();

    public String getName() {
        return this.thread.getName();
    }

    public void setName(String name) {
        this.thread.setName(name);
    }

    public static Task getCurrentTask() {
        Thread javaThread = Thread.currentThread();
        if (javaThread == Scheduler.awtEventThread) {
            return Scheduler.awt;
        }
        Scheduler.TaskThread thread = (Scheduler.TaskThread)javaThread;
        return thread.task;
    }

    public void start() {
        Scheduler sched = Scheduler.getScheduler();
        this.running = true;
        this.zoom = sched.getDefaultZoom();
        sched.start(this);
    }

    public void join() {
        Scheduler.getScheduler().join(this);
    }

    public static void detach() {
        Scheduler.getScheduler().detach();
    }

    public static void attach() {
        Scheduler.getScheduler().attach();
    }

    public void checkAborted() {
        Scheduler.getScheduler().checkAborted();
    }

    public static void sleep(int vdelay) {
        if (vdelay > 0) {
            Scheduler.getScheduler().sleep((double)vdelay * Task.getZoom());
        }
    }

    public static void realSleep(int rdelay) {
        if (rdelay > 0) {
            Scheduler.getScheduler().sleep(rdelay);
        }
    }

    public static void await(Queue<Task> queue) {
        Scheduler.getScheduler().await(queue);
    }

    public static double getZoom() {
        Scheduler sched = Scheduler.getScheduler();
        Task task = Task.getCurrentTask();
        double zoom = task.zoom;
        double min = sched.getMinZoom();
        double max = sched.getMaxZoom();
        if (zoom < min) {
            zoom = min;
        }
        if (zoom > max) {
            zoom = max;
        }
        return zoom;
    }

    public static double setZoom(double newZoom) {
        System.out.println("setZoom " + newZoom);
        Task task = Task.getCurrentTask();
        task.zoom = newZoom;
        return Task.getZoom();
    }
}

