/*
 * Decompiled with CFR 0.152.
 */
package edicurso;

import edicurso.AudioManager;
import edicurso.CaptureManager;
import edicurso.ColorBoxRenderer;
import edicurso.CourseModel;
import edicurso.Drawer;
import edicurso.EdicursoView;
import edicurso.Player;
import edicurso.Scheduler;
import edicurso.StrokeBoxRenderer;
import edicurso.TabletManager2;
import edicurso.Task;
import edicurso.TimeManager;
import edicurso.UI;
import edicurso.Visitor;
import edicurso.operations.AudioClip;
import edicurso.operations.AudioNode;
import edicurso.operations.Composite;
import edicurso.operations.EndAudioClip;
import edicurso.operations.Eraser;
import edicurso.operations.Group;
import edicurso.operations.GuiNode;
import edicurso.operations.NamedNode;
import edicurso.operations.Node;
import edicurso.operations.NodeFactory;
import edicurso.operations.Pause;
import edicurso.operations.PauseBreak;
import edicurso.operations.PenPlusAudio;
import edicurso.operations.PenSegment;
import edicurso.operations.RootNode;
import edicurso.operations.RootNode2;
import edicurso.operations.Segment;
import edicurso.operations.SetColor;
import edicurso.operations.SetStroke;
import edicurso.operations.ShowImage;
import edicurso.operations.Slide;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.XMLDecoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.application.Application;

public class Sequencer
implements TreeSelectionListener,
TreeExpansionListener,
ActionListener,
ChangeListener {
    public static final int MAX_CLICK_DELAY = 300;
    public static final double MAX_CLICK_DISTANCE = 8.0;
    public static final double MIN_DRAG_DELAY = 300.0;
    EventDispatcher eventDispatcher = new EventDispatcher();
    public static final int TICKPERIOD = 500;
    public final State stopState = new StopState();
    public final State penState = new PenState();
    public final AudioCapState penAudioCapState = new PenAudioCapState();
    public final AudioCapState audioCapState = new AudioCapState();
    public final PlayState playState = new PlayState();
    public final PauseState pauseState = new PauseState();
    public final DragState dragState = new DragState();
    protected State state = this.stopState;
    protected State oldState = null;
    protected Drawer drawer;
    protected UI ui;
    protected JTree actionTree;
    protected RootNode rootNode;
    protected CourseModel model;
    protected static CaptureManager captureManager = CaptureManager.getCaptureManager();
    protected static AudioManager audioManager = AudioManager.getAudioManager();
    static TabletManager2 tabletManager = TabletManager2.getTabletManager();
    boolean digitizerEnabled = false;
    protected Node currNode;
    protected Node prevNode = null;
    protected Node lastPlayNode = null;
    Node primaryNode = null;
    Node secondaryNode = null;
    String fileName = null;
    long currTime;
    protected boolean needsRepaintFlag;
    protected boolean needsRedrawFlag;
    protected boolean insideTransaction = true;
    protected boolean updateSelection = true;
    public TimeManager timeManager = new TimeManager(this);
    int totalTime = 0;
    int currentTime = 0;
    static ArrayList<Node> clipboard = new ArrayList();
    boolean tickState = false;
    long tickTime;
    int tickDelta;
    Timer timer = new Timer(1000000, this);
    static TestVisitor test = new TestVisitor();
    protected boolean wasPlaying = false;
    boolean adjusting = false;

    public final Node current() {
        return this.currNode;
    }

    public final void setCurrent(Node node) {
        if (this.state != this.penState && this.state != this.playState) {
            System.out.println("current node: " + node.toString());
        }
        this.currNode = node;
    }

    public final void needsRepaint() {
        this.needsRepaintFlag = true;
    }

    public final void needsRedraw() {
        this.needsRedrawFlag = true;
    }

    public Sequencer() {
        this.timer.setRepeats(true);
        this.timer.setInitialDelay(500);
        this.timer.start();
    }

    public Sequencer(EdicursoView ui) {
        this();
        try {
            this.init(ui);
            JComboBox colorComboBox = ui.getColorComboBox();
            colorComboBox.setRenderer(new ColorBoxRenderer(this));
            JComboBox strokeComboBox = ui.getStrokeComboBox();
            strokeComboBox.setRenderer(new StrokeBoxRenderer(this));
            this.actionTree.setModel(this.model);
            this.actionTree.getSelectionModel().setSelectionMode(2);
            this.timer.setRepeats(true);
        }
        finally {
            this.epilog();
        }
    }

    public void init(UI ui) {
        this.ui = ui;
        this.actionTree = ui.getActionTree();
        this.actionTree.addTreeSelectionListener(this);
        this.actionTree.addTreeExpansionListener(this);
        this.rootNode = new RootNode();
        this.prevNode = null;
        this.model = new CourseModel(this.rootNode);
        this.select(this.rootNode);
        this.drawer = new Drawer(this, audioManager);
        this.drawer.addMouseListener(this.eventDispatcher);
        this.drawer.addMouseMotionListener(this.eventDispatcher);
        ui.getFrame().addKeyListener(this.eventDispatcher);
        ui.getWhiteboard().add((Component)this.drawer, "Center");
        ui.getSlider().addChangeListener(this);
        this.needsRepaint();
    }

    public final UI getUi() {
        return this.ui;
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public final Drawer getDrawer() {
        return this.drawer;
    }

    public static final AudioManager getAudioManager() {
        return audioManager;
    }

    public final TabletManager2 getTabletManager() {
        return tabletManager;
    }

    public final TimeManager getTimeManager() {
        return this.timeManager;
    }

    public final JTree getActionTree() {
        return this.actionTree;
    }

    public final CourseModel getModel() {
        return this.model;
    }

    public final RootNode getRootNode() {
        return this.rootNode;
    }

    public final State getState() {
        return this.state;
    }

    public final void setState(State state) {
        this.state = state;
    }

    public final int getTotalTime() {
        return this.totalTime;
    }

    public final int getCurrentTime() {
        return this.currentTime;
    }

    public boolean isRelator() {
        return false;
    }

    public final Node getLastPlayNode() {
        return this.lastPlayNode;
    }

    public final void setLastPlayNode(Node node) {
        this.lastPlayNode = node;
    }

    public final long getTickTime() {
        return this.tickTime;
    }

    public final void setNextTick(int tickDelta) {
        this.tickDelta = tickDelta;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            long currTime;
            this.prolog(false);
            this.tickTime = currTime = System.currentTimeMillis();
            this.tickDelta = 500;
            if (this.tickState) {
                this.state.tick();
                this.tickState = false;
            } else {
                this.state.tock();
                this.tickState = true;
            }
        }
        finally {
            this.epilog();
        }
        if (this.tickDelta >= 0) {
            int delta = 0;
            if (this.tickDelta > 0 && (delta = this.tickDelta - (int)(System.currentTimeMillis() - this.tickTime)) <= 0) {
                delta = 5;
            }
            this.timer.setInitialDelay(delta);
            this.timer.setDelay(delta);
            this.timer.restart();
        }
    }

    public void resetTimer(int delta) {
        this.tickState = true;
        this.timer.setInitialDelay(delta);
        this.timer.setDelay(delta);
        this.timer.restart();
    }

    public final void select(Node node) {
        this.select(node, true);
    }

    public final void select(Node node, boolean needsRepaint) {
        this.setCurrent(node);
        if (this.currNode != this.prevNode) {
            this.primaryNode = node;
            this.secondaryNode = null;
            if (needsRepaint) {
                this.needsRepaint();
            }
        }
    }

    public final void multipleSelect(Node prim, Node sec) {
        this.setCurrent(sec);
        TreePath primPath = prim.getPath();
        TreePath secPath = sec.getPath();
        this.actionTree.scrollPathToVisible(primPath);
        this.actionTree.scrollPathToVisible(secPath);
        int minRow = this.actionTree.getRowForPath(primPath);
        int maxRow = this.actionTree.getRowForPath(secPath);
        this.actionTree.setSelectionInterval(minRow, maxRow);
        this.primaryNode = prim;
        this.secondaryNode = sec;
        this.updateSelection = false;
        this.needsRepaint();
    }

    protected final boolean tryProlog() {
        if (this.insideTransaction) {
            return false;
        }
        this.prolog();
        return true;
    }

    public final void prolog() {
        this.prolog(true);
    }

    public void prolog(boolean clearStatus) {
        assert (!this.insideTransaction);
        this.model.setTransactionClean();
        this.prevNode = this.current();
        this.updateSelection = true;
        this.needsRepaintFlag = false;
        this.needsRedrawFlag = false;
        this.insideTransaction = true;
        this.oldState = this.state;
        if (clearStatus) {
            this.ui.getStatusMessageLabel().setText("");
        }
    }

    protected void epilog() {
        boolean tabletEnabled;
        Node node = this.current();
        if (!this.model.isTransactionClean() && this.state != this.penState && this.state != this.penAudioCapState) {
            this.updateTotalTime();
        }
        if (this.prevNode != node || this.oldState != this.state) {
            JTextComponent textArea = this.ui.getTextArea();
            boolean editable = node.isEditable();
            if (editable && (this.state == this.stopState || this.state == this.audioCapState)) {
                textArea.setText(((NamedNode)node).getName());
                textArea.setEnabled(true);
                textArea.setBackground(this.state == this.audioCapState ? Color.PINK : Color.WHITE);
            } else if (this.state != this.playState || this.oldState != this.state) {
                textArea.setText(node.toString());
                textArea.setEnabled(false);
                textArea.setBackground(Drawer.bg);
            }
            if (this.prevNode != null && this.prevNode != node) {
                this.prevNode.newCurrent(node, this);
                if (this.state == this.stopState || this.state == this.penState || this.oldState != this.state) {
                    Composite currParent;
                    Composite prevParent = this.prevNode.getParent();
                    Composite composite = currParent = node == null ? null : node.getParent();
                    if (prevParent != null && prevParent != currParent && this.prevNode != currParent && prevParent != node && prevParent.hasLeavesOnly()) {
                        TreePath prevPath = prevParent.getPath();
                        this.actionTree.collapsePath(prevPath);
                    }
                }
            }
            if (!this.adjusting) {
                TreePath path = node.getPath();
                if (this.updateSelection) {
                    this.actionTree.setSelectionPath(path);
                }
                this.actionTree.scrollPathToVisible(path);
            }
        }
        if (this.oldState != this.state) {
            JToggleButton btnPen = this.ui.getBtnPen();
            JToggleButton btnAudioRec = this.ui.getBtnAudioRec();
            JToggleButton btnPenAudioRec = this.ui.getBtnPenAudioRec();
            if (this.state != this.audioCapState) {
                this.drawer.setRecMark(false);
            }
            if (this.state != this.pauseState) {
                this.drawer.setPauseMark(false);
            }
            if (this.state != this.penState) {
                btnPen.setForeground(Color.red);
            }
            if (this.state != this.audioCapState) {
                btnAudioRec.setForeground(Color.red);
            }
            if (this.state != this.penAudioCapState) {
                btnPenAudioRec.setForeground(Color.red);
            }
            if (this.state == this.stopState) {
                this.ui.getBtnStop().setSelected(true);
            } else if (this.state == this.penState) {
                btnPen.setSelected(true);
            } else if (this.state == this.pauseState) {
                this.ui.getBtnPause().setSelected(true);
            } else if (this.state == this.playState) {
                this.ui.getBtnPlay().setSelected(true);
            } else if (this.state == this.audioCapState) {
                this.ui.getBtnAudioRec().setSelected(true);
            } else if (this.state == this.penAudioCapState) {
                this.ui.getBtnPenAudioRec().setSelected(true);
            }
            JMenu edit = this.ui.getEditMenu();
            JComboBox colorComboBox = this.ui.getColorComboBox();
            JComboBox strokeComboBox = this.ui.getStrokeComboBox();
            JButton eraserBtn = this.ui.getEraserBtn();
            JTextComponent areaText = this.ui.getTextArea();
            boolean notPlaying = this.state != this.playState && this.state != this.pauseState;
            edit.setEnabled(notPlaying);
            btnPen.setEnabled(notPlaying);
            btnAudioRec.setEnabled(notPlaying);
            btnPenAudioRec.setEnabled(notPlaying);
            colorComboBox.setEnabled(notPlaying);
            strokeComboBox.setEnabled(notPlaying);
            eraserBtn.setEnabled(notPlaying);
            areaText.setEnabled(notPlaying);
        }
        if ((tabletEnabled = tabletManager.isEnabled()) != this.digitizerEnabled) {
            this.ui.getDigitizer().setSelected(tabletEnabled);
            this.digitizerEnabled = tabletEnabled;
        }
        if (this.needsRepaintFlag) {
            this.repaint();
            this.updateCurrentTime(this.timeManager.getRealTime(this.current()));
        }
        if (this.needsRedrawFlag) {
            this.drawer.redraw();
        }
        this.insideTransaction = false;
    }

    public void stop() {
        try {
            this.prolog();
            this.stopImpl();
            this.needsRepaint();
        }
        finally {
            this.epilog();
        }
    }

    protected void stopImpl() {
        if (this.state == this.audioCapState || this.state == this.penAudioCapState) {
            this.ui.getTextArea().setBackground(Color.WHITE);
            this.stopCapture();
            if (this.state == this.penAudioCapState) {
                this.collapse(this.penAudioCapState.getComposite());
            }
        } else if (this.state == this.playState || this.state == this.pauseState) {
            audioManager.abort();
            Player player = this.drawer.getPlayer();
            if (player != null) {
                player.setEpilog(null);
            }
        } else if (this.state == this.penState || this.state == this.penAudioCapState) {
            tabletManager.stop();
            tabletManager.enable(this, false);
            this.drawer.clearCursor();
            this.ui.drivePenFullArea(false);
        }
        this.setState(this.stopState);
        Scheduler sched = Scheduler.getScheduler();
        if (sched.getSequencer() == this) {
            sched.abort();
        }
        this.timer.stop();
    }

    public void penRecord() {
        try {
            this.prolog();
            this.stopImpl();
            tabletManager.enable(this, true);
            this.currTime = System.currentTimeMillis();
            this.setState(this.penState);
            this.resetTimer(0);
            this.needsRepaint();
            this.ui.drivePenFullArea(true);
        }
        finally {
            this.epilog();
        }
    }

    public void digitizer(boolean enable) {
        try {
            this.prolog();
            this.digitizerEnabled = true;
        }
        finally {
            this.epilog();
        }
    }

    public void audioCapture(boolean isRelease) {
        Sequencer oldSeq = captureManager.getSequencer();
        if (oldSeq != null && oldSeq != this) {
            oldSeq.stop();
        }
        try {
            this.prolog();
            this.oldState = null;
            if (!isRelease && this.state == this.audioCapState) {
                this.stopCapture();
            } else if (isRelease && this.state != this.audioCapState) {
                String msg = this.validateAudioInterval();
                if (msg != null) {
                    Sequencer.beep();
                    this.ui.getStatusMessageLabel().setText(msg);
                } else {
                    this.stopImpl();
                    Node node = this.current();
                    while (!(node instanceof Composite)) {
                        node = node.getParent();
                    }
                    this.audioCapState.setComposite((Composite)node);
                    this.setState(this.audioCapState);
                    this.resetTimer(0);
                    captureManager.startCapture(this);
                }
            } else if (isRelease && this.state == this.audioCapState) {
                this.stopImpl();
            }
        }
        finally {
            this.epilog();
        }
    }

    String validateAudioInterval() {
        boolean noLabel;
        AudioManager.Finder finder = AudioManager.finder;
        TreePath minPath = this.actionTree.getPathForRow(this.actionTree.getMinSelectionRow());
        TreePath maxPath = this.actionTree.getPathForRow(this.actionTree.getMaxSelectionRow());
        if (minPath == null || maxPath == null) {
            return "No selected interval found";
        }
        Node audioStart = ((GuiNode)minPath.getLastPathComponent()).getNode();
        if (audioStart instanceof AudioClip) {
            return null;
        }
        Node audioEnd = ((GuiNode)maxPath.getLastPathComponent()).getNode();
        if (audioStart == audioEnd && audioStart instanceof EndAudioClip) {
            return null;
        }
        if (audioEnd instanceof Composite && this.actionTree.isCollapsed(audioEnd.getPath())) {
            audioEnd = audioEnd.getLastLeaf();
        }
        if (!(noLabel = finder.findAudioNode(audioStart, audioEnd))) {
            return "Audio can't cross a labeled group or slide";
        }
        Node audioNode = finder.getNextNode();
        if (audioNode instanceof AudioNode) {
            return "The selected interval already contains audio";
        }
        noLabel = finder.reverseFindAudioNode(audioStart);
        audioNode = finder.getNextNode();
        if (noLabel && audioNode != null && !(audioNode instanceof EndAudioClip)) {
            return "The selected interval already contains audio";
        }
        return null;
    }

    void stopCapture() {
        AudioClip clip = captureManager.stopCapture();
        if (clip == null) {
            return;
        }
        if (this.secondaryNode == null) {
            if (this.currNode instanceof AudioClip) {
                String text = ((AudioClip)this.currNode).getName();
                if (text != null) {
                    clip.setName(text);
                }
                this.replaceNode(this.currNode, clip);
                this.select(clip);
            } else if (this.currNode instanceof EndAudioClip) {
                Composite parent = this.currNode.getParent();
                int idx = parent.getIndex(this.currNode);
                this.addNode(parent, clip, idx);
                this.multipleSelect(clip, this.currNode);
            } else if (!(this.currNode instanceof Composite)) {
                Composite parent = this.currNode.getParent();
                int idx = parent.getIndex(this.currNode);
                EndAudioClip end = new EndAudioClip();
                this.addNode(parent, clip, idx + 1);
                this.addNode(parent, end, idx + 2);
                this.multipleSelect(clip, end);
            } else {
                EndAudioClip end = new EndAudioClip();
                this.addNode(this.currNode, clip, 0);
                if (this.isExpanded(this.currNode)) {
                    this.addNode(this.currNode, end, 1);
                } else {
                    this.addNode(this.currNode, end);
                }
                this.multipleSelect(clip, end);
            }
        } else {
            TreePath minPath = this.actionTree.getPathForRow(this.actionTree.getMinSelectionRow());
            TreePath maxPath = this.actionTree.getPathForRow(this.actionTree.getMaxSelectionRow());
            Node audioStart = ((GuiNode)minPath.getLastPathComponent()).getNode();
            Node audioEnd = ((GuiNode)maxPath.getLastPathComponent()).getNode();
            if (audioStart instanceof AudioClip) {
                AudioManager.Finder finder = AudioManager.finder;
                AudioNode audioNode = (AudioNode)audioStart;
                EndAudioClip end = null;
                boolean noLabel = finder.findAudioNode(audioNode);
                while (noLabel) {
                    audioNode = finder.getAudioNode();
                    if (audioNode instanceof EndAudioClip) {
                        end = (EndAudioClip)audioNode;
                        break;
                    }
                    noLabel = finder.findAudioNode(audioNode);
                }
                this.replaceNode(audioStart, clip);
                if (audioEnd != end) {
                    this.model.removeNodeFromParent(end);
                    end = new EndAudioClip();
                    if (audioEnd instanceof Composite && this.isExpanded(audioEnd)) {
                        this.addNode(audioEnd, end);
                    } else {
                        Composite parent = audioEnd.getParent();
                        this.addNode(parent, end, parent.getIndex(audioEnd) + 1);
                    }
                }
                this.multipleSelect(clip, end);
            } else {
                Composite parent = audioStart.getParent();
                this.addNode(parent, clip, parent.getIndex(audioStart));
                parent = audioEnd.getParent();
                EndAudioClip end = new EndAudioClip();
                this.addNode(parent, end, parent.getIndex(audioEnd) + 1);
                this.multipleSelect(clip, end);
            }
        }
    }

    public void addGroup() {
        try {
            this.prolog();
            this.addSelected(new Group(null));
        }
        finally {
            this.epilog();
        }
    }

    public void addSlide() {
        try {
            this.prolog();
            this.addSelected(new Slide(0));
        }
        finally {
            this.epilog();
        }
    }

    public void addUnrecorded() {
        try {
            this.prolog();
            this.addSelected(AudioClip.empty());
        }
        finally {
            this.epilog();
        }
    }

    public void audioEnd(long when) {
        try {
            this.prolog();
            this.addSelected(new EndAudioClip());
        }
        finally {
            this.epilog();
        }
    }

    public void pause1second(int delay) {
        try {
            this.prolog();
            this.addSelected(new Pause(delay));
        }
        finally {
            this.epilog();
        }
    }

    public void pauseBreak() {
        try {
            this.prolog();
            this.addSelected(new PauseBreak());
        }
        finally {
            this.epilog();
        }
    }

    void collapse(Node node) {
        TreePath path = node.getPath();
        this.actionTree.collapsePath(path);
        this.select(node);
    }

    public void penAudioGroup(boolean isRelease) {
        Sequencer oldSeq = captureManager.getSequencer();
        if (oldSeq != null && oldSeq != this) {
            oldSeq.stop();
        }
        try {
            this.prolog();
            if (!isRelease && this.state == this.penAudioCapState) {
                this.stopCapture();
                this.collapse(this.penAudioCapState.getComposite());
            } else if (isRelease && this.state != this.penAudioCapState) {
                this.stopImpl();
                this.currTime = System.currentTimeMillis();
                PenPlusAudio comp = new PenPlusAudio(null);
                this.addSelected(comp);
                this.penAudioCapState.setComposite(comp);
                this.setState(this.penAudioCapState);
                this.resetTimer(0);
                captureManager.startCapture(this);
            } else if (isRelease && this.state == this.penAudioCapState) {
                this.stopImpl();
            }
        }
        finally {
            this.epilog();
        }
    }

    public void image(File file) {
        try {
            this.prolog();
            ShowImage.image(0, file, this);
        }
        finally {
            this.epilog();
        }
    }

    public boolean compress() {
        String error;
        block18: {
            FileOutputStream out;
            block19: {
                error = null;
                File tmpFile = null;
                out = null;
                try {
                    this.prolog();
                    Visitor.Compressor compressor = new Visitor.Compressor(this);
                    this.rootNode.traverseTree(compressor);
                    audioManager.annotate(this.rootNode);
                    File file = new File(this.fileName);
                    file = file.getCanonicalFile();
                    tmpFile = File.createTempFile("compress", null, file.getParentFile());
                    out = new FileOutputStream(tmpFile);
                    this.rootNode.save(out, this);
                    this.close(out);
                    out = null;
                    if (!compressor.success) {
                        System.out.println("Error: some clips didn't compress correctly");
                    }
                    if (compressor.diffCnt != 0) {
                        System.out.println("Warning: " + compressor.diffCnt + " clips decompressed to a different size.  " + "Accumulated difference is " + compressor.diffSum + " bytes");
                    }
                    if (!file.delete()) {
                        error = "File not saved.  Can't change source file.";
                    } else if (tmpFile.renameTo(file)) {
                        this.updateTotalTime();
                        this.model.setClean();
                        tmpFile = null;
                    } else {
                        error = "File  deleted! Cant't rename " + tmpFile.getName() + " to " + file.getName();
                        tmpFile = null;
                    }
                }
                catch (FileNotFoundException e) {
                    error = "File not saved.  The path does not exist.";
                    if (error != null) {
                        this.ui.alert(error);
                    }
                    if (tmpFile != null) {
                        tmpFile.delete();
                    }
                    this.close(out);
                    this.epilog();
                    break block18;
                }
                catch (Exception e) {
                    try {
                        error = "File not saved.  Unknown I/O error.";
                        e.printStackTrace();
                        break block18;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (error != null) {
                            this.ui.alert(error);
                        }
                        if (tmpFile != null) {
                            tmpFile.delete();
                        }
                        this.close(out);
                        this.epilog();
                    }
                }
                if (error != null) {
                    this.ui.alert(error);
                }
                if (tmpFile == null) break block19;
                tmpFile.delete();
            }
            this.close(out);
            this.epilog();
        }
        return error == null;
    }

    public void play(boolean toggle) {
        Sequencer oldSequencer = Scheduler.getScheduler().getSequencer();
        if (oldSequencer == this) {
            if (this.state == this.pauseState) {
                this.prolog();
                System.out.println("pause -> play");
                this.setLastPlayNode(this.current());
                this.setState(this.playState);
                this.epilog();
                this.drawer.getPlayer().play();
                audioManager.play();
            } else if (this.state == this.playState && toggle) {
                System.out.println("play -> pause");
                this.pauseImpl();
            }
        } else {
            Player player;
            if (oldSequencer != null) {
                oldSequencer.stop();
            }
            try {
                this.prolog();
                System.out.println("play");
                Node node = this.current();
                this.setLastPlayNode(node);
                this.stopImpl();
                this.setState(this.playState);
                Scheduler.getScheduler().setSequencer(this);
                player = Player.makePlayer(this, node);
            }
            finally {
                this.epilog();
            }
            try {
                this.prolog();
                player.start();
            }
            finally {
                this.epilog();
            }
        }
    }

    void playImpl() {
        System.out.println("play");
        Node node = this.current();
        this.setLastPlayNode(node);
        this.stopImpl();
        Scheduler.getScheduler().setSequencer(this);
        Player player = Player.makePlayer(this, node);
        player.start();
    }

    public void replay() {
        Task player = null;
        try {
            this.prolog();
            Sequencer oldSequencer = Scheduler.getScheduler().getSequencer();
            if (oldSequencer == this && this.isPlaying() && this.lastPlayNode != null) {
                Node node = this.lastPlayNode.getNextNode();
                Player oldPlayer = this.getDrawer().getPlayer();
                if (oldPlayer != null) {
                    oldPlayer.setEpilog(null);
                }
                this.stopImpl();
                this.setCurrent(this.lastPlayNode);
                this.needsRepaint();
                this.setState(this.playState);
                Scheduler.getScheduler().setSequencer(this);
                player = Player.makePlayer(this, node);
            }
        }
        finally {
            this.epilog();
        }
        if (player != null) {
            try {
                this.prolog();
                player.start();
            }
            finally {
                this.epilog();
            }
        }
    }

    public void playEpilog(Node finalNode) {
        try {
            this.prolog();
            this.stopImpl();
            while (!this.actionTree.isVisible(finalNode.getPath())) {
                finalNode = finalNode.getParent();
            }
            this.select(finalNode);
            this.updateSelection = true;
            this.needsRepaintFlag = true;
        }
        finally {
            this.epilog();
        }
    }

    void pauseImpl() {
        audioManager.pause();
        this.setState(this.pauseState);
        this.resetTimer(500);
    }

    public void pause() {
        try {
            this.prolog();
            if (this.state != this.playState) {
                this.oldState = null;
            } else {
                this.pauseImpl();
            }
        }
        finally {
            this.epilog();
        }
    }

    public void ff() {
        try {
            this.prolog();
            Scheduler sched = Scheduler.getScheduler();
            if (sched != null) {
                sched.doubleSpeed();
            }
        }
        finally {
            this.epilog();
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean save() {
        String error;
        block16: {
            FileOutputStream out;
            block17: {
                error = null;
                File tmpFile = null;
                out = null;
                try {
                    this.prolog();
                    File file = new File(this.fileName);
                    file = file.getCanonicalFile();
                    tmpFile = File.createTempFile("save", null, file.getParentFile());
                    out = new FileOutputStream(tmpFile);
                    this.rootNode.save(out, this);
                    this.close(out);
                    out = null;
                    if (!file.delete()) {
                        error = "File not saved.  Can't change source file.";
                    } else if (tmpFile.renameTo(file)) {
                        this.model.setClean();
                        tmpFile = null;
                    } else {
                        error = "File deleted! Can't rename " + tmpFile.getName() + " to " + file.getName();
                        tmpFile = null;
                    }
                }
                catch (FileNotFoundException e) {
                    error = "File not saved.  The path does not exist.";
                    if (error != null) {
                        this.ui.alert(error);
                    }
                    if (tmpFile != null) {
                        tmpFile.delete();
                    }
                    this.close(out);
                    this.epilog();
                    break block16;
                }
                catch (Exception e) {
                    try {
                        error = "File not saved.  Unknown I/O error.";
                        e.printStackTrace();
                        break block16;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (error != null) {
                            this.ui.alert(error);
                        }
                        if (tmpFile != null) {
                            tmpFile.delete();
                        }
                        this.close(out);
                        this.epilog();
                    }
                }
                if (error != null) {
                    this.ui.alert(error);
                }
                if (tmpFile == null) break block17;
                tmpFile.delete();
            }
            this.close(out);
            this.epilog();
        }
        return error == null;
    }

    void close(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean saveAs(File file) {
        boolean success;
        block6: {
            success = false;
            FileOutputStream out = null;
            try {
                this.prolog();
                out = new FileOutputStream(file);
                this.rootNode.save(out, this);
                this.close(out);
                out = null;
                this.fileName = file.getCanonicalPath();
                this.model.setClean();
                success = true;
            }
            catch (FileNotFoundException e) {
                this.ui.alert("File not saved.  The path does not exist.");
                this.close(out);
                this.epilog();
                break block6;
            }
            catch (Exception e) {
                try {
                    this.ui.alert("File not save.  Unknown I/O error.");
                    e.printStackTrace();
                    this.close(out);
                    this.epilog();
                    break block6;
                }
                catch (Throwable throwable) {
                    this.close(out);
                    this.epilog();
                    throw throwable;
                }
            }
            this.close(out);
            this.epilog();
        }
        return success;
    }

    public boolean isEmpty() {
        return this.rootNode.getChildCount() == 0 && "root".equals(this.rootNode.getName());
    }

    public void open(File file) {
        InputStream stream = null;
        try {
            try {
                this.prolog();
                this.stopImpl();
                stream = new FileInputStream(file);
                ZipInputStream zipStream = new ZipInputStream(stream);
                ZipEntry entry = zipStream.getNextEntry();
                XMLDecoder xdec = new XMLDecoder(zipStream);
                System.out.print("unzipping xml.tree ... ");
                this.rootNode = (RootNode)xdec.readObject();
                xdec.close();
                System.out.println(" ready, size= " + entry.getSize() + ", compressed size: " + entry.getCompressedSize());
                stream.close();
                stream = new FileInputStream(file);
                zipStream = new ZipInputStream(stream);
                this.rootNode.open(file, zipStream, this);
                this.fileName = file.getCanonicalPath();
                this.model.setRoot(this.rootNode.getPeer());
                this.select(this.rootNode);
                this.setFrameTitle();
                this.updateTotalTime();
                this.model.setClean();
                this.drawer.computeArea();
                this.needsRepaint();
            }
            catch (FileNotFoundException e) {
                this.ui.alert("File not found");
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException exception) {
                        exception.printStackTrace();
                    }
                }
                this.epilog();
            }
            catch (Exception e) {
                block18: {
                    this.ui.alert("File could be read due to an I/O error");
                    e.printStackTrace();
                    if (stream == null) break block18;
                    try {
                        stream.close();
                    }
                    catch (IOException exception) {
                        exception.printStackTrace();
                    }
                }
                this.epilog();
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
            this.epilog();
        }
    }

    public void setFrameTitle() {
        this.ui.getFrame().setTitle(this.rootNode.getName().equals("root") ? "Edicurso" : this.rootNode.getName());
    }

    public void newcourse() {
        try {
            this.prolog();
            this.stopImpl();
            this.rootNode = new RootNode2();
            this.model.setRoot(this.rootNode.getPeer());
            this.select(this.rootNode);
            this.fileName = null;
            this.setFrameTitle();
            this.updateTotalTime();
            this.model.setClean();
            this.needsRepaint();
        }
        finally {
            this.epilog();
        }
    }

    public void newWindow() {
        try {
            this.prolog();
            Application app = this.ui.getApplication();
            Frame frame = this.ui.getFrame();
            Point loc = frame.getLocationOnScreen();
            Dimension size = frame.getSize();
            EdicursoView view = new EdicursoView(app);
            Frame newFrame = view.getFrame();
            loc.x += 40;
            loc.y += 40;
            newFrame.setLocation(loc);
            newFrame.setSize(size);
            newFrame.setVisible(true);
        }
        finally {
            this.epilog();
        }
    }

    public void copy() {
        try {
            TreePath[] selected;
            this.prolog();
            clipboard.clear();
            TreePath[] treePathArray = selected = this.actionTree.getSelectionPaths();
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Node orig;
                Node node;
                TreePath path = treePathArray[n2];
                if (!this.actionTree.isExpanded(path) && (node = (orig = Node.getLastPathComponent(path)).copyNode(new NodeFactory.Copy())) != null) {
                    clipboard.add(node);
                }
                ++n2;
            }
        }
        finally {
            this.epilog();
        }
    }

    public void paste() {
        try {
            this.prolog();
            if (!clipboard.isEmpty()) {
                this.stopImpl();
                Node orig = clipboard.get(0);
                Node node = orig.copyNode(new NodeFactory.Copy());
                this.addSelected(node);
                Composite parent = node.getParent();
                int index = parent.getIndex(node);
                int k = 1;
                while (k < clipboard.size()) {
                    orig = clipboard.get(k);
                    node = orig.copyNode(new NodeFactory.Copy());
                    this.addNode(parent, node, k + index);
                    ++k;
                }
                this.select(node);
            }
        }
        finally {
            this.epilog();
        }
    }

    public void cut() {
        try {
            this.prolog();
            this.stopImpl();
            clipboard.clear();
            Node newCurrNode = this.delete(this.actionTree.getSelectionPaths(), clipboard);
            if (newCurrNode != null) {
                this.select(newCurrNode);
            }
        }
        finally {
            this.epilog();
        }
    }

    public void delete() {
        try {
            this.prolog();
            this.stopImpl();
            Node newCurrNode = this.delete(this.actionTree.getSelectionPaths(), new ArrayList<Node>());
            if (newCurrNode != null) {
                this.select(newCurrNode);
            }
        }
        finally {
            this.epilog();
        }
    }

    public Node delete(TreePath[] selected, ArrayList<Node> nodeList) {
        Node node;
        TreePath path;
        Node firstSelected = Node.getLastPathComponent(selected[0]);
        if (firstSelected == this.rootNode) {
            return null;
        }
        Composite parent = firstSelected.getParent();
        Node prevNotSelected = firstSelected.getPreviousVisibleNode(this.actionTree);
        Node lastSelected = Node.getLastPathComponent(selected[selected.length - 1]);
        Node nextNotSelected = lastSelected.getNextVisibleNode(this.actionTree);
        if (nextNotSelected != null && parent.isNodeDescendant(nextNotSelected) && nextNotSelected.getParent() != parent) {
            return null;
        }
        TreePath[] treePathArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            path = treePathArray[n2];
            node = Node.getLastPathComponent(path);
            if (!parent.isNodeDescendant(node)) {
                return null;
            }
            ++n2;
        }
        treePathArray = selected;
        n = selected.length;
        n2 = 0;
        while (n2 < n) {
            path = treePathArray[n2];
            node = Node.getLastPathComponent(path);
            if (node.getParent() == parent) {
                nodeList.add(node);
            }
            ++n2;
        }
        for (Node node2 : nodeList) {
            this.model.removeNodeFromParent(node2);
        }
        return nextNotSelected == null ? prevNotSelected : nextNotSelected;
    }

    public Node getLastPathComponent(TreePath path) {
        return path == null ? null : ((GuiNode)path.getLastPathComponent()).getNode();
    }

    public TreePath getPath(Node node) {
        return node.getPath();
    }

    public int getChildCount(TreePath path) {
        return ((GuiNode)path.getLastPathComponent()).getChildCount();
    }

    public void left() {
        try {
            this.prolog();
            TreePath path = this.actionTree.getSelectionPath();
            if (path != null && path.getPathCount() > 1) {
                TreePath parentPath = path.getParentPath();
                this.select(this.getLastPathComponent(parentPath));
                this.actionTree.collapsePath(parentPath);
            }
        }
        finally {
            this.epilog();
        }
    }

    public void right() {
        try {
            this.prolog();
            TreePath path = this.actionTree.getSelectionPath();
            if (path != null && this.getChildCount(path) > 0) {
                this.actionTree.expandPath(path);
                int row = this.actionTree.getRowForPath(path);
                TreePath downPath = this.actionTree.getPathForRow(row + 1);
                if (downPath != null) {
                    this.select(this.getLastPathComponent(downPath));
                }
                this.needsRepaint();
            }
        }
        finally {
            this.epilog();
        }
    }

    public void move(int dir) {
        try {
            this.prolog();
            this.moveImpl(dir);
        }
        finally {
            this.epilog();
        }
    }

    void moveImpl(int dir) {
        if (this.primaryNode != null) {
            TreePath path = this.getPath(this.primaryNode);
            this.actionTree.expandPath(path.getParentPath());
            int row = this.actionTree.getRowForPath(path);
            TreePath movePath = this.actionTree.getPathForRow(row + dir);
            if (movePath != null) {
                this.primaryNode = this.getLastPathComponent(movePath);
                if (this.secondaryNode == null) {
                    this.actionTree.setSelectionPath(movePath);
                } else {
                    TreePath secondaryPath = this.getPath(this.secondaryNode);
                    this.actionTree.expandPath(secondaryPath.getParentPath());
                    int primary = this.actionTree.getRowForPath(movePath);
                    int secondary = this.actionTree.getRowForPath(secondaryPath);
                    this.actionTree.scrollRowToVisible(primary - 3);
                    this.actionTree.scrollRowToVisible(primary + 3);
                    this.actionTree.setSelectionInterval(primary, secondary);
                }
            }
        }
        this.updateImpl();
    }

    public void secondaryMove(int dir) {
        try {
            this.prolog();
            if (this.secondaryNode == null) {
                this.moveImpl(dir);
            } else {
                TreePath secondaryPath = this.secondaryNode.getPath();
                this.actionTree.expandPath(secondaryPath.getParentPath());
                int row = this.actionTree.getRowForPath(secondaryPath);
                TreePath movePath = this.actionTree.getPathForRow(row + dir);
                if (movePath != null) {
                    TreePath primaryPath = this.primaryNode.getPath();
                    this.actionTree.expandPath(primaryPath.getParentPath());
                    this.actionTree.expandPath(movePath.getParentPath());
                    int primary = this.actionTree.getRowForPath(primaryPath);
                    int secondary = this.actionTree.getRowForPath(movePath);
                    this.secondaryNode = ((GuiNode)movePath.getLastPathComponent()).getNode();
                    this.actionTree.scrollRowToVisible(secondary - 3);
                    this.actionTree.scrollRowToVisible(secondary + 3);
                    this.actionTree.setSelectionInterval(primary, secondary);
                }
            }
            this.updateImpl();
        }
        finally {
            this.epilog();
        }
    }

    public void pageUp() {
        try {
            this.prolog();
            Slide prevSlide = Slide.slideVisitor.getPreviousSlide(this.current());
            if (prevSlide != null) {
                this.select(prevSlide);
            }
        }
        finally {
            this.epilog();
        }
    }

    public void pageDown() {
        try {
            this.prolog();
            Slide nextSlide = Slide.slideVisitor.getNextSlide(this.current());
            if (nextSlide != null) {
                this.select(nextSlide);
            }
        }
        finally {
            this.epilog();
        }
    }

    public void group() {
        try {
            this.prolog();
            this.makeGroup(new Group(null));
        }
        finally {
            this.epilog();
        }
    }

    void makeGroup(Composite comp) {
        TreePath[] selected = this.actionTree.getSelectionPaths();
        Node first = Node.getLastPathComponent(selected[0]);
        if (first == this.rootNode) {
            return;
        }
        Composite parent = first.getParent();
        int index = parent.getIndex(first);
        ArrayList<Node> children = new ArrayList<Node>();
        if (this.delete(selected, children) == null) {
            return;
        }
        this.addNode(parent, comp, index);
        for (Node node : children) {
            this.addNode(comp, node);
        }
        this.actionTree.collapsePath(comp.getPath());
        this.select(comp);
    }

    public void closeSlide() {
        try {
            this.prolog();
            if (this.state != this.penState && this.state != this.stopState) {
                return;
            }
            Slide slide = new Slide(0);
            TreeNode[] branch = this.current().getBranch();
            int k = branch.length - 2;
            while (k >= 0) {
                int pos;
                int idx = pos = branch[k].getIndex(branch[k + 1]);
                while (idx >= 0) {
                    Node node = Node.getNode(branch, k);
                    Node comp = node.getChildAt(idx);
                    if (comp instanceof Slide) {
                        this.addNode(node, slide, pos + 1);
                        this.select(slide);
                        this.actionTree.collapsePath(comp.getPath());
                        return;
                    }
                    --idx;
                }
                --k;
            }
            this.addSelected(slide);
        }
        finally {
            this.epilog();
        }
    }

    public void slide() {
        try {
            this.prolog();
            this.makeGroup(new Slide(0));
        }
        finally {
            this.epilog();
        }
    }

    public void close() {
        try {
            this.prolog();
            if (this.state != this.penState && this.state != this.stopState) {
                return;
            }
            TreeNode[] branch = this.current().getBranch();
            int k = branch.length - 2;
            while (k >= 0) {
                int pos;
                int idx = pos = branch[k].getIndex(branch[k + 1]);
                while (idx >= 0) {
                    Node node = Node.getNode(branch, k);
                    Node comp = node.getChildAt(idx);
                    if (comp instanceof Group) {
                        Group group = new Group(null);
                        this.addNode(node, group, pos + 1);
                        this.select(group);
                        this.actionTree.collapsePath(comp.getPath());
                        return;
                    }
                    if (comp instanceof Slide) {
                        Slide slide = new Slide(0);
                        this.addNode(node, slide, pos + 1);
                        this.select(slide);
                        this.actionTree.collapsePath(comp.getPath());
                        return;
                    }
                    --idx;
                }
                --k;
            }
        }
        finally {
            this.epilog();
        }
    }

    public void back() {
        try {
            this.prolog();
            Node node = this.current();
            Node newCurrNode = null;
            if (node == null) {
                return;
            }
            Composite parent = node.getParent();
            if (parent == null) {
                return;
            }
            int index = parent.getIndex(node);
            newCurrNode = index == 0 ? parent : parent.getChildAt(index - 1);
            if (clipboard != null) {
                clipboard.add(node);
            }
            this.model.removeNodeFromParent(parent.getChildAt(index));
            this.select(newCurrNode);
        }
        finally {
            this.epilog();
        }
    }

    public void rename(String name) {
        if (!this.tryProlog()) {
            return;
        }
        try {
            if (this.state != this.penState && this.state != this.stopState) {
                return;
            }
            if (this.current().isEditable()) {
                this.current().setName(name);
                this.model.nodeChanged(this.current());
                this.setFrameTitle();
            }
        }
        finally {
            this.epilog();
        }
    }

    public void setColor(String name, Color color) {
        if (!this.tryProlog()) {
            return;
        }
        try {
            if (this.state != this.penState && this.state != this.stopState && this.state != this.penAudioCapState) {
                return;
            }
            this.addSelected(new SetColor(name, color));
        }
        finally {
            this.epilog();
        }
    }

    public void eraser() {
        try {
            this.prolog();
            if (this.state != this.penState && this.state != this.stopState && this.state != this.penAudioCapState) {
                return;
            }
            this.addSelected(new Eraser());
        }
        finally {
            this.epilog();
        }
    }

    public void setStroke(String name, int width) {
        if (!this.tryProlog()) {
            return;
        }
        try {
            if (this.state != this.penState && this.state != this.stopState) {
                return;
            }
            this.addSelected(new SetStroke(width));
        }
        finally {
            this.epilog();
        }
    }

    public void setSize(int width, int height) {
        try {
            this.prolog();
            RootNode root = this.rootNode;
            root.setWidth(width);
            root.setHeight(height);
            this.drawer.computeArea();
            this.drawer.touchAll();
            this.needsRedraw();
            System.out.println("area of presentation= " + root.getWidth() + " x " + root.getHeight());
        }
        finally {
            this.epilog();
        }
    }

    public void setGrid(int size) {
        try {
            this.prolog();
            RootNode root = this.rootNode;
            root.setGrid(size);
            this.drawer.touchAll();
            this.drawer.computeArea();
            this.needsRedraw();
        }
        finally {
            this.epilog();
        }
    }

    public void addSelected(Node child) {
        this.addNode(child);
        this.select(child);
    }

    public void addNode(Node child) {
        Node parent = this.current();
        int index = 0;
        while (true) {
            if (parent == null) {
                return;
            }
            if (parent instanceof Composite && (this.actionTree.isExpanded(parent.getPath()) || parent.getChildCount() == 0 || parent == this.rootNode)) break;
            Node node = parent;
            parent = parent.getParent();
            index = parent.getIndex(node) + 1;
        }
        this.addNode(parent, child, index);
    }

    public void addNode(Node parent, Node child) {
        this.addNode(parent, child, parent.getChildCount());
    }

    public void addNode(Node parent, Node child, int index) {
        this.model.insertNodeInto(child, parent, index);
    }

    public void replaceNode(Node oldNode, Node newNode) {
        Composite parent = oldNode.getParent();
        int idx = parent.getIndex(oldNode);
        this.model.removeNodeFromParent(oldNode);
        this.addNode(parent, newNode, idx);
    }

    public Node getLeadNode() {
        TreePath path;
        Node leadNode = null;
        if (this.actionTree.getSelectionPath() != null && this.state != this.penState && this.state != this.penAudioCapState && (path = this.actionTree.getPathForRow(this.actionTree.getMinSelectionRow())) != null) {
            leadNode = ((GuiNode)path.getLastPathComponent()).getNode();
        }
        return leadNode;
    }

    public void playerSelect(Node node) {
        if (node.isLabel() || this.actionTree.isVisible(node.getPath())) {
            this.setCurrent(node);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.tryProlog()) {
            try {
                if (!this.isPlaying()) {
                    TreePath path;
                    int count = this.actionTree.getSelectionCount();
                    if (count > 0 && (path = this.actionTree.getPathForRow(this.actionTree.getMaxSelectionRow())) != null) {
                        Node node = ((GuiNode)path.getLastPathComponent()).getNode();
                        if (count == 1) {
                            this.primaryNode = node;
                            this.secondaryNode = null;
                        } else {
                            Node node2 = ((GuiNode)this.actionTree.getPathForRow(this.actionTree.getMinSelectionRow()).getLastPathComponent()).getNode();
                            if (node == this.primaryNode) {
                                this.secondaryNode = node2;
                            } else if (node2 == this.primaryNode) {
                                this.secondaryNode = node;
                            }
                        }
                    }
                    this.updateImpl();
                    this.ui.getFrame().requestFocus();
                } else {
                    boolean wasPlaying = this.state == this.playState;
                    Player player = this.drawer.getPlayer();
                    if (player != null) {
                        this.stopImpl();
                        this.setState(this.pauseState);
                    }
                    this.select(((GuiNode)e.getPath().getLastPathComponent()).getNode());
                    if (!wasPlaying) {
                        this.resetTimer(500);
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Sequencer.this.play(false);
                            }
                        });
                    }
                }
            }
            finally {
                this.epilog();
            }
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.treeExpanded(event);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        if (this.state != this.playState && this.tryProlog()) {
            try {
                this.secondaryNode = null;
                TreePath path = event.getPath();
                this.actionTree.setSelectionPath(path);
                this.updateImpl();
            }
            finally {
                this.epilog();
            }
        }
    }

    public void updateImpl() {
        TreePath path;
        int count = this.actionTree.getSelectionCount();
        if (count > 0 && (path = this.actionTree.getPathForRow(this.actionTree.getMaxSelectionRow())) != null) {
            Node node = ((GuiNode)path.getLastPathComponent()).getNode();
            this.setCurrent(node);
            node.showInfo(this.timeManager);
            this.updateSelection = false;
        }
        this.needsRepaint();
    }

    public void makeLabelVisible(Node node) {
        while (!node.isLabel()) {
            node = node.getParent();
        }
        TreePath path = node.getPath();
        if (!this.actionTree.isExpanded(path)) {
            this.actionTree.setSelectionPath(path);
            this.actionTree.scrollPathToVisible(path);
        }
    }

    public void sliderSelect(final JSlider source, Node target) {
        this.select(target);
        if (!source.getValueIsAdjusting()) {
            this.ui.getFrame().requestFocus();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Sequencer.this.prolog();
                        source.setValue(0);
                        Sequencer.this.needsRepaint();
                    }
                    finally {
                        Sequencer.this.epilog();
                    }
                }
            });
        }
    }

    public boolean isAdjusting() {
        return this.adjusting;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.tryProlog()) {
            return;
        }
        try {
            JSlider source = (JSlider)e.getSource();
            int targetTime = source.getValue();
            Node target = this.timeManager.seek(targetTime);
            this.adjusting = source.getValueIsAdjusting();
            this.prevNode = null;
            this.makeLabelVisible(target);
            if (!this.isPlaying()) {
                this.sliderSelect(source, target);
            } else {
                this.wasPlaying = this.wasPlaying || this.state == this.playState;
                Player player = this.drawer.getPlayer();
                if (player != null) {
                    this.stopImpl();
                    this.setState(this.pauseState);
                }
                this.select(target);
                if (!this.wasPlaying) {
                    this.resetTimer(500);
                } else if (!source.getValueIsAdjusting()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Sequencer.this.wasPlaying = false;
                            Sequencer.this.play(false);
                        }
                    });
                }
            }
        }
        finally {
            this.epilog();
        }
    }

    boolean filterAccelerator(KeyEvent e) {
        JCheckBoxMenuItem menuBarMni = this.ui.getMenuBarMni();
        if (menuBarMni == null || menuBarMni.isSelected()) {
            return false;
        }
        JPopupMenu popupMenu = this.ui.getPopupMenu();
        KeyStroke k = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
        return this.filterAccelerator(k, popupMenu.getSubElements());
    }

    boolean filterAccelerator(KeyStroke k, MenuElement[] elems) {
        MenuElement[] menuElementArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            JMenuItem item;
            KeyStroke acc;
            MenuElement elem = menuElementArray[n2];
            if (elem instanceof JMenu || elem instanceof JPopupMenu) {
                if (this.filterAccelerator(k, elem.getSubElements())) {
                    return true;
                }
            } else if (elem instanceof JMenuItem && (acc = (item = (JMenuItem)elem).getAccelerator()) != null && k.equals(item.getAccelerator())) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        item.doClick();
                    }
                });
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void mouseClicked(MouseEvent e) {
        TreePath path;
        boolean secondButton;
        double zoom = this.drawer.getZoom();
        Node hitNode = this.drawer.getHitNode((int)((double)e.getX() / zoom + 0.5), (int)((double)e.getY() / zoom + 0.5));
        boolean bl = secondButton = (e.getModifiers() & 4) != 0 || (e.getModifiers() & 1) != 0;
        if (hitNode == null) {
            this.secondaryNode = null;
            if (this.primaryNode != null) {
                TreePath path2 = this.primaryNode.getPath();
                this.actionTree.setSelectionPath(path2);
                this.actionTree.scrollPathToVisible(path2);
            }
            return;
        }
        if (!secondButton || this.isRelator()) {
            this.primaryNode = hitNode;
            if (this.isRelator()) {
                this.setCurrent(hitNode);
            }
            this.secondaryNode = null;
            path = this.getPath(this.primaryNode);
            this.actionTree.expandPath(path.getParentPath());
            int primary = this.actionTree.getRowForPath(path);
            this.actionTree.scrollRowToVisible(primary - 3);
            this.actionTree.scrollRowToVisible(primary + 3);
            this.actionTree.setSelectionPath(path);
        } else {
            this.secondaryNode = hitNode;
            path = this.secondaryNode.getPath();
            this.actionTree.expandPath(path.getParentPath());
            int primary = this.actionTree.getRowForPath(this.primaryNode.getPath());
            int secondary = this.actionTree.getRowForPath(path);
            this.actionTree.scrollRowToVisible(secondary - 3);
            this.actionTree.scrollRowToVisible(secondary + 3);
            if (primary >= 0 && secondary >= 0) {
                this.actionTree.setSelectionInterval(primary, secondary);
            }
        }
        this.drawer.touchAll();
        this.updateImpl();
        this.select(hitNode);
        if (this.isPlaying() && hitNode != null) {
            this.stopImpl();
            this.setLastPlayNode(hitNode);
            this.setState(this.playState);
            Scheduler.getScheduler().setSequencer(this);
            Player player = Player.makePlayer(this, hitNode);
            player.start();
        }
    }

    public int elapsedTime(int maxDelay) {
        long oldTime = this.currTime;
        this.currTime = System.currentTimeMillis();
        int delay = (int)(this.currTime - oldTime);
        if (delay > maxDelay) {
            delay = maxDelay;
        }
        return delay;
    }

    public void clear() {
        audioManager.setAudioClip(null);
        this.drawer.clear();
        this.needsRepaintFlag = false;
        this.needsRedraw();
    }

    public final boolean isPlaying() {
        return this.state == this.playState || this.state == this.pauseState;
    }

    public Node getGhostNode(Node node) {
        Node slide = node;
        while (!(slide instanceof Slide)) {
            Composite parent = slide.getParent();
            if (parent == null) break;
            slide = parent;
        }
        return slide.getLastLeaf();
    }

    public boolean isExpanded(Node node) {
        return this.actionTree.isExpanded(node.getPath());
    }

    public void repaint() {
        this.repaint(this.current());
    }

    public void repaint(Node node) {
        if (!this.isExpanded(node) && !this.isPlaying()) {
            node = node.getLastVisibleLeaf();
        }
        this.clear();
        Node ghostNode = node;
        if (!this.isPlaying()) {
            ghostNode = this.getGhostNode(node);
        }
        this.rootNode.seek(ghostNode, this.drawer);
        this.drawer.setDrawNode(node);
    }

    public void updateCurrentTime(int time) {
        this.currentTime = time;
        this.ui.getLblTime().setText(TimeManager.formatRealTime(time));
        JSlider slider = this.ui.getSlider();
        if (!this.adjusting) {
            slider.setValue(time);
        }
    }

    public void updateTotalTime() {
        audioManager.annotate(this.rootNode);
        this.totalTime = this.timeManager.getRealTime(null);
        this.ui.getLblTotal().setText(TimeManager.formatRealTime(this.totalTime));
        JSlider slider = this.ui.getSlider();
        slider.setMaximum(this.getTotalTime());
        slider.setMinimum(0);
    }

    public void penMoved(TabletManager2.TabletEvent e) {
        try {
            this.prolog();
            this.state.penMoved(e);
        }
        finally {
            this.epilog();
        }
    }

    public void penPressed(TabletManager2.TabletEvent e) {
        try {
            this.prolog();
            this.state.penPressed(e);
        }
        finally {
            this.epilog();
        }
    }

    public void penDragged(TabletManager2.TabletEvent e) {
        try {
            this.prolog();
            this.state.penDragged(e);
        }
        finally {
            this.epilog();
        }
    }

    public void penReleased(TabletManager2.TabletEvent e) {
        try {
            this.prolog();
            this.state.penReleased(e);
        }
        finally {
            this.epilog();
        }
    }

    public class AudioCapState
    extends State {
        Composite composite;
        long start;

        Composite getComposite() {
            return this.composite;
        }

        void setComposite(Composite composite) {
            this.composite = composite;
            this.start = System.currentTimeMillis();
        }

        @Override
        public void tick() {
            Sequencer.this.drawer.setRecMark(true);
            Sequencer.this.needsRedraw();
        }

        @Override
        public void tock() {
            Sequencer.this.drawer.setRecMark(false);
            Sequencer.this.needsRedraw();
        }
    }

    public class DragState
    extends State {
        int oldX;
        int oldY;
        HashSet<Node> selectedSet;
        long start;

        public void set(MouseEvent e, HashSet<Node> selectedSet) {
            this.oldX = e.getX();
            this.oldY = e.getY();
            this.start = e.getWhen();
            this.selectedSet = selectedSet;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if ((double)(e.getWhen() - this.start) > 300.0) {
                int newX = e.getX();
                int newY = e.getY();
                if (newX != this.oldX || newY != this.oldY) {
                    for (Node node : this.selectedSet) {
                        Sequencer.this.model.nodeChanged(node);
                        node.move(newX - this.oldX, newY - this.oldY, Sequencer.this);
                    }
                }
                this.oldX = newX;
                this.oldY = newY;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mouseDragged(e);
            Sequencer.this.setState(Sequencer.this.stopState);
        }
    }

    class EventDispatcher
    implements MouseListener,
    MouseMotionListener,
    KeyListener {
        MouseEvent pressEv = null;

        EventDispatcher() {
        }

        boolean isClick(MouseEvent ev1, MouseEvent ev2) {
            Point p1 = ev1.getPoint();
            Point p2 = ev2.getPoint();
            return ev2.getWhen() - ev1.getWhen() < 300L && p1.distance(p2.x, p2.y) < 8.0;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Sequencer.this.ui.getFrame().requestFocus();
            if ((e.getModifiers() & 0x10) == 0) {
                return;
            }
            try {
                Sequencer.this.prolog();
                this.pressEv = e;
                Sequencer.this.state.mousePressed(e);
            }
            finally {
                Sequencer.this.epilog();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int mods = e.getModifiers();
            if ((mods & 4) != 0 && this.maybeShowPopup(e)) {
                return;
            }
            try {
                Sequencer.this.prolog();
                Sequencer.this.state.mouseReleased(e);
                if (this.pressEv != null && this.isClick(this.pressEv, e)) {
                    Sequencer.this.state.mouseClicked(this.pressEv);
                }
                this.pressEv = null;
            }
            finally {
                Sequencer.this.epilog();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            try {
                Sequencer.this.prolog();
                Sequencer.this.state.mouseEntered(e);
            }
            finally {
                Sequencer.this.epilog();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            try {
                Sequencer.this.prolog();
                Sequencer.this.state.mouseExited(e);
            }
            finally {
                Sequencer.this.epilog();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            try {
                Sequencer.this.prolog();
                if (this.pressEv != null) {
                    Sequencer.this.state.mouseDragged(e);
                }
            }
            finally {
                Sequencer.this.epilog();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            try {
                Sequencer.this.prolog();
                Sequencer.this.state.mouseMoved(e);
            }
            finally {
                Sequencer.this.epilog();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            try {
                Sequencer.this.prolog();
                if (!Sequencer.this.filterAccelerator(e)) {
                    Sequencer.this.state.keyPressed(e);
                }
            }
            finally {
                Sequencer.this.epilog();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            try {
                Sequencer.this.prolog();
                Sequencer.this.state.keyReleased(e);
            }
            finally {
                Sequencer.this.epilog();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            try {
                Sequencer.this.prolog();
                Sequencer.this.state.keyTyped(e);
            }
            finally {
                Sequencer.this.epilog();
            }
        }

        private boolean maybeShowPopup(MouseEvent e) {
            JCheckBoxMenuItem menuBarMni = Sequencer.this.ui.getMenuBarMni();
            if (menuBarMni == null || menuBarMni.isSelected() || !e.isPopupTrigger()) {
                System.out.println("not a popup");
                return false;
            }
            Sequencer.this.ui.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
            return true;
        }
    }

    class PauseState
    extends State {
        PauseState() {
        }

        @Override
        public void tick() {
            Sequencer.this.drawer.setPauseMark(true);
            Sequencer.this.needsRedraw();
        }

        @Override
        public void tock() {
            Sequencer.this.drawer.setPauseMark(false);
            Sequencer.this.needsRedraw();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Sequencer.this.mouseClicked(e);
        }
    }

    public class PenAudioCapState
    extends AudioCapState {
        Segment path;
        PenSegment penPath;

        @Override
        public void mouseMoved(MouseEvent e) {
            TabletManager2 tabletManager = Sequencer.this.getTabletManager();
            if (tabletManager.isEnabled()) {
                tabletManager.start(Sequencer.this);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!Sequencer.this.getTabletManager().isEnabled()) {
                this.path = new Segment(this.elapsedTime(Sequencer.this, Integer.MAX_VALUE), e.getX(), e.getY(), Sequencer.this);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!Sequencer.this.getTabletManager().isEnabled()) {
                this.path.add(this.elapsedTime(Sequencer.this, Integer.MAX_VALUE), e.getX(), e.getY(), Sequencer.this);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!Sequencer.this.getTabletManager().isEnabled()) {
                this.path.add(this.elapsedTime(Sequencer.this, Integer.MAX_VALUE), e.getX(), e.getY(), Sequencer.this);
            }
        }

        @Override
        public void penMoved(TabletManager2.TabletEvent ev) {
            Sequencer.this.drawer.setPenCursor(ev.getX() / 16, ev.getY() / 16);
        }

        @Override
        public void penPressed(TabletManager2.TabletEvent ev) {
            Sequencer.this.drawer.setPenCursor(ev.getX() / 16, ev.getY() / 16);
            this.penPath = new PenSegment(this.elapsedTime(Sequencer.this, 1000), ev.getX(), ev.getY(), ev.getPressure(), Sequencer.this);
        }

        @Override
        public void penDragged(TabletManager2.TabletEvent ev) {
            Sequencer.this.drawer.setPenCursor(ev.getX() / 16, ev.getY() / 16);
            this.penPath.add(this.elapsedTime(Sequencer.this, 1000), ev.getX(), ev.getY(), ev.getPressure(), Sequencer.this);
        }

        @Override
        public void tick() {
            Sequencer.this.drawer.setRecMark(true);
            Sequencer.this.needsRedraw();
        }

        @Override
        public void tock() {
            Sequencer.this.drawer.setRecMark(false);
            Sequencer.this.needsRedraw();
        }
    }

    public class PenState
    extends State {
        Segment path;
        PenSegment penPath;

        @Override
        public void mouseMoved(MouseEvent e) {
            TabletManager2 tabletManager = Sequencer.this.getTabletManager();
            if (tabletManager.isEnabled()) {
                tabletManager.start(Sequencer.this);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!Sequencer.this.getTabletManager().isEnabled()) {
                this.path = new Segment(this.elapsedTime(Sequencer.this, 1000), e.getX(), e.getY(), Sequencer.this);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!Sequencer.this.getTabletManager().isEnabled() && this.path != null) {
                this.path.add(this.elapsedTime(Sequencer.this, 100), e.getX(), e.getY(), Sequencer.this);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!Sequencer.this.getTabletManager().isEnabled() && this.path != null) {
                this.path.add(this.elapsedTime(Sequencer.this, 100), e.getX(), e.getY(), Sequencer.this);
                Sequencer.this.updateTotalTime();
                Sequencer.this.updateCurrentTime(Sequencer.this.timeManager.getRealTime(this.path));
                this.path = null;
            }
        }

        @Override
        public void penMoved(TabletManager2.TabletEvent ev) {
            Sequencer.this.drawer.setPenCursor(ev.getX() / 16, ev.getY() / 16);
        }

        @Override
        public void penPressed(TabletManager2.TabletEvent ev) {
            Sequencer.this.drawer.setPenCursor(ev.getX() / 16, ev.getY() / 16);
            this.penPath = new PenSegment(this.elapsedTime(Sequencer.this, 1000), ev.getX(), ev.getY(), ev.getPressure(), Sequencer.this);
        }

        @Override
        public void penDragged(TabletManager2.TabletEvent ev) {
            if (this.penPath != null) {
                Sequencer.this.drawer.setPenCursor(ev.getX() / 16, ev.getY() / 16);
                this.penPath.add(this.elapsedTime(Sequencer.this, 100), ev.getX(), ev.getY(), ev.getPressure(), Sequencer.this);
            }
        }

        @Override
        public void penReleased(TabletManager2.TabletEvent ev) {
            if (this.penPath != null) {
                Sequencer.this.updateTotalTime();
                Sequencer.this.updateCurrentTime(Sequencer.this.timeManager.getRealTime(this.penPath));
            }
        }

        @Override
        public void tick() {
            JToggleButton btn = Sequencer.this.ui.getBtnPen();
            btn.setForeground(Color.BLACK);
        }

        @Override
        public void tock() {
            JToggleButton btn = Sequencer.this.ui.getBtnPen();
            btn.setForeground(Color.RED);
        }
    }

    class PlayState
    extends State {
        PlayState() {
        }

        @Override
        public void tick() {
            Player player = Sequencer.this.drawer.getPlayer();
            if (player != null) {
                player.tick();
            }
        }

        @Override
        public void tock() {
            Player player = Sequencer.this.drawer.getPlayer();
            if (player != null) {
                player.tick();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Sequencer.this.mouseClicked(e);
        }
    }

    public static class State {
        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void penMoved(TabletManager2.TabletEvent e) {
        }

        public void penPressed(TabletManager2.TabletEvent e) {
        }

        public void penDragged(TabletManager2.TabletEvent e) {
        }

        public void penReleased(TabletManager2.TabletEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void set() {
        }

        public int elapsedTime(Sequencer seq, int maxDelay) {
            return seq.elapsedTime(maxDelay);
        }

        public void tick() {
        }

        public void tock() {
            this.tick();
        }
    }

    class StopState
    extends State {
        StopState() {
        }

        @Override
        public void tick() {
            Sequencer.this.setNextTick(-1);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Sequencer.this.mouseClicked(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (Sequencer.this.isRelator()) {
                return;
            }
            HashSet<Node> selectedSet = this.nodeHit(e.getX(), e.getY());
            if (selectedSet != null) {
                Sequencer.this.dragState.set(e, selectedSet);
                Sequencer.this.setState(Sequencer.this.dragState);
            }
        }

        public final HashSet<Node> nodeHit(int x, int y) {
            TreePath[] selected = Sequencer.this.actionTree.getSelectionPaths();
            if (selected == null) {
                return null;
            }
            HashSet<Node> selectedSet = new HashSet<Node>();
            TreePath[] treePathArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                if (!Sequencer.this.actionTree.isExpanded(path)) {
                    selectedSet.add(Node.getLastPathComponent(path));
                }
                ++n2;
            }
            return Sequencer.this.drawer.isHit(x, y, selectedSet) ? selectedSet : null;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    static class TestVisitor
    extends Visitor {
        TestVisitor() {
        }

        @Override
        public void reverseVisit(Node node) {
            System.out.println("reverse visit: " + node);
        }

        @Override
        public void reversePostVisit(Composite comp) {
            System.out.println("reverse post visit: " + comp);
        }
    }
}

