/*
 * Decompiled with CFR 0.152.
 */
package edicurso;

import edicurso.AboutBox;
import edicurso.CourseMakerApp;
import edicurso.Drawer;
import edicurso.Sequencer;
import edicurso.UI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.EventObject;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.TaskMonitor;

public class EdicursoView
extends FrameView
implements UI {
    String currColor = "black";
    JFrame canvasFrame;
    public JTree actionTree;
    private JScrollPane actionPane;
    private JScrollPane textPane;
    public JToggleButton BtnAudioRec;
    private JMenuItem audioend;
    private JMenuItem backspace;
    private JPanel commands;
    private JMenuItem copy;
    private JMenuItem cut;
    private JMenuItem delete;
    private JSplitPane drawSequence;
    private JSplitPane hierSequence;
    private JMenu editMenu;
    private JFileChooser fileChooser;
    private JPanel drawPanel;
    private JPopupMenu.Separator jSeparator4;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    public JTextArea textArea;
    private JMenuItem newcourse;
    private JMenuItem o1024x768;
    private JMenuItem o1280x720;
    private JMenuItem o1280x1024;
    private JMenuItem o1680x1050;
    private JMenuItem o1920x1080;
    private JMenuItem open;
    private JMenuItem paste;
    public JToggleButton BtnPause;
    public JToggleButton BtnPlay;
    private JProgressBar progressBar;
    private JMenuItem save;
    private JMenuItem saveas;
    private JMenu sizeMenu;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    public JToggleButton BtnStop;
    private JMenu viewMenu;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;
    Sequencer sequencer;
    JMenu[] mainMenus;
    JPopupMenu popupMenu;
    boolean prevMenuBarState = true;
    boolean prevHierarchyState = true;
    boolean oldMenuBarState = true;
    boolean oldHierarchyState = true;
    boolean oldStatusBarState = true;
    int oldScrollX = 0;
    int oldScrollY = 0;
    private JMenu gridMenu;
    private JMenuItem gNone;
    private JMenuItem g8;
    private JMenuItem g11;
    private JMenuItem g16;
    private JMenuItem g22;
    private JMenuItem g32;
    private JMenuItem image;
    private JToggleButton BtnPenAudioRec;
    private JLabel lblTime;
    private JLabel lblTotal;
    private JMenuItem pause1second;
    private JMenuItem pauseBreak;
    private JCheckBoxMenuItem digitizer;
    private JToggleButton btnPen;
    private JMenuItem closeFrame;
    private static int frameCnt = 0;
    private boolean closed = false;
    private boolean isFullScreen = false;
    private JLabel lblNewLabel;
    private JLabel lblNewLabel_1;
    private JMenuItem leftMni;
    private JMenuItem rightMni;
    private JSeparator separator;
    private JMenuItem downMni;
    private JMenuItem upMni;
    private JMenuItem newWinMni;
    private JSeparator separator_1;
    private JMenuItem groupMni;
    private JMenuItem addGroupMni;
    private JMenuItem playMni;
    private JMenuItem Replay;
    private JMenuItem stopMni;
    private JSeparator separator_2;
    private JSeparator separator_3;
    private JScrollPane scrollPane;
    private JPanel whiteboard;
    private JMenuItem slideMni;
    private JMenuItem addSlideMni;
    private JMenuItem addUnrecorded;
    private JComboBox colorComboBox;
    private JComboBox strokeComboBox;
    private JButton eraserBtn;
    private JLabel label_1;
    private JLabel label_2;
    private JLabel label_3;
    private JCheckBoxMenuItem hierarchyMni;
    private JCheckBoxMenuItem statusBarMni;
    private JCheckBoxMenuItem fullScreenMni;
    private JCheckBoxMenuItem penFullAreaMni;
    private JCheckBoxMenuItem detachMni;
    private JMenu insertMenu;
    private JMenuItem penMni;
    private JMenuItem audioMni;
    private JMenuItem penAudioMni;
    private JCheckBoxMenuItem menuBarMni;
    private JPanel panel1;
    private JPanel panel2;
    private JLabel label_4;
    private JSlider slider;
    private JMenuItem eraserMni;
    private JMenu colorMn;
    private JMenu strokeMn;
    private JMenuItem oCurrent;
    private JMenuItem mntmScreenSize;
    private JSeparator separator_4;
    private JMenu pauseModeMn;
    private JRadioButtonMenuItem noneModeMni;
    private JRadioButtonMenuItem explicitModeMni;
    private JRadioButtonMenuItem slideModeMni;
    private JRadioButtonMenuItem leafModeMni;
    private final ButtonGroup pauseModeGroup = new ButtonGroup();
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuItem modifyDownMni;
    private JMenuItem modifyUpMni;
    private JMenu browseMenu;
    private JLabel label_5;
    private JMenuItem pageupMni;
    private JMenuItem pagedownMni;

    public EdicursoView(Application app) {
        super(app);
        ++frameCnt;
        this.initComponents();
        if (this.actionTree.getCellRenderer() instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.actionTree.getCellRenderer();
            renderer.setBackgroundNonSelectionColor(Drawer.bg);
            this.actionTree.setBackground(Drawer.bg);
        }
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = 5000;
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdicursoView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        int i = 0;
        while (i < this.busyIcons.length) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
            ++i;
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdicursoView.this.busyIconIndex = (EdicursoView.this.busyIconIndex + 1) % EdicursoView.this.busyIcons.length;
                EdicursoView.this.statusAnimationLabel.setIcon(EdicursoView.this.busyIcons[EdicursoView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!EdicursoView.this.busyIconTimer.isRunning()) {
                        EdicursoView.this.statusAnimationLabel.setIcon(EdicursoView.this.busyIcons[0]);
                        EdicursoView.this.busyIconIndex = 0;
                        EdicursoView.this.busyIconTimer.start();
                    }
                    EdicursoView.this.progressBar.setVisible(true);
                    EdicursoView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    EdicursoView.this.busyIconTimer.stop();
                    EdicursoView.this.statusAnimationLabel.setIcon(EdicursoView.this.idleIcon);
                    EdicursoView.this.progressBar.setVisible(false);
                    EdicursoView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    EdicursoView.this.statusMessageLabel.setText(text == null ? "" : text);
                    EdicursoView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    EdicursoView.this.progressBar.setVisible(true);
                    EdicursoView.this.progressBar.setIndeterminate(false);
                    EdicursoView.this.progressBar.setValue(value);
                }
            }
        });
        this.getApplication().addExitListener((Application.ExitListener)new ConfirmExit());
        ((JFrame)this.getFrame()).setDefaultCloseOperation(0);
        this.getFrame().addWindowListener(new ConfirmClose());
        this.initSequencer();
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            Frame mainFrame = this.getFrame();
            this.aboutBox = new AboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        CourseMakerApp.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newcourse = new JMenuItem();
        this.open = new JMenuItem();
        this.save = new JMenuItem();
        this.saveas = new JMenuItem();
        this.editMenu = new JMenu();
        this.cut = new JMenuItem();
        this.copy = new JMenuItem();
        this.paste = new JMenuItem();
        this.delete = new JMenuItem();
        this.backspace = new JMenuItem();
        this.viewMenu = new JMenu();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.fileChooser = new JFileChooser();
        this.mainPanel.setName("mainPanel");
        this.mainPanel.setLayout(new BorderLayout());
        this.panel1 = new JPanel();
        this.mainPanel.add((Component)this.panel1, "Center");
        this.panel1.setLayout(new CardLayout(0, 0));
        this.drawSequence = new JSplitPane();
        this.hierSequence = new JSplitPane(0);
        this.panel1.add((Component)this.drawSequence, "hierarchy");
        this.actionPane = new JScrollPane();
        this.actionTree = new JTree();
        this.actionTree.setForeground(new Color(0, 0, 0));
        this.actionTree.setBackground(Color.WHITE);
        this.textArea = new JTextArea();
        Font font = this.textArea.getFont();
        Font textFont = new Font(font.getFontName(), font.getStyle(), font.getSize() * 2);
        this.textArea.setFont(textFont);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.drawPanel = new JPanel();
        this.drawSequence.setName("drawSequence");
        this.actionPane.setMinimumSize(new Dimension(100, 100));
        this.actionPane.setName("actionTreePane");
        this.actionTree.setName("actionTree");
        this.actionPane.setViewportView(this.actionTree);
        this.textPane = new JScrollPane();
        this.textPane.setViewportView(this.textArea);
        this.textPane.setHorizontalScrollBarPolicy(31);
        this.drawSequence.setLeftComponent(this.hierSequence);
        this.hierSequence.setLeftComponent(this.actionPane);
        this.drawSequence.setResizeWeight(0.25);
        this.hierSequence.setRightComponent(this.textPane);
        this.hierSequence.setResizeWeight(0.75);
        this.drawPanel.setName("jPanel2");
        this.drawPanel.setLayout(new BorderLayout());
        this.slider = new JSlider();
        this.drawPanel.add((Component)this.slider, "South");
        this.scrollPane = new JScrollPane();
        this.drawPanel.add((Component)this.scrollPane, "Center");
        this.whiteboard = new JPanel();
        this.whiteboard.setMinimumSize(new Dimension(100, 100));
        this.whiteboard.setPreferredSize(new Dimension(100, 100));
        this.scrollPane.setViewportView(this.whiteboard);
        this.whiteboard.setLayout(new BorderLayout(0, 0));
        this.drawSequence.setRightComponent(this.drawPanel);
        this.panel2 = new JPanel();
        this.panel1.add((Component)this.panel2, "no_hierarchy");
        this.panel2.setLayout(new BorderLayout(0, 0));
        this.menuBar.setName("menuBar");
        this.fileMenu.setText("File");
        this.fileMenu.setName("fileMenu");
        this.newcourse.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.newcourse.setText("New");
        this.newcourse.setName("newcourse");
        this.newcourse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdicursoView.this.newcourseActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newcourse);
        this.open.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.open.setText("Open");
        this.open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdicursoView.this.openActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.open);
        this.save.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.save.setText("Save");
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdicursoView.this.saveActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.save);
        this.saveas.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.saveas.setText("Save as");
        this.saveas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdicursoView.this.saveasActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveas);
        ApplicationActionMap actionMap = ((CourseMakerApp)Application.getInstance(CourseMakerApp.class)).getContext().getActionMap(EdicursoView.class, (Object)this);
        this.menuBar.add(this.fileMenu);
        this.closeFrame = new JMenuItem("Close");
        this.closeFrame.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.closeFrame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EdicursoView.this.tryToClose();
            }
        });
        this.fileMenu.add(this.closeFrame);
        this.editMenu.setText("Edit");
        this.editMenu.setName("editMenu");
        this.cut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.cut.setText("cut");
        this.cut.setName("cut");
        this.cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdicursoView.this.cutActionPerformed(evt);
            }
        });
        this.editMenu.add(this.cut);
        this.copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copy.setText("copy");
        this.copy.setName("copy");
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdicursoView.this.copyActionPerformed(evt);
            }
        });
        this.editMenu.add(this.copy);
        this.paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.paste.setText("paste");
        this.paste.setName("paste");
        this.paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdicursoView.this.pasteActionPerformed(evt);
            }
        });
        this.editMenu.add(this.paste);
        this.jSeparator4 = new JPopupMenu.Separator();
        this.jSeparator4.setName("jSeparator4");
        this.editMenu.add(this.jSeparator4);
        this.digitizer = new JCheckBoxMenuItem("digitizer");
        this.digitizer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EdicursoView.this.sequencer.digitizer(EdicursoView.this.digitizer.getState());
            }
        });
        this.editMenu.add(this.digitizer);
        this.penMni = new JMenuItem("Pen");
        this.penMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EdicursoView.this.sequencer.penRecord();
            }
        });
        this.penMni.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.editMenu.add(this.penMni);
        this.audioMni = new JMenuItem("Audio");
        this.audioMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdicursoView.this.sequencer.audioCapture(true);
            }
        });
        this.audioMni.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.editMenu.add(this.audioMni);
        this.penAudioMni = new JMenuItem("Pen+Audio");
        this.penAudioMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdicursoView.this.sequencer.penAudioGroup(false);
            }
        });
        this.separator = new JSeparator();
        this.editMenu.add(this.separator);
        this.browseMenu = new JMenu("browse");
        this.editMenu.add(this.browseMenu);
        this.leftMni = new JMenuItem("left");
        this.browseMenu.add(this.leftMni);
        this.leftMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EdicursoView.this.sequencer.left();
            }
        });
        this.leftMni.setAccelerator(KeyStroke.getKeyStroke(37, 0));
        this.rightMni = new JMenuItem("right");
        this.browseMenu.add(this.rightMni);
        this.rightMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdicursoView.this.sequencer.right();
            }
        });
        this.rightMni.setAccelerator(KeyStroke.getKeyStroke(39, 0));
        this.downMni = new JMenuItem("down");
        this.browseMenu.add(this.downMni);
        this.downMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdicursoView.this.sequencer.move(1);
            }
        });
        this.downMni.setAccelerator(KeyStroke.getKeyStroke(40, 0));
        this.upMni = new JMenuItem("up");
        this.browseMenu.add(this.upMni);
        this.upMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EdicursoView.this.sequencer.move(-1);
            }
        });
        this.upMni.setAccelerator(KeyStroke.getKeyStroke(38, 0));
        this.modifyDownMni = new JMenuItem("modify down");
        this.browseMenu.add(this.modifyDownMni);
        this.modifyDownMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdicursoView.this.sequencer.secondaryMove(1);
            }
        });
        this.modifyDownMni.setAccelerator(KeyStroke.getKeyStroke(40, 1));
        this.modifyUpMni = new JMenuItem("modify up");
        this.browseMenu.add(this.modifyUpMni);
        this.modifyUpMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EdicursoView.this.sequencer.secondaryMove(-1);
            }
        });
        this.modifyUpMni.setAccelerator(KeyStroke.getKeyStroke(38, 1));
        this.pageupMni = new JMenuItem("page up");
        this.pageupMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EdicursoView.this.sequencer.pageUp();
            }
        });
        this.pagedownMni = new JMenuItem("page down");
        this.pagedownMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdicursoView.this.sequencer.pageDown();
            }
        });
        this.pagedownMni.setAccelerator(KeyStroke.getKeyStroke(34, 0));
        this.browseMenu.add(this.pagedownMni);
        this.pageupMni.setAccelerator(KeyStroke.getKeyStroke(33, 0));
        this.browseMenu.add(this.pageupMni);
        this.separator_1 = new JSeparator();
        this.editMenu.add(this.separator_1);
        this.delete.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.delete.setText("delete");
        this.delete.setName("delete");
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdicursoView.this.deleteActionPerformed(evt);
            }
        });
        this.label_5 = new JLabel(" ");
        this.editMenu.add(this.label_5);
        this.editMenu.add(this.delete);
        this.backspace.setAccelerator(KeyStroke.getKeyStroke(8, 0));
        this.backspace.setText("backspace");
        this.backspace.setName("backspace");
        this.backspace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdicursoView.this.backspaceActionPerformed(evt);
            }
        });
        this.editMenu.add(this.backspace);
        this.menuBar.add(this.editMenu);
        this.viewMenu.setText("View");
        this.viewMenu.setName("viewMenu");
        this.sizeMenu = new JMenu();
        this.oCurrent = new JMenuItem();
        this.oCurrent.setSelected(true);
        this.o1024x768 = new JMenuItem();
        this.o1280x720 = new JMenuItem();
        this.o1280x1024 = new JMenuItem();
        this.o1680x1050 = new JMenuItem();
        this.o1920x1080 = new JMenuItem();
        this.sizeMenu.setText("Size");
        this.sizeMenu.setName("sizeMenu");
        this.oCurrent.setText("canvas size");
        this.oCurrent.setName("oCurrent");
        this.oCurrent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdicursoView.this.oCurrentActionPerformed(evt);
            }
        });
        this.sizeMenu.add(this.oCurrent);
        this.o1024x768.setText("1024x768");
        this.o1024x768.setName("o1024x768");
        this.o1024x768.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdicursoView.this.o1024x768ActionPerformed(evt);
            }
        });
        this.o1280x720.setText("1280x720");
        this.o1280x720.setName("o1280x720");
        this.o1280x720.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdicursoView.this.o1280x720ActionPerformed(evt);
            }
        });
        this.mntmScreenSize = new JMenuItem("screen size");
        this.mntmScreenSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GraphicsConfiguration conf = EdicursoView.this.getFrame().getGraphicsConfiguration();
                GraphicsDevice dev = conf.getDevice();
                DisplayMode mode = dev.getDisplayMode();
                int devWidth = mode.getWidth();
                int devHeight = mode.getHeight();
                EdicursoView.this.sequencer.setSize(devWidth, devHeight);
            }
        });
        this.sizeMenu.add(this.mntmScreenSize);
        this.sizeMenu.add(this.o1024x768);
        this.o1280x1024.setText("1280x1024");
        this.o1280x1024.setName("o1280x1024");
        this.o1280x1024.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdicursoView.this.o1280x1024ActionPerformed(evt);
            }
        });
        this.sizeMenu.add(this.o1280x1024);
        this.o1680x1050.setText("1680x1050");
        this.o1680x1050.setName("o1680x1050");
        this.o1680x1050.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdicursoView.this.o1680x1050ActionPerformed(evt);
            }
        });
        this.sizeMenu.add(this.o1680x1050);
        this.o1920x1080.setText("1920x1080");
        this.o1920x1080.setName("o1920x1080");
        this.o1920x1080.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdicursoView.this.o1920x1080ActionPerformed(evt);
            }
        });
        this.playMni = new JMenuItem("Play");
        this.playMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EdicursoView.this.sequencer.play(true);
            }
        });
        this.playMni.setAccelerator(KeyStroke.getKeyStroke(10, 0));
        this.viewMenu.add(this.playMni);
        this.Replay = new JMenuItem("Replay");
        this.Replay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdicursoView.this.sequencer.replay();
            }
        });
        this.viewMenu.add(this.Replay);
        this.stopMni = new JMenuItem("Stop");
        this.stopMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdicursoView.this.sequencer.stop();
            }
        });
        this.insertMenu = new JMenu("Insert");
        this.menuBar.add(this.insertMenu);
        this.groupMni = new JMenuItem("make group");
        this.insertMenu.add(this.groupMni);
        this.groupMni.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.slideMni = new JMenuItem("make slide");
        this.insertMenu.add(this.slideMni);
        this.slideMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EdicursoView.this.sequencer.slide();
            }
        });
        this.slideMni.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.addGroupMni = new JMenuItem("add group");
        this.insertMenu.add(this.addGroupMni);
        this.addGroupMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EdicursoView.this.sequencer.addGroup();
            }
        });
        this.addSlideMni = new JMenuItem("add slide");
        this.insertMenu.add(this.addSlideMni);
        this.addSlideMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EdicursoView.this.sequencer.addSlide();
            }
        });
        this.addUnrecorded = new JMenuItem("add unrecorded audio");
        this.addUnrecorded.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.insertMenu.add(this.addUnrecorded);
        this.addUnrecorded.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdicursoView.this.sequencer.addUnrecorded();
            }
        });
        this.audioend = new JMenuItem();
        this.audioend.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.insertMenu.add(this.audioend);
        this.audioend.setText("audio end");
        this.audioend.setName("audioend");
        this.pause1second = new JMenuItem("1 second");
        this.insertMenu.add(this.pause1second);
        this.pauseBreak = new JMenuItem("break");
        this.insertMenu.add(this.pauseBreak);
        this.image = new JMenuItem("image");
        this.insertMenu.add(this.image);
        this.eraserMni = new JMenuItem("eraser");
        this.eraserMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EdicursoView.this.sequencer.eraser();
            }
        });
        this.colorMn = new JMenu("Color");
        this.insertMenu.add(this.colorMn);
        this.strokeMn = new JMenu("Stroke");
        this.insertMenu.add(this.strokeMn);
        this.insertMenu.add(this.eraserMni);
        this.image.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                boolean saveFullscreen = EdicursoView.this.setFullScreen(false);
                try {
                    if (EdicursoView.this.fileChooser.showOpenDialog(EdicursoView.this.mainPanel) != 0) {
                        return;
                    }
                    File file = EdicursoView.this.fileChooser.getSelectedFile();
                    if (file != null) {
                        EdicursoView.this.sequencer.image(file);
                    }
                }
                finally {
                    EdicursoView.this.setFullScreen(saveFullscreen);
                }
            }
        });
        this.pauseBreak.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdicursoView.this.sequencer.pauseBreak();
            }
        });
        this.pause1second.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EdicursoView.this.sequencer.pause1second(1000);
            }
        });
        this.audioend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdicursoView.this.audioendActionPerformed(evt);
            }
        });
        this.groupMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdicursoView.this.sequencer.group();
            }
        });
        this.stopMni.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        this.viewMenu.add(this.stopMni);
        this.separator_2 = new JSeparator();
        this.viewMenu.add(this.separator_2);
        this.sizeMenu.add(this.o1920x1080);
        this.viewMenu.add(this.sizeMenu);
        this.menuBar.add(this.viewMenu);
        this.gridMenu = new JMenu("Grid");
        this.viewMenu.add(this.gridMenu);
        this.gNone = new JMenuItem("none");
        this.gNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EdicursoView.this.sequencer.setGrid(0);
            }
        });
        this.gridMenu.add(this.gNone);
        this.g8 = new JMenuItem("8");
        this.g8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdicursoView.this.sequencer.setGrid(8);
            }
        });
        this.gridMenu.add(this.g8);
        this.g11 = new JMenuItem("11");
        this.g11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdicursoView.this.sequencer.setGrid(11);
            }
        });
        this.gridMenu.add(this.g11);
        this.g16 = new JMenuItem("16");
        this.g16.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdicursoView.this.sequencer.setGrid(16);
            }
        });
        this.gridMenu.add(this.g16);
        this.g22 = new JMenuItem("22");
        this.g22.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdicursoView.this.sequencer.setGrid(22);
            }
        });
        this.gridMenu.add(this.g22);
        this.g32 = new JMenuItem("32");
        this.g32.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdicursoView.this.sequencer.setGrid(32);
            }
        });
        this.gridMenu.add(this.g32);
        this.newWinMni = new JMenuItem("New window");
        this.newWinMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!EdicursoView.this.isFullScreen) {
                    EdicursoView.this.sequencer.newWindow();
                } else {
                    EdicursoView.this.setFullScreen(false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            (this).EdicursoView.this.sequencer.newWindow();
                        }
                    });
                }
            }
        });
        this.hierarchyMni = new JCheckBoxMenuItem("Hierarchy");
        this.hierarchyMni.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.hierarchyMni.setSelected(true);
        this.hierarchyMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EdicursoView.this.setHierarchy(EdicursoView.this.hierarchyMni.isSelected());
            }
        });
        this.fullScreenMni = new JCheckBoxMenuItem("Full screen");
        this.fullScreenMni.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.fullScreenMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EdicursoView.this.setFullScreen(EdicursoView.this.fullScreenMni.getState());
            }
        });
        this.penFullAreaMni = new JCheckBoxMenuItem("Pen full fcreen");
        this.detachMni = new JCheckBoxMenuItem("Detach canvas");
        this.detachMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg) {
                EdicursoView.this.detachCanvas();
            }
        });
        this.pauseModeMn = new JMenu("Pause mode");
        this.viewMenu.add(this.pauseModeMn);
        this.noneModeMni = new JRadioButtonMenuItem("none");
        this.pauseModeGroup.add(this.noneModeMni);
        this.pauseModeMn.add(this.noneModeMni);
        this.explicitModeMni = new JRadioButtonMenuItem("explicit");
        this.pauseModeGroup.add(this.explicitModeMni);
        this.pauseModeMn.add(this.explicitModeMni);
        this.slideModeMni = new JRadioButtonMenuItem("slide");
        this.pauseModeGroup.add(this.slideModeMni);
        this.pauseModeMn.add(this.slideModeMni);
        this.leafModeMni = new JRadioButtonMenuItem("leaf");
        this.pauseModeGroup.add(this.leafModeMni);
        this.leafModeMni.setSelected(true);
        this.pauseModeMn.add(this.leafModeMni);
        this.separator_4 = new JSeparator();
        this.viewMenu.add(this.separator_4);
        this.viewMenu.add(this.fullScreenMni);
        this.viewMenu.add(this.penFullAreaMni);
        this.viewMenu.add(this.detachMni);
        this.menuBarMni = new JCheckBoxMenuItem("Menu bar");
        this.menuBarMni.setSelected(true);
        this.menuBarMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EdicursoView.this.setMenuBar(EdicursoView.this.menuBarMni.isSelected());
            }
        });
        this.menuBarMni.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.viewMenu.add(this.menuBarMni);
        this.viewMenu.add(this.hierarchyMni);
        this.statusBarMni = new JCheckBoxMenuItem("Status bar");
        this.statusBarMni.setSelected(true);
        this.statusBarMni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EdicursoView.this.statusPanel.setVisible(EdicursoView.this.statusBarMni.isSelected());
            }
        });
        this.viewMenu.add(this.statusBarMni);
        this.separator_3 = new JSeparator();
        this.viewMenu.add(this.separator_3);
        this.viewMenu.add(this.newWinMni);
        this.helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.helpMenu.setText("Help");
        this.helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        this.helpMenu.add(aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout gl_statusPanel = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(gl_statusPanel);
        gl_statusPanel.setHorizontalGroup(gl_statusPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 615, Short.MAX_VALUE).addGroup(gl_statusPanel.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 445, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        gl_statusPanel.setVerticalGroup(gl_statusPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_statusPanel.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(gl_statusPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.fileChooser.setName("fileChooser");
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.label_4 = new JLabel(" ");
        this.menuBar.add(this.label_4);
        this.commands = new JPanel();
        this.menuBar.add(this.commands);
        this.BtnPause = new JToggleButton();
        this.BtnStop = new JToggleButton();
        this.BtnAudioRec = new JToggleButton();
        this.BtnAudioRec.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (EdicursoView.this.BtnAudioRec.isEnabled()) {
                    EdicursoView.this.sequencer.audioCapture(true);
                }
            }
        });
        this.commands.setMinimumSize(new Dimension(179, 100));
        this.commands.setName("commands");
        this.commands.setLayout(new FlowLayout(0));
        this.BtnPause.setText("Pause");
        this.BtnPause.setMinimumSize(new Dimension(20, 0));
        this.BtnPause.setName("pause");
        this.BtnPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdicursoView.this.pauseActionPerformed(evt);
            }
        });
        this.BtnPlay = new JToggleButton();
        this.commands.add(this.BtnPlay);
        this.BtnPlay.setText("Play");
        this.BtnPlay.setMinimumSize(new Dimension(20, 0));
        this.BtnPlay.setName("play");
        this.BtnPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdicursoView.this.playActionPerformed(evt);
            }
        });
        this.commands.add(this.BtnPause);
        this.BtnStop.setText("Stop");
        this.BtnStop.setMinimumSize(new Dimension(20, 0));
        this.BtnStop.setName("stop");
        this.BtnStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdicursoView.this.stopActionPerformed(evt);
            }
        });
        this.commands.add(this.BtnStop);
        this.lblNewLabel = new JLabel(" ");
        this.commands.add(this.lblNewLabel);
        this.lblTime = new JLabel("00:00");
        this.commands.add(this.lblTime);
        JLabel lblSep = new JLabel("/");
        this.commands.add(lblSep);
        this.lblTotal = new JLabel("00:00");
        this.commands.add(this.lblTotal);
        this.BtnAudioRec.setForeground(new Color(255, 0, 0));
        this.BtnAudioRec.setText("Audio");
        this.BtnAudioRec.setMinimumSize(new Dimension(20, 0));
        this.BtnAudioRec.setName("audioRec");
        this.BtnAudioRec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EdicursoView.this.audioRecActionPerformed(evt);
            }
        });
        this.btnPen = new JToggleButton("Pen");
        this.btnPen.setForeground(Color.RED);
        this.btnPen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdicursoView.this.sequencer.penRecord();
            }
        });
        this.lblNewLabel_1 = new JLabel(" ");
        this.commands.add(this.lblNewLabel_1);
        this.commands.add(this.btnPen);
        this.commands.add(this.BtnAudioRec);
        this.BtnPenAudioRec = new JToggleButton("Pen+Audio");
        this.BtnPenAudioRec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdicursoView.this.sequencer.penAudioGroup(false);
            }
        });
        this.BtnPenAudioRec.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (EdicursoView.this.BtnPenAudioRec.isEnabled()) {
                    EdicursoView.this.sequencer.penAudioGroup(true);
                }
            }
        });
        this.BtnPenAudioRec.setForeground(Color.RED);
        JLabel label = new JLabel(" ");
        this.commands.add(label);
        this.colorComboBox = new JComboBox();
        this.colorComboBox.setBackground(new Color(238, 238, 238));
        this.colorComboBox.setSize(new Dimension(40, 20));
        this.colorComboBox.setForeground(Color.BLUE);
        this.colorComboBox.setPreferredSize(new Dimension(40, 20));
        this.colorComboBox.setMinimumSize(new Dimension(40, 20));
        this.commands.add(this.colorComboBox);
        this.label_2 = new JLabel(" ");
        this.commands.add(this.label_2);
        this.strokeComboBox = new JComboBox();
        this.strokeComboBox.setForeground(Color.BLUE);
        this.strokeComboBox.setPreferredSize(new Dimension(50, 20));
        this.strokeComboBox.setMinimumSize(new Dimension(50, 20));
        this.commands.add(this.strokeComboBox);
        this.eraserBtn = new JButton("ER");
        this.eraserBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EdicursoView.this.sequencer.eraser();
            }
        });
        this.label_3 = new JLabel(" ");
        this.commands.add(this.label_3);
        this.commands.add(this.eraserBtn);
        this.label_1 = new JLabel(" ");
        this.commands.add(this.label_1);
        this.colorComboBox.setPopupVisible(false);
        this.setStatusBar(this.statusPanel);
    }

    private void playActionPerformed(ActionEvent evt) {
        this.sequencer.play(false);
    }

    private void stopActionPerformed(ActionEvent evt) {
        this.sequencer.stop();
    }

    private void saveasActionPerformed(ActionEvent evt) {
        this.saveAs();
    }

    private int yesNoCancel(String str) {
        Object[] options = new Object[]{"Yes", "No", "Cancel"};
        int ret = JOptionPane.showOptionDialog(this.mainPanel, str, "Edicurso", 1, 3, null, options, options[2]);
        return ret;
    }

    @Override
    public void alert(String msg) {
        boolean saveFullscreen = this.setFullScreen(false);
        JOptionPane.showMessageDialog(null, msg, "Alert!", 0);
        this.setFullScreen(saveFullscreen);
    }

    boolean canDiscard() {
        boolean approved = false;
        if (this.sequencer.getModel().isClean()) {
            approved = true;
        } else {
            boolean saveFullscreen = this.setFullScreen(false);
            try {
                int n = this.yesNoCancel("The presentation has not been saved.  Save it?");
                if (n == 0) {
                    approved = this.tryToSave();
                } else if (n == 1) {
                    approved = true;
                }
            }
            finally {
                this.setFullScreen(saveFullscreen);
            }
        }
        return approved;
    }

    public boolean setFullScreen(boolean flag) {
        boolean prevIsFullScreen = this.isFullScreen;
        if (flag == this.isFullScreen) {
            return this.isFullScreen;
        }
        Frame frame = this.canvasFrame != null ? this.canvasFrame : this.getFrame();
        GraphicsConfiguration conf = frame.getGraphicsConfiguration();
        GraphicsDevice dev = conf.getDevice();
        System.out.println("set full screen " + flag + " supported: " + dev.isFullScreenSupported());
        if (flag) {
            frame.setVisible(false);
            frame.dispose();
            frame.setUndecorated(true);
            frame.setExtendedState(frame.getExtendedState() | 6);
            frame.setVisible(true);
            this.isFullScreen = true;
        } else {
            frame.setVisible(false);
            frame.dispose();
            frame.setUndecorated(false);
            frame.setVisible(true);
            this.isFullScreen = false;
        }
        this.fullScreenMni.setSelected(this.isFullScreen);
        return prevIsFullScreen;
    }

    private void detachCanvas() {
        boolean detachState;
        if (this.canvasFrame != null == (detachState = this.detachMni.isSelected())) {
            return;
        }
        if (this.isFullScreen) {
            this.setFullScreen(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EdicursoView.this.detachCanvas();
                }
            });
            return;
        }
        if (this.canvasFrame == null) {
            this.setMenuBar(true);
            this.setHierarchy(true);
            this.statusPanel.setVisible(true);
            this.drawSequence.remove(this.hierSequence);
            this.panel2.add((Component)this.hierSequence, "Center");
            this.drawPanel.remove(this.slider);
            this.panel2.add((Component)this.slider, "South");
            this.canvasFrame = new JFrame("Edicurso");
            this.canvasFrame.setDefaultCloseOperation(0);
            this.canvasFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent ev) {
                    System.out.println("window closing");
                    EdicursoView.this.detachMni.setSelected(false);
                    EdicursoView.this.detachCanvas();
                }
            });
            this.drawPanel.remove(this.scrollPane);
            this.canvasFrame.add(this.scrollPane);
            this.canvasFrame.setSize(this.getFrame().getWidth(), this.getFrame().getHeight());
            this.canvasFrame.setVisible(true);
            CardLayout cardLayout = (CardLayout)this.panel1.getLayout();
            cardLayout.show(this.panel1, "no_hierarchy");
        } else {
            this.panel2.remove(this.hierSequence);
            this.drawSequence.setLeftComponent(this.hierSequence);
            this.panel2.remove(this.slider);
            this.drawPanel.add((Component)this.slider, "South");
            this.canvasFrame.remove(this.scrollPane);
            this.drawPanel.add((Component)this.scrollPane, "Center");
            this.canvasFrame.setVisible(false);
            this.canvasFrame.dispose();
            CardLayout cardLayout = (CardLayout)this.panel1.getLayout();
            cardLayout.show(this.panel1, "hierarchy");
            this.canvasFrame = null;
        }
        this.detachMni.setSelected(this.canvasFrame != null);
        this.penFullAreaMni.setEnabled(this.canvasFrame == null);
        this.getFrame().revalidate();
        this.getFrame().pack();
    }

    private void openActionPerformed(ActionEvent evt) {
        boolean saveFullscreen = this.setFullScreen(false);
        try {
            if (!this.canDiscard()) {
                return;
            }
            if (this.fileChooser.showOpenDialog(this.mainPanel) != 0) {
                return;
            }
            File file = this.fileChooser.getSelectedFile();
            this.sequencer.open(file);
        }
        finally {
            this.setFullScreen(saveFullscreen);
        }
    }

    private void newcourseActionPerformed(ActionEvent evt) {
        if (this.canDiscard()) {
            this.sequencer.newcourse();
        }
    }

    private void saveActionPerformed(ActionEvent evt) {
        if (!this.isFullScreen) {
            this.tryToSave();
        } else {
            this.setFullScreen(false);
            this.fullScreenMni.setState(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EdicursoView.this.tryToSave();
                }
            });
        }
    }

    private void copyActionPerformed(ActionEvent evt) {
        this.sequencer.copy();
    }

    private void pasteActionPerformed(ActionEvent evt) {
        this.sequencer.paste();
    }

    private void cutActionPerformed(ActionEvent evt) {
        this.sequencer.cut();
    }

    private void audioRecActionPerformed(ActionEvent evt) {
        this.sequencer.audioCapture(false);
    }

    private void pauseActionPerformed(ActionEvent evt) {
        this.sequencer.pause();
    }

    private void deleteActionPerformed(ActionEvent evt) {
        this.sequencer.delete();
    }

    private void backspaceActionPerformed(ActionEvent evt) {
        this.sequencer.back();
    }

    private void audioendActionPerformed(ActionEvent evt) {
        this.sequencer.audioEnd(evt.getWhen());
    }

    private void o1024x768ActionPerformed(ActionEvent evt) {
        this.sequencer.setSize(1024, 768);
    }

    private void o1280x720ActionPerformed(ActionEvent evt) {
        this.sequencer.setSize(1280, 720);
    }

    private void o1280x1024ActionPerformed(ActionEvent evt) {
        this.sequencer.setSize(1280, 1024);
    }

    private void o1680x1050ActionPerformed(ActionEvent evt) {
        this.sequencer.setSize(1680, 1050);
    }

    private void o1920x1080ActionPerformed(ActionEvent evt) {
        this.sequencer.setSize(1920, 1080);
    }

    private void oCurrentActionPerformed(ActionEvent evt) {
        Insets insets = this.scrollPane.getInsets();
        int width = this.scrollPane.getWidth() - insets.left - insets.right;
        int height = this.scrollPane.getHeight() - insets.top - insets.bottom;
        this.sequencer.setSize(width, height);
    }

    public Sequencer getSequencer() {
        return this.sequencer;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public final void initSequencer() {
        this.actionTree.setShowsRootHandles(true);
        this.mainMenus = new JMenu[]{this.fileMenu, this.editMenu, this.insertMenu, this.viewMenu, this.helpMenu};
        this.popupMenu = new JPopupMenu();
        this.sequencer = new Sequencer(this);
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                EdicursoView.this.sequencer.rename(EdicursoView.this.textArea.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                EdicursoView.this.sequencer.rename(EdicursoView.this.textArea.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EdicursoView.this.sequencer.rename(EdicursoView.this.textArea.getText());
            }
        });
    }

    void move(JMenu[] menus, JComponent from, JComponent to) {
        JMenu[] jMenuArray = menus;
        int n = menus.length;
        int n2 = 0;
        while (n2 < n) {
            JMenu menu = jMenuArray[n2];
            from.remove(menu);
            to.add(menu);
            ++n2;
        }
    }

    void copy(JMenu[] menus, JComponent to) {
        JMenu[] jMenuArray = menus;
        int n = menus.length;
        int n2 = 0;
        while (n2 < n) {
            JMenu menu = jMenuArray[n2];
            to.add(menu);
            ++n2;
        }
    }

    void setMenuBar(boolean flag) {
        if (this.prevMenuBarState == flag) {
            return;
        }
        this.prevMenuBarState = flag;
        if (flag) {
            this.move(this.mainMenus, this.popupMenu, this.menuBar);
            this.menuBar.add(this.commands);
            this.menuBar.setVisible(true);
        } else {
            this.menuBar.setVisible(false);
            this.move(this.mainMenus, this.menuBar, this.popupMenu);
            this.menuBar.remove(this.commands);
        }
        this.getFrame().requestFocus();
    }

    void setHierarchy(boolean flag) {
        if (this.prevHierarchyState == flag) {
            return;
        }
        this.prevHierarchyState = flag;
        CardLayout cardLayout = (CardLayout)this.panel1.getLayout();
        if (flag) {
            this.panel2.remove(this.scrollPane);
            this.drawPanel.add((Component)this.scrollPane, "Center");
            cardLayout.show(this.panel1, "hierarchy");
        } else {
            this.drawPanel.remove(this.scrollPane);
            this.panel2.add((Component)this.scrollPane, "Center");
            cardLayout.show(this.panel1, "no_hierarchy");
        }
    }

    @Override
    public void drivePenFullArea(boolean flag) {
        if (this.canvasFrame != null) {
            return;
        }
        final JScrollBar xbar = this.scrollPane.getHorizontalScrollBar();
        final JScrollBar ybar = this.scrollPane.getVerticalScrollBar();
        if (flag) {
            this.oldMenuBarState = this.menuBarMni.isSelected();
            this.oldHierarchyState = this.hierarchyMni.isSelected();
            this.oldStatusBarState = this.statusBarMni.isSelected();
            this.oldScrollX = xbar.getValue();
            this.oldScrollY = ybar.getValue();
            if (this.penFullAreaMni.isSelected()) {
                if (!this.isFullScreen) {
                    this.setFullScreen(true);
                }
                this.menuBarMni.setSelected(false);
                this.hierarchyMni.setSelected(false);
                this.statusBarMni.setSelected(false);
                this.setMenuBar(false);
                this.setHierarchy(false);
                this.statusPanel.setVisible(false);
            }
        } else {
            this.menuBarMni.setSelected(this.oldMenuBarState);
            this.hierarchyMni.setSelected(this.oldHierarchyState);
            this.statusBarMni.setSelected(this.oldStatusBarState);
            this.setMenuBar(this.oldMenuBarState);
            this.setHierarchy(this.oldHierarchyState);
            this.statusPanel.setVisible(this.oldStatusBarState);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    xbar.setValue(EdicursoView.this.oldScrollX);
                    ybar.setValue(EdicursoView.this.oldScrollY);
                }
            });
        }
    }

    @Override
    public JTextArea getTextArea() {
        return this.textArea;
    }

    @Override
    public JSlider getSlider() {
        return this.slider;
    }

    @Override
    public JToggleButton getBtnPlay() {
        return this.BtnPlay;
    }

    @Override
    public JToggleButton getBtnPause() {
        return this.BtnPause;
    }

    @Override
    public JToggleButton getBtnStop() {
        return this.BtnStop;
    }

    @Override
    public JToggleButton getBtnAudioRec() {
        return this.BtnAudioRec;
    }

    @Override
    public JToggleButton getBtnPenAudioRec() {
        return this.BtnPenAudioRec;
    }

    @Override
    public JToggleButton getBtnPen() {
        return this.btnPen;
    }

    @Override
    public JTree getActionTree() {
        return this.actionTree;
    }

    @Override
    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Override
    public JPanel getWhiteboard() {
        return this.whiteboard;
    }

    @Override
    public JMenu getEditMenu() {
        return this.editMenu;
    }

    @Override
    public JLabel getLblTime() {
        return this.lblTime;
    }

    @Override
    public JLabel getLblTotal() {
        return this.lblTotal;
    }

    @Override
    public JCheckBoxMenuItem getDigitizer() {
        return this.digitizer;
    }

    boolean tryToSave() {
        if (this.sequencer.getFileName() != null) {
            return this.sequencer.compress();
        }
        return this.saveAs();
    }

    boolean saveAs() {
        boolean saveFullscreen = this.setFullScreen(false);
        try {
            int status = this.fileChooser.showOpenDialog(this.mainPanel);
            if (status != 0) {
                return false;
            }
            File file = this.fileChooser.getSelectedFile();
            if (file.exists()) {
                Object[] options = new Object[]{"Yes", "No"};
                int answer = JOptionPane.showOptionDialog(this.mainPanel, "File " + file.getName() + " exists.  Overwrite it?", "Edicurso", 0, 3, null, options, options[1]);
                if (answer == 1) {
                    return false;
                }
            }
            boolean bl = this.sequencer.saveAs(file);
            return bl;
        }
        finally {
            this.setFullScreen(saveFullscreen);
        }
    }

    void tryToClose() {
        boolean approved = false;
        if (this.sequencer.getModel().isClean()) {
            approved = true;
        } else {
            boolean saveFullscreen = this.setFullScreen(false);
            try {
                int n = this.yesNoCancel("The presentation has not been saved.  Save it?");
                if (n == 0) {
                    approved = this.tryToSave();
                } else if (n == 1) {
                    approved = true;
                }
            }
            finally {
                if (!approved) {
                    this.setFullScreen(saveFullscreen);
                }
            }
        }
        if (approved) {
            this.sequencer.stop();
            this.sequencer = null;
            this.getFrame().dispose();
            if (--frameCnt == 0) {
                this.getApplication().exit();
            }
        }
    }

    @Override
    public JComboBox getColorComboBox() {
        return this.colorComboBox;
    }

    @Override
    public JComboBox getStrokeComboBox() {
        return this.strokeComboBox;
    }

    @Override
    public JButton getEraserBtn() {
        return this.eraserBtn;
    }

    @Override
    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    @Override
    public JCheckBoxMenuItem getMenuBarMni() {
        return this.menuBarMni;
    }

    @Override
    public JMenu getColorMn() {
        return this.colorMn;
    }

    @Override
    public JMenu getStrokeMn() {
        return this.strokeMn;
    }

    @Override
    public JCheckBoxMenuItem getHierarchyMni() {
        return this.hierarchyMni;
    }

    @Override
    public JCheckBoxMenuItem getStatusBarMni() {
        return this.statusBarMni;
    }

    @Override
    public JRadioButtonMenuItem getNoneModeMni() {
        return this.noneModeMni;
    }

    @Override
    public JRadioButtonMenuItem getExplicitModeMni() {
        return this.explicitModeMni;
    }

    @Override
    public JRadioButtonMenuItem getSlideModeMni() {
        return this.slideModeMni;
    }

    @Override
    public JRadioButtonMenuItem getLeafModeMni() {
        return this.leafModeMni;
    }

    @Override
    public JLabel getStatusMessageLabel() {
        return this.statusMessageLabel;
    }

    class ConfirmClose
    extends WindowAdapter {
        ConfirmClose() {
        }

        @Override
        public void windowClosing(WindowEvent ev) {
            EdicursoView.this.tryToClose();
        }

        @Override
        public void windowClosed(WindowEvent ev) {
            if (!EdicursoView.this.closed) {
                EdicursoView.this.closed = true;
            }
        }
    }

    class ConfirmExit
    implements Application.ExitListener {
        ConfirmExit() {
        }

        public boolean canExit(EventObject evt) {
            return frameCnt == 0;
        }

        public void willExit(EventObject evt) {
        }
    }
}

