/*
 * Decompiled with CFR 0.152.
 */
package edicurso;

import edicurso.Drawer;
import edicurso.Sequencer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.ListCellRenderer;

public class ColorBoxRenderer
extends JLabel
implements ListCellRenderer,
ActionListener {
    public static final int IMGWIDTH = 34;
    public static final int IMGHEIGHT = 16;
    static HashMap<Color, Integer> colorMap = new HashMap();
    static String[] names = new String[]{"black", "red", "blue", "green", "yellow", "magenta", "orange", "cyan", "white", "background"};
    static Color[] colors = new Color[names.length];
    public static Icon[] icons = new Icon[names.length];
    public static Image[] images = new Image[names.length];
    JComboBox comboBox;
    Sequencer seq;
    private boolean userChange = true;

    static {
        colorMap.put(Color.black, new Integer(0));
        colorMap.put(Color.red, new Integer(1));
        colorMap.put(Color.blue, new Integer(2));
        colorMap.put(new Color(0, 128, 0), new Integer(3));
        colorMap.put(Color.yellow, new Integer(4));
        colorMap.put(Color.magenta, new Integer(5));
        colorMap.put(Color.orange, new Integer(6));
        colorMap.put(Color.cyan, new Integer(7));
        colorMap.put(Color.white, new Integer(8));
        colorMap.put(Drawer.bg, new Integer(9));
        for (Color c : colorMap.keySet()) {
            int idx = colorMap.get(c);
            ColorBoxRenderer.colors[idx] = c;
        }
        int idx = 0;
        while (idx < names.length) {
            BufferedImage img = new BufferedImage(34, 16, 1);
            ColorBoxRenderer.images[idx] = img;
            Color c = colors[idx];
            Graphics2D g = (Graphics2D)img.getGraphics();
            g.setBackground(c);
            g.clearRect(0, 0, 34, 16);
            ColorBoxRenderer.icons[idx] = new ImageIcon(img);
            ++idx;
        }
    }

    public static Color getColor(String name) {
        int idx = 0;
        while (idx < names.length) {
            if (name.equals(names[idx])) {
                return colors[idx];
            }
            ++idx;
        }
        return null;
    }

    public ColorBoxRenderer(Sequencer seq) {
        this.seq = seq;
        this.comboBox = seq.getUi().getColorComboBox();
        int i = 0;
        while (i < colors.length) {
            this.comboBox.addItem(new Integer(i));
            ++i;
        }
        this.setPreferredSize(new Dimension(34, 16));
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.comboBox.setSelectedIndex(0);
        this.comboBox.addActionListener(this);
        this.comboBox.setBackground(Color.white);
        this.comboBox.setForeground(Color.white);
        this.comboBox.setMaximumRowCount(colors.length);
        JMenu colorMn = seq.getUi().getColorMn();
        int idx = 0;
        while (idx < colors.length) {
            final int mniId = idx;
            JMenuItem mni = new JMenuItem(icons[idx]);
            Icon icon = icons[idx];
            mni.setPreferredSize(new Dimension(icon.getIconWidth() + 2, icon.getIconHeight() + 2));
            mni.setIconTextGap(-5);
            colorMn.add(mni);
            mni.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColorBoxRenderer.this.seq.setColor(names[mniId], colors[mniId]);
                }
            });
            ++idx;
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        int idx = (Integer)value;
        this.setIcon(icons[idx]);
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (this.userChange) {
            JComboBox comboBox = (JComboBox)ev.getSource();
            int idx = comboBox.getSelectedIndex();
            this.seq.setColor(names[idx], colors[idx]);
        }
    }

    public void updateSelection(Color color) {
        Integer idxInt = colorMap.get(color);
        if (idxInt != null) {
            try {
                this.userChange = false;
                this.comboBox.setSelectedIndex(idxInt);
            }
            finally {
                this.userChange = true;
            }
        }
    }
}

