/*
 * Decompiled with CFR 0.152.
 */
package edicurso;

import edicurso.CaptureManager;
import edicurso.Log;
import edicurso.Player;
import edicurso.Scheduler;
import edicurso.Task;
import edicurso.Visitor;
import edicurso.operations.AudioClip;
import edicurso.operations.AudioNode;
import edicurso.operations.AudioSync;
import edicurso.operations.Composite;
import edicurso.operations.EndAudioClip;
import edicurso.operations.Node;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class AudioManager {
    public static final int PLAY_CHOP = 10;
    public static final int PLAY_FADE = 60;
    static final int BUFSIZE = 4096;
    public static final Finder finder = new Finder();
    Coalescer coalescer = new Coalescer();
    Node.VirtualDelayVisitor delayVis = new Node.VirtualDelayVisitor();
    boolean finished = false;
    boolean active = true;
    PlayTask playTask = new PlayTask();
    Object monitor = new Object();
    AudioClip currClip = null;
    int endTime;
    Set<AudioClip> coalesceClips = new HashSet<AudioClip>();
    private static AudioManager audioManager = new AudioManager();

    private AudioManager() {
        this.playTask.start();
    }

    public static AudioManager getAudioManager() {
        return audioManager;
    }

    public boolean wasCoalesced(AudioClip clip) {
        return this.coalesceClips.contains(clip);
    }

    public void setAudioClip(AudioClip clip) {
        this.currClip = clip;
        this.coalesceClips.remove(clip);
    }

    public final AudioClip currentAudioClip() {
        return this.currClip;
    }

    public final void abort() {
        this.playTask.abort();
        this.coalesceClips.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown() {
        this.playTask.abort();
        Object object = this.monitor;
        synchronized (object) {
            this.finished = true;
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        Object object = this.monitor;
        synchronized (object) {
            this.active = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void play() {
        Object object = this.monitor;
        synchronized (object) {
            this.active = true;
            this.monitor.notifyAll();
        }
    }

    public void waitPlaying(Player player) {
        while (this.playTask.isPlaying()) {
            player.waitNextFrame();
        }
        this.currClip = null;
        this.coalesceClips.clear();
    }

    public void waitClip(AudioNode audioNode, Player player) {
        int elapsed = 0;
        if (audioNode == null) {
            System.out.println("waiting audio clip of labeled group");
        } else {
            System.out.println("waiting " + audioNode.toString() + " for " + audioNode.getSyncTime() + " at " + this.playTask.getElapsedTime());
        }
        int limit = audioNode == null ? Integer.MAX_VALUE : audioNode.getSyncTime();
        while (this.playTask.isPlaying()) {
            elapsed = this.playTask.getElapsedTime();
            if (elapsed < 0 || elapsed >= limit) break;
            player.waitNextFrame();
        }
        if (audioNode == null) {
            Task.setZoom(Scheduler.getScheduler().getDefaultZoom());
        }
        System.out.println("waitClip finished with elapsed= " + elapsed);
    }

    public final void startPlay(Node from) {
        if (this.currClip == null || from instanceof EndAudioClip) {
            this.currClip = null;
            return;
        }
        AudioNode prevSync = this.coalescer.coalesce(this.currClip, from, this.coalesceClips, true);
        finder.findAudioNode(prevSync, from);
        Node found = finder.getNextNode();
        assert (found == from);
        int skipVirtualDelay = finder.virtualDelay;
        int prevTime = prevSync.getSyncTime() - this.currClip.getSyncTime();
        double zoom = prevSync.getZoom();
        Task.setZoom(zoom);
        int skipTime = (int)((double)skipVirtualDelay * zoom) + prevTime;
        System.out.println("Coalesced time: " + this.coalescer.getAudioTime() + " millis, skipping " + skipTime);
        try {
            this.active = true;
            this.playTask.startPlaying(skipTime, this.currClip.getSyncTime(), this.coalescer.audioData);
        }
        catch (Scheduler.AbortException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.error(e.toString());
        }
    }

    public final void playCoalesced(AudioNode audioNode) {
        finder.findAudioNode(audioNode);
        int virtualDelay = finder.virtualDelay;
        int realDelay = audioNode.getNextDelay();
        if (realDelay > 0 && virtualDelay > 0) {
            Task.setZoom((double)realDelay / (double)virtualDelay);
        } else {
            Task.setZoom(0.0);
        }
        System.out.println("play coalesced, realDelay= " + realDelay + " virtualDelay= " + virtualDelay);
    }

    public static int audioRead(InputStream stream, byte[] buf, int nbytes) {
        int cnt = 0;
        try {
            int rc;
            while ((rc = stream.read(buf, cnt, nbytes - cnt)) >= 0 && (cnt += rc) < nbytes) {
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return cnt;
    }

    public void annotate(Node rootNode) {
        boolean success = finder.findAudioNode(rootNode);
        Node curr = finder.getNextNode();
        while (curr != null) {
            if (!success || !(curr instanceof AudioClip)) {
                success = finder.findAudioNode(curr);
            } else {
                AudioClip startClip;
                AudioNode prev = startClip = (AudioClip)curr;
                startClip.transientCoalesced(false);
                int audioTime = startClip.getTime() - 20 - 60;
                int prevSyncTime = 0;
                prev.transientSyncTime(0);
                success = finder.findAudioNode(curr);
                int prevVirtualDelay = finder.virtualDelay;
                boolean coalesced = true;
                while (coalesced && success) {
                    int currSyncTime;
                    AudioNode currAudioNode = finder.getAudioNode();
                    if (currAudioNode == null) break;
                    if (currAudioNode instanceof AudioClip) {
                        AudioClip clip = (AudioClip)currAudioNode;
                        clip.transientCoalesced(true);
                        currSyncTime = audioTime;
                        audioTime += clip.getTime() - 20 - 60;
                        success = finder.findAudioNode(currAudioNode);
                    } else if (!(currAudioNode instanceof EndAudioClip)) {
                        currSyncTime = prevSyncTime;
                        AudioSync sync = (AudioSync)currAudioNode;
                        int syncDelay = sync.getSyncDelay();
                        if (currSyncTime < syncDelay) {
                            currSyncTime = syncDelay;
                        }
                        success = finder.findAudioNode(currAudioNode);
                    } else {
                        success = finder.findAudioNode(currAudioNode);
                        currSyncTime = audioTime;
                        if (finder.virtualDelay > 0 || finder.labelFound) {
                            coalesced = false;
                            currSyncTime += 60;
                            currAudioNode.transientNextDelay(0);
                        }
                    }
                    currAudioNode.transientSyncTime(currSyncTime);
                    int prevDelay = currSyncTime - prevSyncTime;
                    prev.transientNextDelay(prevDelay);
                    prev.transientZoom(this.computeZoom(prevDelay, prevVirtualDelay));
                    prevSyncTime = currSyncTime;
                    prevVirtualDelay = finder.virtualDelay;
                    prev = currAudioNode;
                }
                if (coalesced) {
                    int prevDelay = (audioTime += 60) - prevSyncTime;
                    prev.transientNextDelay(prevDelay);
                    prev.transientZoom(this.computeZoom(prevDelay, prevVirtualDelay));
                }
            }
            curr = finder.getNextNode();
        }
    }

    public double computeZoom(int audioDelay, int virtualDelay) {
        return audioDelay > 0 && virtualDelay > 0 ? (double)audioDelay / (double)virtualDelay : 0.0;
    }

    void dump(byte[] data, int from, int to) {
        int idx = from;
        while (idx < to) {
            short sample = (short)(data[idx] & 0xFF | data[idx + 1] << 8);
            System.out.print(String.valueOf(sample) + " ");
            if (idx % 20 == 0 || idx + 2 == to) {
                System.out.println();
            }
            idx += 2;
        }
    }

    public static class Coalescer
    extends Visitor {
        Finder finder2 = new Finder();
        private int audioTime;
        private byte[] audioData;
        private Queue<AudioClip> clipQueue;

        public final byte[] getAudioData() {
            return this.audioData;
        }

        public final Queue<AudioClip> getClipQueue() {
            return this.clipQueue;
        }

        public final int getAudioTime() {
            return this.audioTime;
        }

        public AudioNode collectBefore(AudioClip startClip, Node from) {
            AudioNode prevSync = startClip;
            this.finder2.findAudioNode(startClip, from);
            Node curr = this.finder2.getNextNode();
            while (curr != null && curr != from) {
                assert (!(curr instanceof AudioClip));
                if (curr instanceof AudioSync) {
                    AudioSync sync = (AudioSync)curr;
                    prevSync = sync;
                }
                this.finder2.findAudioNode(curr, from);
                curr = this.finder2.getNextNode();
            }
            return prevSync;
        }

        public void collectAfter(AudioClip startClip, Node from, Queue<AudioClip> clipQueue, Set<AudioClip> coalesceClips) {
            this.audioTime = startClip.getNextDelay();
            boolean success = this.finder2.findAudioNode(from);
            Node curr = this.finder2.getNextNode();
            while (curr != null && success) {
                if (curr instanceof AudioClip) {
                    AudioClip clip = (AudioClip)curr;
                    if (!clip.getCoalesced()) break;
                    if (clipQueue != null) {
                        clipQueue.add(clip);
                    }
                    if (coalesceClips != null) {
                        coalesceClips.add(clip);
                    }
                }
                this.audioTime += ((AudioNode)curr).getNextDelay();
                success = this.finder2.findAudioNode(curr);
                curr = this.finder2.getNextNode();
            }
        }

        public AudioNode coalesce(AudioClip startClip, Node from, Set<AudioClip> coalesceClips, boolean fade) {
            this.clipQueue = new ArrayDeque<AudioClip>();
            AudioFormat audioFormat = CaptureManager.audioFormat;
            int size2mix = AudioClip.time2size(audioFormat, 60);
            int size2chop = AudioClip.time2size(audioFormat, 10);
            this.clipQueue.add(startClip);
            AudioNode prevSync = this.collectBefore(startClip, from);
            this.collectAfter(startClip, from, this.clipQueue, coalesceClips);
            try {
                AudioClip prev = null;
                AudioClip next = null;
                int bufSize = 4096;
                if (bufSize < size2mix) {
                    bufSize = size2mix;
                }
                assert (bufSize > 1024 && size2mix < bufSize);
                byte[] buf = new byte[bufSize];
                byte[] mixBuf = new byte[size2mix];
                Iterator clipIter = this.clipQueue.iterator();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                InputStream audioStream = null;
                while (true) {
                    boolean eof;
                    boolean match;
                    int rc;
                    next = null;
                    while (clipIter.hasNext()) {
                        AudioClip clip = (AudioClip)clipIter.next();
                        if (clip.getTime() < 70) continue;
                        next = clip;
                        System.out.println("clip size= " + next.getSize());
                        audioStream = next.getAudioStream();
                        AudioManager.audioRead(audioStream, buf, size2chop);
                        AudioManager.audioRead(audioStream, buf, size2mix);
                        break;
                    }
                    int idx = 0;
                    while (idx < size2mix) {
                        int sample1 = 0;
                        int sample2 = 0;
                        if (next != null) {
                            sample1 = (short)(buf[idx] & 0xFF | buf[idx + 1] << 8);
                        }
                        if (prev != null) {
                            sample2 = (short)(mixBuf[idx] & 0xFF | mixBuf[idx + 1] << 8);
                        }
                        int mix = (next == null || prev == null) && !fade ? sample1 + sample2 : (sample1 * idx + sample2 * (size2mix - idx) + size2mix / 2) / (size2mix - 1);
                        buf[idx] = (byte)mix;
                        buf[idx + 1] = (byte)(mix >> 8);
                        idx += 2;
                    }
                    byteArrayOutputStream.write(buf, 0, size2mix);
                    if (next == null) break;
                    int nbytes = next.getSize() - 2 * (size2mix + size2chop);
                    while (nbytes > 0) {
                        rc = AudioManager.audioRead(audioStream, buf, nbytes > bufSize ? bufSize : nbytes);
                        assert (rc > 0);
                        byteArrayOutputStream.write(buf, 0, rc);
                        nbytes -= rc;
                    }
                    prev = next;
                    rc = AudioManager.audioRead(audioStream, mixBuf, size2mix);
                    boolean bl = match = rc == size2mix;
                    assert (match);
                    boolean bl2 = eof = AudioManager.audioRead(audioStream, buf, bufSize) == size2chop;
                    assert (eof);
                    if (!match) {
                        System.out.println("WARNING: only read " + rc + " bytes at the end");
                    }
                    if (eof) continue;
                    System.out.println("WARNING: end of audio stream not found");
                }
                if (audioStream != null) {
                    audioStream.close();
                }
                byteArrayOutputStream.close();
                this.audioData = byteArrayOutputStream.toByteArray();
                System.out.println("audio size= " + this.audioData.length);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                exception.printStackTrace();
            }
            return prevSync;
        }
    }

    public static class Finder
    extends Visitor {
        private int virtualDelay;
        private boolean labelFound;
        private Node found;
        private Node target;

        public AudioNode getAudioNode() {
            return (AudioNode)this.found;
        }

        public Node getNextNode() {
            return this.found;
        }

        public int getVirtualDelay() {
            return this.virtualDelay;
        }

        public boolean findAudioNode(Node node) {
            return this.findAudioNode(node, null);
        }

        public boolean findAudioNode(Node node, Node target) {
            this.virtualDelay = 0;
            this.labelFound = false;
            this.found = null;
            if (node == target) {
                this.found = target;
            } else {
                this.target = target;
                this.traverseAfter(node);
            }
            return !this.labelFound;
        }

        @Override
        public void visit(Node node) throws Exception {
            if (node instanceof Composite && node.isLabel()) {
                this.found = node;
                this.labelFound = true;
                this.stop();
            }
            if (node == this.target || node instanceof AudioClip || node instanceof AudioSync) {
                this.found = node;
                this.stop();
            }
            this.virtualDelay += node.getDelay();
        }

        @Override
        public void postVisit(Composite comp) throws Visitor.StopException {
            this.virtualDelay += comp.getPostDelay();
        }

        public final boolean reverseFindAudioNode(Node node) {
            return this.reverseFindAudioNode(node, null);
        }

        public boolean reverseFindAudioNode(Node node, Node target) {
            this.virtualDelay = 0;
            this.labelFound = false;
            this.found = null;
            if (node == target) {
                this.found = target;
            } else {
                this.target = target;
                this.reverseTraversalBefore(node);
            }
            return !this.labelFound;
        }

        @Override
        public void reverseVisit(Node node) throws Exception {
            if (node == this.target || node instanceof AudioClip || node instanceof AudioSync) {
                this.found = node;
                this.stop();
            }
            if (node.isLabel()) {
                this.labelFound = true;
                this.stop();
            }
            this.virtualDelay += node.getDelay();
        }

        @Override
        public void reversePostVisit(Composite comp) throws Visitor.StopException {
            this.virtualDelay += comp.getPostDelay();
        }
    }

    class PlayTask
    extends Thread {
        SourceDataLine sourceDataLine;
        AudioFormat format = null;
        int skipTime;
        int startSyncTime;
        boolean start = false;
        boolean playing = false;
        boolean aborted = false;
        byte[] audioData;

        PlayTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void startPlaying(int skipTime, int startSyncTime, byte[] audioData) {
            try {
                this.skipTime = skipTime;
                this.startSyncTime = startSyncTime;
                this.audioData = audioData;
                Object object = AudioManager.this.monitor;
                synchronized (object) {
                    if (this.playing) {
                        throw new RuntimeException("Invalid startPlaying");
                    }
                    this.start = true;
                    this.aborted = false;
                    AudioManager.this.monitor.notifyAll();
                    while (this.start) {
                        AudioManager.this.monitor.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        final boolean isPlaying() {
            return this.playing;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void abort() {
            Object object = AudioManager.this.monitor;
            synchronized (object) {
                this.aborted = true;
                AudioManager.this.monitor.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        final boolean waitForAvailability(int size) throws InterruptedException {
            Object object = AudioManager.this.monitor;
            synchronized (object) {
                do {
                    if (this.sourceDataLine.available() >= size) {
                        return true;
                    }
                    if (!AudioManager.this.active) {
                        this.waitForActivation();
                        continue;
                    }
                    AudioManager.this.monitor.wait(16L);
                } while (!this.aborted);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void waitForActivation() throws InterruptedException {
            Object object = AudioManager.this.monitor;
            synchronized (object) {
                int iter = 0;
                while (this.sourceDataLine.available() < this.sourceDataLine.getBufferSize() && this.sourceDataLine.isRunning() && !AudioManager.this.active && !this.aborted) {
                    AudioManager.this.monitor.wait(5L);
                    ++iter;
                }
                while (!AudioManager.this.active && !this.aborted) {
                    AudioManager.this.monitor.wait();
                }
                if (!this.aborted) {
                    AudioManager.this.monitor.wait(5 * iter);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final int getElapsedTime() {
            Object object = AudioManager.this.monitor;
            synchronized (object) {
                if (this.sourceDataLine != null && this.playing) {
                    long pos = this.sourceDataLine.getLongFramePosition();
                    float rate = this.format.getFrameRate();
                    return (int)((float)pos / rate * 1000.0f) + this.skipTime + this.startSyncTime;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setName("PlayTask");
            this.setPriority(10);
            while (true) {
                Object object;
                AudioFormat audioFormat = CaptureManager.audioFormat;
                try {
                    Object object2 = AudioManager.this.monitor;
                    synchronized (object2) {
                        while (!this.start) {
                            AudioManager.this.monitor.wait();
                        }
                        if (AudioManager.this.finished) {
                            return;
                        }
                        this.playing = true;
                        this.start = false;
                        AudioManager.this.monitor.notifyAll();
                        DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, audioFormat);
                        this.sourceDataLine = (SourceDataLine)AudioSystem.getLine(dataLineInfo);
                        this.sourceDataLine.open(audioFormat);
                        this.format = this.sourceDataLine.getFormat();
                        System.out.println("audio opened, buf size=" + this.sourceDataLine.getBufferSize());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.error(e.toString());
                    return;
                }
                this.sourceDataLine.start();
                int bufSize = 4096;
                int currPos = AudioClip.time2size(audioFormat, this.skipTime);
                try {
                    try {
                        System.out.println("playing " + this.audioData.length + " bytes, starting from " + currPos);
                        while (currPos < this.audioData.length) {
                            int slice;
                            int remain = this.audioData.length - currPos;
                            int n = slice = remain > bufSize ? bufSize : remain;
                            if (!this.waitForAvailability(slice)) break;
                            this.sourceDataLine.write(this.audioData, currPos, slice);
                            currPos += slice;
                        }
                        while (this.sourceDataLine.available() < this.sourceDataLine.getBufferSize() && this.sourceDataLine.isRunning()) {
                            Object remain = AudioManager.this.monitor;
                            synchronized (remain) {
                                AudioManager.this.monitor.wait(16L);
                            }
                        }
                    }
                    catch (Scheduler.AbortException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Log.error(e.toString());
                        object = AudioManager.this.monitor;
                        synchronized (object) {
                            this.sourceDataLine.drain();
                            this.sourceDataLine.close();
                            this.sourceDataLine = null;
                            this.playing = false;
                            continue;
                        }
                    }
                }
                catch (Throwable throwable) {
                    object = AudioManager.this.monitor;
                    synchronized (object) {
                        this.sourceDataLine.drain();
                        this.sourceDataLine.close();
                        this.sourceDataLine = null;
                        this.playing = false;
                    }
                    throw throwable;
                }
                object = AudioManager.this.monitor;
                synchronized (object) {
                    this.sourceDataLine.drain();
                    this.sourceDataLine.close();
                    this.sourceDataLine = null;
                    this.playing = false;
                }
            }
        }
    }
}

