#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/resource.h>

#include "porciento.h"

// ----------------------------------------------------
// Funcion que entrega el tiempo transcurrido desde 
// la llamada a resetTime()

static long long time0= 0;

static long long getTime0() {
    struct rusage ru;
    int rc= getrusage(RUSAGE_SELF, &ru);
    if (rc!=0) {
      perror("getTime");
      exit(1);
    }
    return (long long)ru.ru_utime.tv_sec*1000000+ru.ru_utime.tv_usec;
}

static void resetTime() {
  time0= getTime0();
}

static int getTime() {
  return (getTime0()-time0+500)/1000;
}

// ----------------------------------------------------
// Funcion que invoca porciento(s) y verifica que el
// resultado sea ref

static void test(char *s, char *ref) {
  printf("Test: porciento(\"%s\")\n", s);
  char *mut= malloc(strlen(s)+1);
  strcpy(mut, s);
  porciento(mut);
  printf("Resultado: \"%s\"\n", mut);
  if (strcmp(mut, ref)!=0) {
    fprintf(stderr, "Incorrecto.  Debio entregar: \"%s\"\n", ref);
    exit(1);
  }
  free(mut);
  printf("Test aprobado\n");
}

int benchmark(int *plen) {
  int len= *plen;
  char *s= malloc(len+1);
  for (int i=0; i<len;i+=2) {
    s[i]= 'o';
    s[i+1]='/';
  }
  resetTime();
  porciento(s);
  int tiempo= getTime();
  *plen= strlen(s);
  free(s);
  return tiempo;
}

int main(int argc, char *argv[]) {
  int tiempo_prof= -1;
  int len0= 1024*1024;
  int len= 256*1024*1024;
  if (argc==2)
    tiempo_prof= atoi(argv[1]);
  if (tiempo_prof==0) {
    benchmark(&len0);
    printf("%d\n", benchmark(&len));
    return 0;
  }

  test("", "");
  test(" ", " ");
  test("o/o", "%");
  test("o/", "o/");
  test("    ", "    ");
  test("o/oo/oo/oo/oo/o", "%%%%%");
  test("o/o/o/o", "%/%");
  test("el 10o/o del 10o/o es 1o/o o/", "el 10% del 10% es 1% o/");

  if (tiempo_prof>0) {
    int len= 256*1024*1024;
    printf("Benchmark: string de %d caracteres o/o/o/o/...\n", len);
    benchmark(&len0);
    int tiempo= benchmark(&len);
    printf("Largo del resultado es %d\n", len);
    printf("Tomo %d milisegundos\n", tiempo);
    printf("La solucion del profesor tomo %d milisegundos\n", tiempo_prof);
    if (tiempo>3*tiempo_prof/2) {
      printf("Su tiempo excede en 50%% el de la solucion del profesor\n");
      printf("Podria mejorar, pero no se exige eficiencia en esta pregunta\n");
    }
  }

  printf("\nFelicitaciones: paso todos los tests\n");

  return 0;
}
