/*
 * jpipe.h -- definitions for the jpipe char module
 *
 * Copyright (C) 2001 Alessandro Rubini and Jonathan Corbet
 * Copyright (C) 2001 O'Reilly & Associates
 * Original: scull driver
 * Modified: 2008, Jo Piquer
 *
 * The source code in this file can be freely used, adapted,
 * and redistributed in source or binary form, so long as an
 * acknowledgment appears in derived source files.  The citation
 * should list that the code comes from the book "Linux Device
 * Drivers" by Alessandro Rubini and Jonathan Corbet, published
 * by O'Reilly & Associates.   No warranty is attached;
 * we cannot take responsibility for errors or fitness for use.
 */

#ifndef _JPIPE_H_
#define _JPIPE_H_

#include <linux/ioctl.h> /* needed for the _IOW etc stuff used later */

/*
 * Macros to help debugging
 */

#undef PDEBUG             /* undef it, just in case */
#ifdef JPIPE_DEBUG
#  ifdef __KERNEL__
     /* This one if debugging is on, and kernel space */
#    define PDEBUG(fmt, args...) printk( KERN_DEBUG "jpipe: " fmt, ## args)
#  else
     /* This one for user space */
#    define PDEBUG(fmt, args...) fprintf(stderr, fmt, ## args)
#  endif
#else
#  define PDEBUG(fmt, args...) /* not debugging: nothing */
#endif

#undef PDEBUGG
#define PDEBUGG(fmt, args...) /* nothing: it's a placeholder */

#ifndef JPIPE_MAJOR
#define JPIPE_MAJOR 0   /* dynamic major by default */
#endif

#ifndef JPIPE_NR_DEVS
#define JPIPE_NR_DEVS 4    /* jpipe0 through jpipe4 */
#endif

/* status */
#define JPIPE_NOTUSED 0
#define JPIPE_USED 1
#define JPIPE_CLOSED 2

#define JPIPE_MAX_BUF 128

struct jpipe_dev {
	char *buf;			  /* buffer */
        char *in, *out;			  /* in/out pointers */
	char *end; 			  /* end of buffer */
	int  nbytes;			  /* number of bytes in the buffer */
   	int  size;			  /* buffer max size (bytes) */
        int  status;
	int  nrdr, nwrt;
        wait_queue_head_t w_queue, r_queue;
	struct semaphore sem;     /* mutual exclusion semaphore     */
	struct cdev cdev;	  /* Char device structure		*/
};

/*
 * Split minors in two parts
 */
#define TYPE(minor)	(((minor) >> 4) & 0xf)	/* high nibble */
#define NUM(minor)	((minor) & 0xf)		/* low  nibble */


/*
 * The different configurable parameters
 */
extern int jpipe_major;     /* main.c */
extern int jpipe_nr_devs;


/*
 * Prototypes for shared functions
 */

ssize_t jpipe_read(struct file *filp, char __user *buf, size_t count,
                   loff_t *f_pos);
ssize_t jpipe_write(struct file *filp, const char __user *buf, size_t count,
                    loff_t *f_pos);
int     jpipe_ioctl(struct inode *inode, struct file *filp,
                    unsigned int cmd, unsigned long arg);


#endif /* _JPIPE_H_ */
