#include <stdio.h>
#include "tbox1.h"

BOX *createbox()
{
    BOX *b;

    b = (BOX *)malloc(sizeof(BOX));
    pthread_mutex_init(&b->mutex, NULL);
    pthread_cond_init(&b->llenos, NULL);
    pthread_cond_init(&b->vacios, NULL);
    b->in = b->out = 0;
    b->nllenos = 0; b->nvacios = NBUFS; 
    return(b);
}

/* Implementacion para un Productor y un Consumidor */
void putbox(BOX *b, char c)
{
    pthread_mutex_lock(&b->mutex);
    while(b->nvacios == 0)
	pthread_cond_wait(&b->vacios, &b->mutex);
    b->buf[b->in] = c;
    b->in = (b->in+1)%NBUFS;
    b->nllenos++; b->nvacios--;
    pthread_cond_signal(&b->llenos);
    pthread_mutex_unlock(&b->mutex);
}

char getbox(BOX *b)
{
    char c;

    pthread_mutex_lock(&b->mutex);
    while(b->nllenos == 0)
	pthread_cond_wait(&b->llenos, &b->mutex);
    c = b->buf[b->out];
    b->out = (b->out+1)%NBUFS;
    b->nllenos--; b->nvacios++;
    pthread_cond_signal(&b->vacios);
    pthread_mutex_unlock(&b->mutex);
    return(c);
}
