#include <stdio.h>
#include "tbox-sem.h"

BOX *createbox()
{
    BOX *b;

    b = (BOX *)malloc(sizeof(BOX));
    sem_init(&b->vacios, 0, NBUFS);
    sem_init(&b->llenos, 0, 0);
    b->in = b->out = 0;
    return(b);
}

/* Implementacion para un Productor y un Consumidor */
void putbox(BOX *b, char c)
{
    sem_wait(&b->vacios);
    b->buf[b->in] = c;
    b->in = (b->in+1)%NBUFS;
    sem_post(&b->llenos);
}

char getbox(BOX *b)
{
    char c;

    sem_wait(&b->llenos);
    c = b->buf[b->out];
    b->out = (b->out+1)%NBUFS;
    sem_post(&b->vacios);
    return(c);
}
