#include <stdio.h>
#include "stack.h"

struct nodo {
    struct nodo *next;
    int val;
};

static struct nodo *Head = NULL;

int pop() {
    struct nodo *p = Head;
    int val;

    val = p->val;
    Head = p->next;
    free(p);
    return val;
}

void push(int val) {
    struct nodo *p;

    p = (struct nodo *)malloc(sizeof(struct nodo));
    if(p == NULL) {
	fprintf(stderr, "Push: no mem\n");
	exit(1);
    }
    p->val = val;
    p->next = Head;
    Head = p;
}

void dump() {
    struct nodo *p = Head;

    while(p != NULL) {
	putchar(p->val+'0');
	p = p->next;
    }
    putchar('\n');
}
