#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dict.h"

#define MAX_LINE 255

void print2(char *s, void *cnt) {
    printf("%s: %d\n", s, *(int *)cnt);
}

main() {
    char s[MAX_LINE];
    DICT *dict;
    int *cnt;
    char *str;

    dict = init_dict();

    while( fgets(s, MAX_LINE, stdin) != NULL) {
	if(s[strlen(s)-1] == '\n')
	   s[strlen(s)-1] = '\0';

	str = strdup(s);
	if(str == NULL) {
	    fprintf(stderr, "No mem!\n");
	    exit(1);
 	}
	cnt = search_dict(dict, str);
	if(cnt == NULL) {
	    cnt = (int *)malloc(sizeof(int));
	    if(cnt == NULL) {
		fprintf(stderr, "out of mem\n");
		exit(1);
	    }
	    *cnt = 1;
	    add_dict(dict, str, cnt);
	}
	else { 
	    free(str); /* Ya estaba, no lo necesito ahora */
	    (*cnt)++;
	}
    }

    apply_dict(dict, print2);
    stats_dict(dict);
}
