#include <stdio.h>
#include <stdlib.h>
#include "dict-lista.h"

/* 
 * Tipo diccionario, implementado con listas enlazadas
 */

/*
 * El primer elemento es una cabecera de lista que NO SE USA 
 */

DICT *init_dict() {
    DICT *p;

    p = (DICT *)malloc(sizeof(DICT));
    if(p == NULL) {
	fprintf(stderr, "No mem!\n");
	exit(1);
    }
    p->val = NULL;
    p->next = NULL;
    p->llave = NULL;
    return p;
}

void add_dict(DICT *d, char *llave, void *val) {
    DICT *p, *q;

    for(p = d; p->next != NULL && strcmp(p->next->llave, llave) < 0 ; p=p->next)
			;

    if(p->next != NULL && strcmp(p->next->llave, llave) == 0)
	p->next->val = val;
    else {
        q = (DICT *)malloc(sizeof(DICT));
	q->val = val; q->llave = llave;
	q->next = p->next;
	p->next = q;
    }
}
 
void *search_dict(DICT *d, char *llave) {
    DICT *p;

    for(p = d; p->next != NULL && strcmp(p->next->llave, llave) < 0 ; p=p->next)
                        ; 
    if(p->next == NULL || strcmp(p->next->llave, llave) != 0)
	return NULL;

    return p->next->val;
}

void apply_dict(DICT *d, void (*f)(char *llave, void *val)) {
    DICT *p;

    for(p = d->next; p != NULL; p=p->next)
	f(p->llave, p->val);
}

void stats_dict(DICT *d) {
    int cnt = 0;
    DICT *p;
    
    for(p = d->next; p != NULL; p=p->next)
	cnt++;

    printf("DICT lista nodos = %d\n", cnt);
}
