#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "dict-abb.h"

/* 
 * Tipo diccionario, implementado con Arboles Binarios de Busqueda
 */

/*
 * Todas las funciones _abb son internas de la implementacion
 * y son llamadas por la interfaz oficial de  DICT 
 */

DICT *init_dict() {
    DICT *p;

    p = (DICT *)malloc(sizeof(DICT));
    if(p == NULL) {
	fprintf(stderr, "No mem!\n");
	exit(1);
    }
    p->head = NULL;
    return p;
}

/*
 * Inserta un par en un ABB
 * y retorna el nuevo ABB (con el par ya insertado)
 */
TREE *add_abb(TREE *t, char *llave, void *val) {
    TREE *q; 
    int cmp;

    if(t == NULL) {  /* Insertar en un arbol vacio */
	q = (TREE *) malloc(sizeof(TREE));
    	if(q == NULL) {
	    fprintf(stderr, "No mem!\n");
	    exit(1);
    	}
	q->llave = llave; q->val = val;
	q->left = q->right = NULL;
        return q;
    }

    cmp = strcmp(llave, t->llave);
    if(cmp < 0)
	t->left = add_abb(t->left, llave, val);
    else if(cmp == 0)
	t->val = val;
    else
	t->right = add_abb(t->right, llave, val);

    return t;
}

void *search_abb(TREE *t, char *llave) {
    int cmp;

    if(t == NULL) return NULL;

    cmp = strcmp(llave, t->llave);
    if(cmp < 0)
	return search_abb(t->left, llave);
    else if(cmp == 0)
	return t->val;
    else
	return search_abb(t->right, llave);
}

void apply_abb(TREE *t, void (*f)(char *llave, void *val)) {

    if(t == NULL) return;

    apply_abb(t->left, f);
    f(t->llave, t->val);
    apply_abb(t->right, f);
}

int nodos_abb(TREE *t) {
    if(t == NULL) return 0;

    return(nodos_abb(t->left)+nodos_abb(t->right)+1);
}

int max(int a, int b) {
    return (a > b) ? a : b; 
}

int altura_abb(TREE *t) {
    if(t == NULL) return -1;

    return(max(altura_abb(t->left), altura_abb(t->right))+1);
}

void add_dict(DICT *d, char *llave, void *val) {

    d->head = add_abb(d->head, llave, val);
}
 
void *search_dict(DICT *d, char *llave) {

    return search_abb(d->head, llave);
}

void apply_dict(DICT *d, void (*f)(char *llave, void *val)) {

    apply_abb(d->head, f);
}

void stats_dict(DICT *d) {

    printf("Dict ABB: nodos = %d, altura = %d\n", nodos_abb(d->head),
                                                  altura_abb(d->head));
}
